package com.digiwin.athena.knowledgegraph.domain;

import com.digiwin.athena.kg.domain.CodedEntity;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.kg.activity.LifeActivity;
import com.digiwin.athena.knowledgegraph.domain.config.AssignConfig;
import com.digiwin.athena.knowledgegraph.domain.task.DueDateTimeDistance;
import com.digiwin.athena.kg.action.Action;
import lombok.Data;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.Transient;

import java.util.List;
import java.util.Map;

/**
Task
 **/
@NodeEntity
@Data
public class Task extends CodedEntity {

    private String name;
    //项目任务要素设定  顺序
    private String sequence;

    //流程id
    private String processId;

    private Integer emergency;
    //任务来源名称
    private Object sourceName;

    //应用名称
    private String nameSpace;

    private DueDateTimeDistance dueDateTimeDistance;

    private DueDateTimeDistance dateTimeDistance;

    //包含的活动
    @Relationship(type = "Contains",direction = Relationship.OUTGOING)
    private List<Activity> activities;

    //需要的参数
    @Relationship(type = "Requires",direction = Relationship.OUTGOING)
    private List<ProcessParameter> parameters;

//    @Relationship(type = "TRANSLATION",direction = Relationship.OUTGOING)
//    private List<Language> languages;

    @Relationship(type = "Archives",direction = Relationship.OUTGOING)
    private TaskTarget target;

    //负责人
    @Relationship(type = "ResponsibleFor",direction = Relationship.INCOMING)
    private PersonInCharge chargePerson;

    //知会人
    @Relationship(type = "NotifyFor",direction = Relationship.INCOMING)
    private PersonInCharge notifyParty;

    // BUSINESS FEEDBACK
    private String type;


    //是否支持手动发起
    private Boolean manualAble;
    //手动发起任务时指向的actionId
    private String startActionId;
    @Relationship(type = "preset")
    private List<LifeActivity> presetActivities;



    //dto
    private String taskId;
    private Object taskName;
    private Boolean completedReport;
    private String taskTargetId;
    private Object taskTargetName;
    private Object dueDateName;

    //是否支持项目合并 值为null时合并
    private Boolean merge;
    //来源实体名称
    private String sourceEntityName;
    //json 获取来源单据详细数据的API
    private Action sourceDetailAction;
    //合并字段名数组
    private List<String> mergeFields;


    //项目的类型
    private String pattern;
    //数据源
    @Transient
    private Map<String, Object> dataSources;
    //数据查询器
    @Transient
    private List<Map<String, Object>> dataFilters;
    //数据加工器
    @Transient
    private List<Map<String, Object>> dataProcessors;
    //页面
    @Transient
    private Map<String, Object> pages;
    //项目分组内容
    @Transient
    private Map<String, Object> groupSetting;

    //定义任务可转派范围
    private UserDefinition assignTo;
    private Boolean assignAble;
    private AssignConfig assignConfig;

    //其他关联人
    private UserDefinition relatedUsers;

    //权限控制相关，格式为 应用code:模组code
    private String authorityPrefix;

    private String description;

    private Boolean supportCustomTimeDuration;

    private Integer timeDuration;

    private Map<String,Object> config;

    @Transient
    private List<Identity> presetVariables;

    /**
     * 隐藏交付设计器自定义项目设置
     */
    private Boolean hideDeliverySetting;


    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        } else if (!(o instanceof Task)) {
            return false;
        } else {
            Task other = (Task)o;
            if(this.getCode().equals(other.getCode()) && this.getVersion().equals(other.getVersion())){
                return true;
            }else {
                return false;
            }
        }
    }

    @Override
    public int hashCode() {
        int result = 17; // Arbitrary non-zero constant
        result = 31 * result + (getCode() != null ? getCode().hashCode() : 0);
        result = 31 * result + (getVersion() != null ? getVersion().hashCode() : 0);
        return result;
    }


}
