package com.digiwin.athena.knowledgegraph.domain.digitalstaff;

import lombok.Data;

import java.util.Map;

/**
 * 将从接口“https://atmc-paas.apps.digiwincloud.com.cn/api/atmc/v1/taskBacklog/history/findTaskBacklogH”
 * 获取的结果数据存储并按时间进行排序，所以如果这个接口的返回数据修改，这里的结果需要修改 <br>
 *
 * @author wang.xinyuan<br>
 * @version 1.0<br>
 * @taskId <br>
 * @CreateDate 2021/11/14 <br>
 * @see: com.digiwin.athena.knowledgegraph.domain.digitalstaff.TaskHistory <br>
 */
@Data
public class TaskHistory {

    private Integer id;
    private String type;
    private String name;
    private String state;
    private Integer isProxy;
    private String startTime;
    private String endTime;
    private String closedTime;
    private String proxyUserId;
    private Map<String, Object> extraTimeMap;
    // 记录当前任务名称下的完成任务总数
    private Integer totalJobNum;

}