package com.digiwin.athena.knowledgegraph.domain.targets;

import com.digiwin.athena.knowledgegraph.domain.common.LanguageEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Document(collection="target")
public class Target extends LanguageEntity {

    @Id
    private String objectId;
    private String tenantId;
    private String id;
    @Transient
    private String periodKey;
    @Transient
    private String value;
    private String name;
    private String tendency;
    private String tendencyName;
    private String period;
    private String unit;
    private String precision;
    private String description;
    private String target;
    private String warningStage;
    private List<String> personInCharge;
    private Boolean enabled;
    private String code;
    /**
     * 类型 topic,paradigm,mechanism,business,usertrack
     */
    private String type;

}
