package com.digiwin.athena.knowledgegraph.domain.targets;

import com.digiwin.athena.knowledgegraph.domain.common.LanguageEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;

import java.util.LinkedList;
import java.util.List;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class TargetNode extends LanguageEntity {

    @Id
    private String objectId;
    private String id;
    @Transient
    private String name;
    @Transient
    private Boolean enabled;
    private String nodeId;
    private List<TargetNode> children;

    public synchronized void addChildren(TargetNode child) {
        if (null == children) {
            children = new LinkedList<>();
        }
        children.add(child);
    }

}
