package com.digiwin.athena.knowledgegraph.domain.topic;

import com.digiwin.athena.knowledgegraph.domain.common.LanguageEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;
import java.util.List;

/**
 * 议题实体
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Document(collection = "topic")
public class Topic extends LanguageEntity {

    @Id
    private String objectId;

    /**
     * 议题code
     */
    private String code;

    /**
     * 议题名称
     */
    private String name;

    /**
     * 描述说明
     */
    private String description;

    /**
     * 关联应用
     */
    private List<String> relatedApps;

    /**
     * 版本
     */
    private String version;

    /**
     * 发版更新数据用(目前暂时用不到)，默认为common
     *
     */
    private String application;

    /**
     * 议题状态 0.删除 1.有效
     */
    private Integer status;

    /**
     * 创建者
     */
    private Object createBy;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 更新者
     */
    private Object editBy;

    /**
     * 更新时间
     */
    private Date editDate;
}
