package com.digiwin.athena.knowledgegraph.domain2.mechanism;

import com.digiwin.athena.kg.domain.DomainEntity;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2020-10-14 13:38
 **/
@Data
public class MechanismAchiveRecord extends DomainEntity implements Comparable<MechanismAchiveRecord> {

    //一次事件的唯一标识
    private String instanceId;
    //对应机制的key
    private String mechanismKey;
    private String key;
    private String name;
    private Object value;
    //0新建 1激活  2禁用
    private Integer recordStatus;
   // 0新发起 1已同意 2已拒绝 3审核通过 4审核不通过
    private Integer status;
    private String product;
    private Date createTime;
    private long updateTime;
    private String remark;
    private Boolean valueIsArray;
    private List<String> valueKeys;
    private Boolean batchAll;


    @Override
    public int compareTo(MechanismAchiveRecord o) {
        return (int) (o.getUpdateTime() - this.getUpdateTime());
    }


    public String entityBizCode(){
        return key;
    }

}
