package com.digiwin.athena.knowledgegraph.dto.report;

import com.alibaba.fastjson.JSONObject;
import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
@Builder
public class PushDataSetDTO {
    private String applicationCode;
    private String applicationName;
    private String version;
    private List<PushDataSetContentDTO> dataSetDto;

    @Data
    @Builder
    public static class  PushDataSetContentDTO {
        private String datasetId;
        private String datasetName;
        public Map<String, Map<String, String>> lang;
        private String billingGoodsId;
        private List<Object> dimensions;
        private List<Object> measures;
        private String description;
        private String modelId;
        private String modelCode;
        private List<JSONObject> questions;
        private String quickQuestion;
        private List<Object> metrics;
        private List<Object> entities;
        private List<Object> modules;
      }


}
