package com.digiwin.athena.knowledgegraph.mechanism;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.mechanism.bo.ControlAbilityBO;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.pre.MechanismCapacity;
import org.springframework.stereotype.Service;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-03-09 10:14
 **/

@Service
public class MechanismCapacityControlParser extends AbstractMechanismCapacityParser{

    @Override
    public boolean accept(MechanismCapacity capacity) {
        return ComponentTypeEnum.MechanismControl.name().equals(capacity.getType());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismCapacity capacity) throws DWBusinessException {

        MechanismAbility logic = new ControlAbilityBO();
        context.setLogic(logic);

        super.parsePart(context, capacity.getSource());
        super.parsePart(context, capacity.getCheck());
        super.parsePart(context, capacity.getAction());

    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismCapacity capacity, String parentNode) throws DWBusinessException {

        String sourceNode =super.doGenerateCypherPart(context, capacity.getSource());
        String checkNode =super.doGenerateCypherPart(context, capacity.getCheck());
        String actionNode =super.doGenerateCypherPart(context, capacity.getAction());
        super.doGenerateCypherPartRelation(context, checkNode, sourceNode,"CHECK");
        super.doGenerateCypherPartRelation(context, checkNode, actionNode,"ACTION");



    }


}
