package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.pre.MechanismCapacityCodes;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.ConditionsPart;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.condition.BusinessCondition;
import com.digiwin.athena.mechanism.widgets.config.RuleContent;
import com.digiwin.athena.mechanism.widgets.config.RuleTrigger;
import com.digiwin.athena.mechanism.widgets.plan.LimitPlan;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * 限制能力  业务条件
 *
 * @author tang jie cheng
 * @date 2023-03-27 13:25
 */
@Service
public class BusinessConditionParser extends AbstractMechanismPartParser {

    @Override
    public boolean accept(MechanismPart part) {
        return MechanismCapacityCodes.businessCondition.equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) {
        ConditionsPart conditionsPart = (ConditionsPart) part;
        BusinessCondition businessCondition = conditionsPart.getBusinessCondition();
        LimitAbilityBo logic = (LimitAbilityBo) context.getLogic();
        List<SingleStrategyWidget> strategies = ObjectUtils.isEmpty(logic.getStrategies()) ? new ArrayList<>() :
                logic.getStrategies();
        SingleStrategyWidget singleStrategyWidget = new SingleStrategyWidget();
        singleStrategyWidget.setType("singleChoose");
        singleStrategyWidget.setBusinessCondition(businessCondition);
        LimitPlan limitPlan = new LimitPlan();
        RuleContent ruleContent = new RuleContent();
        RuleTrigger ruleTrigger = new RuleTrigger();
        limitPlan.setLimitType("businessCondition");
        limitPlan.setConditionPatch(businessCondition.getConditionPatch());
        limitPlan.setConditionType(MechanismCapacityCodes.businessCondition);
//        HashMap<String, MechanismConditionConfig> map = new HashMap<>();
//        List<MechanismConditionGroup> groups = businessCondition.getGroups();
//        for (MechanismConditionGroup group : groups) {
//            List<MechanismConditionConfig> conditions = group.getConditions();
//            for (MechanismConditionConfig condition : conditions) {
//                if (condition.getType().equals("highGrade")) {
//                    map.put("highGrade", condition);
//                }
//            }
//        }
//        if (map.containsKey("highGrade")) {
//            MechanismConditionConfig highGrade = map.get("highGrade");
//            //https://uibot-paas.apps.digiwincloud.com.cn
//            ruleTrigger.setApiUrl("/api/ai/v1/bot/template/basic-data/show/" + highGrade.getLeft().getCode());
//            ruleTrigger.setApiPrefixType("uibotUrl");
//            ruleTrigger.setMethod("GET");
//            ruleTrigger.setApiMethodType("get");
//            ruleTrigger.setType("async");
//        }

        String parameterScript = "";
        ruleTrigger.setApiUrl("/datamap/action/judgeBusinessCondition");
        ruleTrigger.setApiPrefixType("knowledgeMapsUrl");
        ruleTrigger.setMethod("POST");
        ruleTrigger.setApiMethodType("post");
        ruleTrigger.setType("async");
        ruleTrigger.setParameterScript(parameterScript);
        ruleContent.setTrigger(ruleTrigger);
        limitPlan.setRuleContent(ruleContent);
        singleStrategyWidget.setPositiveTarget(limitPlan);
        strategies.add(singleStrategyWidget);
        logic.setStrategies(strategies);

        if(null!=logic){
            logic.setBusinessCondition(businessCondition);
        }
    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        ConditionsPart conditionsPart = (ConditionsPart) part;
        String code = conditionsPart.getCode();
        String nodeId = "widget_" + UUID.randomUUID().toString().replaceAll("-", "");
        context.getCypherSb().append("create(").append(nodeId).append(":MechanismWidget:MechanismComponent{")
                .append("code").append(":'").append(code).append("',")
                .append("name").append(":'").append("业务条件").append("',")
                .append("type").append(":'").append("businessCondition").append("',")
                .append("pluginId").append(":'").append(context.getPluginId()).append("'")
                .append("})\r\n")
        ;
        context.getCypherSb().append("create(").append(parentNode).append(")-[:WIDGET]->(").append(nodeId).append(")" +
                "\r\n");
    }

}
