package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.pre.MechanismCapacityCodes;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.LimitSourceTaskPart;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.stream.Collectors;

/**
 * 限制能力 任务执行中  分为 打开时（无选择）/修改时（可填task中的字段）
 *
 * @author tang jie cheng
 * @date 2023-03-27 13:25
 */
@Service
public class LimitSourceTaskParser extends AbstractMechanismPartParser {

    @Override
    public boolean accept(MechanismPart part) {
        return MechanismCapacityCodes.sourceTaskInExecution.equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) {
        //目标任务放入上下文
        LimitSourceTaskPart limitSourceTaskPart = (LimitSourceTaskPart) part;
        SourceWidget targetSource = limitSourceTaskPart.getTargetSource();
        if (!CollectionUtils.isEmpty(limitSourceTaskPart.getFields())) {
            targetSource.setWatchFields(limitSourceTaskPart.getFields()
                    .stream().map(v -> v.getData_name()).collect(Collectors.toList()));
        }
        // 由前端传入sourcePage
        // targetSource.setSourcePage("tdd");
        context.getNamedParams().put(MechanismParseContext.Names.fields, limitSourceTaskPart.getFields());
        context.setTargetSource(targetSource);
        LimitAbilityBo logic = new LimitAbilityBo();
        logic.setCheckSource(targetSource);
        context.setLogic(logic);
    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        LimitSourceTaskPart sourcePart = (LimitSourceTaskPart) part;
        SourceWidget targetSource = sourcePart.getTargetSource();
        super.generateCypherSimple(context, targetSource, parentNode);
    }
}
