package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kg.monitorRule.MonitorRule;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProduct;
import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.mechanism.bo.DriveAbilityBo;
import com.digiwin.athena.mechanism.pre.MechanismCapacityCodes;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.SourceSchedulePart;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.source.ScheduleApiSourceWidget;
import com.digiwin.athena.mechanism.widgets.source.ScheduleSourceWidget;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;

/**
 * @program: codes
 * @description: 都是硬扯
 * @author: Tuo
 * @create: 2023-03-09 10:22
 **/

@Service
@Slf4j
public class SourceScheduleParser extends AbstractMechanismPartParser {

    @Override
    public boolean accept(MechanismPart part) {
        return MechanismCapacityCodes.sourceSchedule.equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) {

        SourceSchedulePart sourceSchedulePart = (SourceSchedulePart) part;
        SourceWidget targetSource = sourceSchedulePart.getTargetSource();
        ScheduleApiSourceWidget scheduleSource = sourceSchedulePart.getScheduleSource();
        context.setTargetSource(targetSource);

        DriveAbilityBo logic = new DriveAbilityBo();
        String uid = monitorCode(context);
        logic.setProjectCode(uid);
        logic.setMonitorRuleId(uid);
        ScheduleSourceWidget scheduleSourceWidget = new ScheduleSourceWidget();
        MonitorRule monitorRule = new MonitorRule();
        scheduleSourceWidget.setMonitorRule(monitorRule);
        scheduleSourceWidget.setDataCode("mechanism_CheckTaskOnTimeOver");
        scheduleSourceWidget.setType("scheduleSource");
        logic.setCheckSource(scheduleSourceWidget);
        context.setLogic(logic);
        //自由自定义的时候保持原有逻辑
       if(!Objects.isNull(scheduleSource.getStandardPollingRule())){
           monitorRule.setStandardPollingRule(scheduleSource.getStandardPollingRule().toStandardPollingRule());
       }
        monitorRule.setCode(uid);
        monitorRule.setName(context.getCapacity().getName());
        monitorRule.setCategory("API");
        monitorRule.setType("CUSTOM");
        monitorRule.setProduct(new ArrayList<>());
        MonitorRuleProduct product  = new MonitorRuleProduct();
        product.setCode("Athena");
        monitorRule.getProduct().add(product);
        //todo 暂时不知道赛啥,需要后面补齐，这个设定真扯淡，罗群确认了要这么搞
        monitorRule.setMonitorActionId(scheduleSource.getActionId());

        //todo 侦测参数其实是后面必须要有个action的入参

        //monitorRule.setDynamicParams();




    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {

        SourceSchedulePart sourceSchedulePart = (SourceSchedulePart) part;
        SourceWidget targetSource = sourceSchedulePart.getTargetSource();
        ScheduleApiSourceWidget scheduleSource = sourceSchedulePart.getScheduleSource();

        if(null!=targetSource){
            String nodeId = "widget_"+ UUID.randomUUID().toString().replaceAll("-","");
            context.getCypherSb().append("create(").append(nodeId).append(":MechanismWidget:MechanismComponent{")
                    .append("code").append(":'").append(targetSource.getCode()).append("',")
                    .append("name").append(":'").append(targetSource.getName()==null?"Widget_"+targetSource.getType():targetSource.getName()).append("',")
                    .append("type").append(":'").append(targetSource.getType()).append("',")
                    .append("target").append(":'").append(targetSource.getTarget()).append("',")
                    .append("targetName").append(":'").append(targetSource.getTargetName()).append("',")
                    .append("pluginId").append(":'").append(context.getPluginId()).append("'")
                    .append("})\r\n")
            ;
            context.getCypherSb().append("create(").append(parentNode).append(")-[:WIDGET]->(").append(nodeId).append(")\r\n");
        }

        if(null!=scheduleSource){
            String nodeId = "widget_"+ UUID.randomUUID().toString().replaceAll("-","");
            context.getCypherSb().append("create(").append(nodeId).append(":MechanismWidget:MechanismComponent{")
                    .append("code").append(":'").append(scheduleSource.getCode()).append("',")
                    .append("name").append(":'").append(scheduleSource.getName()==null?"Widget_"+scheduleSource.getType():scheduleSource.getName()).append("',")
                    .append("type").append(":'").append(scheduleSource.getType()).append("',")
                    .append("standardPollingRule").append(":'").append(JSON.toJSONString(scheduleSource.getStandardPollingRule())).append("',")
                    .append("pluginId").append(":'").append(context.getPluginId()).append("'")
                    .append("})\r\n")
            ;
            context.getCypherSb().append("create(").append(parentNode).append(")-[:WIDGET]->(").append(nodeId).append(")\r\n");
        }

    }


    public String monitorCode(MechanismParseContext context){
        try {
            return  context.getCapacity().getCode()+ AthenaUtils.getTenantId();
        } catch (DWBusinessException e) {
            log.warn("构建monitorCode异常");
        }
        return context.getCapacity().getCode()+ context.getTenantId();
    }
}
