package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.mechanism.pre.MechanismCapacityCodes;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.SourceSchedulePart;
import com.digiwin.athena.mechanism.pre.parts.SourceTargetPart;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import org.springframework.stereotype.Service;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-03-29 15:27
 **/
@Service
public class SourceTaskParser extends AbstractMechanismPartParser {
    @Override
    public boolean accept(MechanismPart part) {
        return MechanismCapacityCodes.sourceTask.equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) throws DWBusinessException {
        SourceTargetPart sourcePart = (SourceTargetPart) part;
        SourceWidget targetSource = sourcePart.getTargetSource();
        if(null!=context.getLogic()){
            context.getLogic().setCheckSource(targetSource);
        }

    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        SourceTargetPart sourcePart = (SourceTargetPart) part;
        SourceWidget targetSource = sourcePart.getTargetSource();
        super.generateCypherSimple(context,targetSource,parentNode);

    }
}
