package com.digiwin.athena.knowledgegraph.rule;

import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kg.monitorRule.MonitorRuleTenantConfig;
import com.digiwin.athena.knowledgegraph.service.IManageMonitorRuleConfigService;
import com.digiwin.athena.knowledgegraph.service.model.MonitorRuleConfigDTO;
import com.digiwin.athena.knowledgegraph.service.model.MonitorRuleConfigRemoveDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author lzw
 * @date 2024/12/10
 * @description:
 **/
@MyExceptionHandler
@Service
@Slf4j
public class ManageMonitorRuleConfigService implements IManageMonitorRuleConfigService {

    @Autowired
    @Qualifier("knowledgegraphTenant")
    private MongoTemplate mongoTemplate;

    @Autowired
    MonitorRuleConfigService monitorRuleConfigService;

    /**
     * 删除运营单元后  清除侦测（用于OM平台删除运营单元后的回调接口）
     * @param monitorRuleConfigRemoveDto
     * @return
     * @throws Exception
     */
    @Override
    public Object postRemoveMonitorRuleConfig(MonitorRuleConfigRemoveDto monitorRuleConfigRemoveDto) throws Exception {
        log.warn("MonitorRuleConfigNewService.postRemoveMonitorRuleConfig start, param={}",monitorRuleConfigRemoveDto);
        //校验租户id和公司id不为空
        if (null == monitorRuleConfigRemoveDto || StringUtils.isEmpty(monitorRuleConfigRemoveDto.getTenantId()) || StringUtils.isEmpty(monitorRuleConfigRemoveDto.getCorpId()) ){
            log.warn("MonitorRuleConfigNewService.postRemoveMonitorRuleConfig parameter error param={}",monitorRuleConfigRemoveDto);
            return null;
        }
        //
        Query query = new Query();
        Criteria criteria = new Criteria();
//        criteria.and("tenantId").is("IGPtest").and("eocMap").ne (null).and("eocMap.eocCompanyId").is("G-SH");
        criteria.and("tenantId").is(monitorRuleConfigRemoveDto.getTenantId())
                .and("eocMap").exists(true) // 先确保eocMap字段存在
                .and("eocMap.eocCompanyId").is(monitorRuleConfigRemoveDto.getCorpId()); // 然后检查eocCompanyId
        if (StringUtils.isNotEmpty(monitorRuleConfigRemoveDto.getFactoryId())){
            criteria.and("eocMap.eocSiteId").is(monitorRuleConfigRemoveDto.getFactoryId());
        }
        query.addCriteria(criteria);
        List<MonitorRuleTenantConfig> monitorRuleTenantConfigs = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);

        if (CollectionUtils.isNotEmpty(monitorRuleTenantConfigs)){
            for (MonitorRuleTenantConfig config : monitorRuleTenantConfigs){
                MonitorRuleConfigDTO configDTO = transToMonitorRuleConfigDTO(config);
                if (null != configDTO){
                    monitorRuleConfigService.delete(configDTO);
                }

            }
        }

        return null;
    }

    private MonitorRuleConfigDTO transToMonitorRuleConfigDTO(MonitorRuleTenantConfig config) {
        if (null == config){
            return null;
        }
        MonitorRuleConfigDTO configDTO = new MonitorRuleConfigDTO();
        configDTO.setTenantId(config.getTenantId());
        configDTO.setMonitorRuleId(config.getMonitorRuleId());
        configDTO.setEocMap(config.getEocMap());
        return configDTO;
    }
}
