package com.digiwin.athena.knowledgegraph.rule.parameter;

import com.digiwin.athena.knowledgegraph.constant.Constants;
import com.digiwin.athena.knowledgegraph.po.PhPMechanismApiCommonConfig;
import com.digiwin.athena.knowledgegraph.rule.AbstractMonitorRuleMechanismParameterService;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;

@Slf4j
@Service
public class PhpTaskOverdueWarningParameterService extends AbstractMonitorRuleMechanismParameterService<String,String> {
    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;

    @Override
    public boolean accept(String code) {
        Query query = Query.query(Criteria.where("code").is(Constants.ApiAction.code));
        PhPMechanismApiCommonConfig phPMechanismApiCommonConfig=mongoTemplateSystem.findOne(query,PhPMechanismApiCommonConfig.class);
        if(!Objects.isNull(phPMechanismApiCommonConfig)) {
            String source = phPMechanismApiCommonConfig.getAction_id_prefix() + "." + phPMechanismApiCommonConfig.getPhp_task_overdue_warning() + "." + phPMechanismApiCommonConfig.getBefore_task_day();
            return source.equals(code);
        }
        return false;
    }

    @Override
    public String parse(String value) {
        String intValue;
        if (value.indexOf(".") > 0) {
            intValue = value.substring(0, value.indexOf("."));
        } else {
            intValue = value;
        }
        Integer beforeTaskDay = Integer.valueOf(intValue);
        ArrayList<String> objects = Lists.newArrayList();
        IntStream.range(1,4).forEach(i->objects.add(String.valueOf(i*beforeTaskDay)));
        return Joiner.on(",").join(objects);
    }
}
