package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;

import java.util.List;

/**
 * 缓存服务
 * @javadoc
 */
public interface ICacheService  extends DWService {
    /**
     * 根据key集合批量删除缓存
     * @param keys key集合
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    Object deleteKeys(List<String> keys) throws Exception;

    /**
     * 根据key匹配表达式删除缓存
     * @param keyPattern key匹配表达式
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    Object deleteWithPattern(String keyPattern) throws Exception;

    /**
     * 根据key匹配表达式批量删除缓存
     * @param keyPatterns key匹配表达式
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    Object deleteWithPattern(List<String> keyPatterns) throws Exception;

    /**
     * 根据key获取缓存
     * @param key
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    Object getData(String key) throws Exception;

    /**
     * 根据key值设置缓存值
     * @param key key值
     * @param value value值
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    Object getSetData(String key, String value) throws Exception;
}
