package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.service.DWService;
import com.digiwin.athena.knowledgegraph.dto.report.dataCollect.DataCollectConfig;
import com.digiwin.athena.kg.report.hz.model.dataCollect.QueryConfigDTO;
import com.digiwin.athena.knowledgegraph.dto.report.dataCollect.QueryCollectDTO;

/**
 * 敏数 - 收藏数据服务
 * @javadoc
 */
public interface IDataCollectService extends DWService {
    /**
     * 新增收藏数据配置
     * @param config
     * @return
     * @throws Exception
     */
    Object postAddDataCollectConfig(DataCollectConfig config) throws Exception;

    /**
     * 获取收藏数据配置
     * @return
     * @throws Exception
     */
    Object getQueryDataCollectConfig() throws Exception;

    /**
     * 根据code删除藏数据配置
     * @param asaCode
     * @return
     * @throws Exception
     */
    Object getQueryDataCollectConfig(String asaCode) throws Exception;

    /**
     * 查询收藏数据配置
     * @param queryConfig 查询条件
     * @return
     * @throws Exception
     */
    Object postQueryDataCollectConfig(QueryConfigDTO queryConfig) throws Exception;

    /**
     * 删除收藏数据配置
     * @param config 配置信息
     * @return
     * @throws Exception
     */
    Object postRemoveDataCollectConfig(DataCollectConfig config) throws Exception;

    /**
     * 根据问题id查询
     * @param questionId 问题id
     * @return
     * @throws Exception
     */
    Object postQueryCollectStep(String questionId);

    /**
     * 根据配置更新收藏数据
     * @param config 配置信息
     * @return
     * @throws Exception
     */
    Object postUpdateCollectByConfig(QueryCollectDTO config) throws Exception;
}
