package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWService;

import java.util.List;

/**
 * 数据字段服务
 * @javadoc
 */
public interface IDictService extends DWService {
    /**
     * 根据key获取字典信息
     * @param key 字典key
     * @return
     * @throws DWBusinessException
     */
    Object getDictByKey(String key) throws DWBusinessException;

    /**
     * 根据字典key值和code值获取数据
     * @param key 键值
     * @param code code值
     * @return
     * @throws DWBusinessException
     */
    Object getDictByKeyAndCode(String key, String code) throws DWBusinessException;

    /**
     * 根据字典key值集合获取字典数据
     * @param keyList 键值集合
     * @return
     * @throws DWBusinessException
     */
    Object postFindDictByKeyList(List<String> keyList) throws DWBusinessException;
}
