package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.knowledgegraph.domain.task.EmailView;
import com.digiwin.athena.knowledgegraph.po.BkRequest;
import com.digiwin.athena.knowledgegraph.po.ViewRequest;


/**
 * email服务
 * @javadoc
 */
public interface IEmailService extends DWService {

    /**
     * 根据邮箱码获取email
     * @param emailCode 邮箱码
     * @param locale 多语言
     * @return
     * @throws DWException
     */
    Object getEmail(String emailCode,String locale) throws DWException;

    /**
     * 获取邮箱视图
     * @param request
     * @return
     * @throws DWException
     */
  //  @DWRequestMapping(path = "/view/emails", method = {DWRequestMethod.POST})
    Object postEmails(ViewRequest request) throws DWException;

    /**
     * 更新邮箱
     * @param request
     * @return
     * @throws DWException
     */
  //  @DWRequestMapping(path = "/view/emailUpdate", method = {DWRequestMethod.POST})
    Object postEmailUpdate(EmailView request) throws DWException;


}
