package com.digiwin.athena.knowledgegraph.service;

/**
 * IM消息服务
 * @javadoc
 */
public interface IIMService {

    /**
     * 调用aim续约接口
     * @param tenantId
     * @param appCode
     * @throws Exception
     */
    void noticeAppRenew(String tenantId, String appCode) throws Exception;

    /**
     * 缓冲期发送IM消息
     * @param tenantId 租户id
     * @param appCode 应用code
     * @throws Exception
     */
    void noticeAppRestricted(String tenantId, String appCode) throws Exception;

    /**
     * 过期发送IM消息
     * @param tenantId 租户id
     * @param appCode 应用code
     * @throws Exception
     */
    void noticeAppExpired(String tenantId, String appCode) throws Exception;
}
