package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.knowledgegraph.po.BkRequest;
import com.digiwin.athena.knowledgegraph.po.SimpleRequest;

/**
 * 稳态产品服务
 * @javadoc
 */
public interface IProductService extends DWService {
    /**
     * 获取配置的稳态产品信息
     * @return
     * @throws DWException
     */
    Object getAllSteadyProduct() throws DWBusinessException;

    /**
     * 根据产品code获取配置的稳态产品信息
     * @param productCode 产品code
     * @return
     * @throws DWBusinessException
     */
    Object getSteadyProduct(String productCode) throws DWBusinessException;
}
