package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.knowledgegraph.service.model.ScheduleRuleConfigDTO;

/**
 * 排程配置服务
 * @javadoc
 */
public interface IScheduleRuleConfigService extends DWService {

    /**
     * 保存排程配置
     * @param config
     * @return
     * @throws Exception
     */
    Object put(ScheduleRuleConfigDTO config) throws Exception;

    /**
     * 根据规则id获取排程
     * @param ruleId 规则id
     * @param tenantId 租户id
     * @return
     * @throws Exception
     */
    Object get(String ruleId, String tenantId) throws Exception;

    /**
     * 根据租户id获取排程
     * @param tenantId 租户id
     * @param count 计数
     * @return
     * @throws Exception
     */
    Object getQuery(String tenantId, int count) throws Exception;

    /**
     * 根据id删除排程配置
     * @param configId 配置id
     * @return
     * @throws Exception
     */
    Object delete(String configId) throws Exception;

    /**
     * 启用排程配置
     * @param configId  配置id
     * @return
     * @throws Exception
     */
    Object putEnable(String configId) throws Exception;

    /**
     * 禁用排程配置
     * @param configId 配置id
     * @return
     * @throws Exception
     */
    Object putDisable(String configId) throws Exception;
}
