package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;

import java.util.Map;

/**
 * 排程服务
 * @javadoc
 */
public interface IScheduleRuleService extends DWService {

    /**
     * 根据条件获取排程
     * @param conditions 查询条件
     * @param count 计数
     * @param language 多语言
     * @return
     * @throws Exception
     */
    Object getQuery(Map<String, Object> conditions, int count, String language) throws Exception;

    /**
     * 根据多语言获取排程
     * @param language 语言
     * @return
     * @throws Exception
     */
    Object getList(String language) throws Exception;

    /**
     * 根据规则id获取排程
     * @param ruleId 规则id
     * @param tenantId 租户id
     * @param language 多语言
     * @return
     * @throws Exception
     */
    Object get(String ruleId, String tenantId, String language) throws Exception;
}
