package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.kg.report.hz.model.userScreen.UserScreenConfig;
import com.digiwin.athena.kg.report.hz.model.userScreen.UserScreenConfigDTO;

import java.util.List;

/**
 * 大屏服务 - 敏数
 * @javadoc
 */
public interface IScreenService extends DWService  {
    /**
     * 查询用户授权敏捷数据应用的鼎捷云授权
     * @param type 类型
     * @return
     * @throws DWBusinessException
     */
    List<String> getUserPermissionScreen(List<String> type) throws DWBusinessException;

    /**
     * 根据租户和应用查询大屏场景
     * @param appCodes 应用code列表
     * @return
     * @throws Exception
     */
    Object postQuerySceneByApp(List<String> appCodes) throws Exception;

    /**
     * 获取用户授权的大屏
     * @param userId 用户id
     * @param type 类型
     * @param appCodes 应用code
     * @return
     * @throws DWBusinessException
     */
    List<String> getUserPermissionScreen(String userId,List<String> type, List<String> appCodes) throws DWBusinessException;

    /**
     * 新增用户大屏
     * @param config
     * @return
     * @throws Exception
     */
    Object postAddUserScreen(UserScreenConfigDTO config) throws Exception;

    /**
     * 删除用户大屏
     * @param codes
     * @return
     * @throws Exception
     */
    Object postDeleteUserScreen(List<String> codes) throws Exception;

    /**
     * 查询大屏
     * @param code  大屏code
     * @return
     * @throws Exception
     */
    UserScreenConfig postQueryUserScreen(String code) throws Exception;

    /**
     * 查询大屏列表
     * @param code
     * @return
     * @throws Exception
     */
    Object postQueryUserScreenByCode(String code) throws Exception;
}
