package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.set.Sets;

import java.util.List;

/**
 * 时效控制套件服务
 * @title: ISetService
 * @description: ISetService
 * @author: linc
 * @date 2023/8/15 8:48
 * @version: 1.0
 * @javadoc
 */
public interface ISetService extends DWService {

    /**
     * 随心控，开发平台嗲你发布的时候，调用此方法
     * @param sets 开发平台推送过来的相关套件的json信息
     * @return
     * @throws DWBusinessException
     */
    Object postCompileAndSaveSets(List<Sets> sets) throws DWBusinessException;

    /**
     * 根据套件code和对应的版本删除相关随心控的套件信息
     * @param code 套件编码
     * @param version 版本号
     * @return
     * @throws DWBusinessException
     */
    Object postDeleteSets(String code, String version) throws DWBusinessException;
}
