package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.athena.knowledgegraph.domain.mechanism.MechanismFormula;
import com.digiwin.athena.knowledgegraph.domain.mechanism.TenantSettings;

/**
 * 租户级配置服务
 * @javadoc
 */
public interface ITenantSettingsService extends DWService {


    /**
     * 通过租户id获取如期进货率阀值以及待启动任务等信息
     * @param tenantId 租户id
     * @param taskId 任务id
     * @return
     */
    @AllowAnonymous
    Object postScheduleConstructionThreshold(String tenantId,String taskId);

    /**
     * 传入需要改变的指标值,创建新公式更新申请记录
     * @param tenantId 租户id
     * @param taskId 任务id
     * @param key 键值
     * @return
     */
    @AllowAnonymous
    Object postMechanismFormulaUpdate(String tenantId,String taskId,String key);


    /**
     * 通过id获取机制调整 新老公式
     * @param formulaId 公式id
     * @return
     */
    @AllowAnonymous
    Object getFormula(String formulaId);

    /**
     * 获取租户当前使用公式
     * @param tenantId 租户id
     * @param taskId 任务id
     * @return
     */
    @AllowAnonymous
    Object getCurrentFormula(String tenantId,String taskId);

    /**
     * 机制任务修改 同意/拒绝
     * 机制任务审核 通过/不通过
     * @param param 参数
     * @return
     */
    @AllowAnonymous
    Object postFormula(MechanismFormula param);


}
