package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.knowledgegraph.domain.targets.SystemIndicatorForestDto;
import com.digiwin.athena.knowledgegraph.domain.targets.TenantIndicatorForest;

/**
 * 租户级指标树服务
 * @javadoc
 */
public interface ITenantTargetService extends DWService {

    /**
     * 删除指标树
     */
    Object deleteIndicatorForest() throws DWBusinessException;

    /**
     * 获取指标树
     * @return
     * @throws DWBusinessException
     */
    Object getIndicatorForest() throws DWBusinessException;

    /**
     * 获取所有租户指标
     * @return
     * @throws DWBusinessException
     */
    @AllowAnonymous
    Object getIndicatorForests() throws DWBusinessException;

    /**
     * 保存租户级指标树
     *
     * @param tenantIndicatorForest 指标树信息
     * @return
     * @throws DWBusinessException
     */
    Object postIndicatorForest(TenantIndicatorForest tenantIndicatorForest) throws DWBusinessException;

}
