package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.knowledgegraph.constant.Constants;
import com.digiwin.athena.knowledgegraph.domain.TenantEntity;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.knowledgegraph.domain.qr.TaskAndActivity;
import com.digiwin.athena.repository.neo4j.TaskRepository;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.concurrent.TimeUnit;

import static com.digiwin.athena.knowledgegraph.constant.ComponentConstants.REDIS_KNOWLEDGE_GRAPH;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2022-01-18 14:19
 **/
@Service
public class KgInnerService {
    private Logger logger = LoggerFactory.getLogger(KgInnerService.class);

    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    MongoTemplate mongoTemplateSystem;

    @Autowired
    TaskRepository taskRepository;

    private static ThreadLocal<String> tenantVersionHolder = new ThreadLocal<>();

    public String currentTenantVersion(){
        String version = null;
        try {
            String tenantId = AthenaUtils.getTenantId();
            version = getTenantVersion(tenantId);
        }catch (Exception e){}
        if(null==version){
            version= Constants.tenantDefaultVersion;
        }
        return version;
    }

    /**
     * 根据租户id获取租户版本 获取顺序 内存 -> 缓存 -> neo4j的租户实体
     * @param tenantId 租户id
     * @return 租户版本
     */
    public String getTenantVersion(String tenantId) {
        boolean timedTask = false;
        String version = null;
        try {
            version = (String) DWServiceContext.getContext().getRequestHeader().get(tenantId + "tenantVersion");
        } catch (Exception e) {
            //todo 定时任务没有dwService  直接吃异常 保证能查到后续version
            timedTask = true;
            logger.info("getTenantVersion warn");
        }
        if (null!=version){
            return version;
        }
        String cacheKey =REDIS_KNOWLEDGE_GRAPH+":SYSTEM:"+tenantId+":tenantversion";
        logger.info("getTenantVersion:{}", tenantId);
        version = stringRedisTemplate.opsForValue().get(cacheKey);
        if(null!=version){
            DWServiceContext.getContext().getRequestHeader().put(tenantId + "tenantVersion",version);
            return version;
        }
        TenantEntity tenantEntity = mongoTemplateSystem.findOne(new Query(Criteria.where("tenantId").is(tenantId)), TenantEntity.class);
        if (null == tenantEntity || null==tenantEntity.getVersion()) {
            // 修复bug-137120 默认版本为2.0
            version = Constants.tenantDefaultVersion;
            logger.warn("P.KG.500.0006，message：{}", I18nUtils.getValue("knowledgegraph.tenantEmpty",tenantId));
        } else {
            version = tenantEntity.getVersion();
        }
        stringRedisTemplate.opsForValue().set(cacheKey,version,7200, TimeUnit.SECONDS);
        if (!timedTask) {
            DWServiceContext.getContext().getRequestHeader().put(tenantId + "tenantVersion",version);
        }
        return version;
    }


    public Activity activityBasic(String taskId,String activityCode) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = getTenantVersion(tenantId);
        TaskAndActivity tt = taskRepository.findTaskAndActivity(tenantId,taskId,activityCode, tenantVersion);
        if(null!=tt && null!= tt.getActivity()){
            Activity activity = tt.getActivity();
            Activity activityBetter = findBetterActivity(tenantId,activityCode,activity.getVersion());
            return activityBetter;
        }


        return null;
    }


    public Activity findBetterActivity(String tenantId,String activityCode, String activityVersion) throws DWBusinessException {
        Query query = Query.query(Criteria.where("code").is(activityCode).and("version").is(activityVersion));
        Query query2 = Query.query(Criteria.where("code").is(activityCode).and("version").is(activityVersion).and("tenantId").is(tenantId));
        Activity defaultActivity = mongoTemplateSystem.findOne(query, Activity.class,"activityConfigs");
        Activity tenantActivity = mongoTemplateUser.findOne(query2, Activity.class,"activityConfigs");
        if(null!=tenantActivity){
            AthenaUtils.mergeObject(tenantActivity,defaultActivity);
        }

        return defaultActivity;
    }

    public static void cleanThreads(){
        tenantVersionHolder.remove();
    }


}
