package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.domain.MechanismTenantVariable;
import com.digiwin.athena.knowledgegraph.domain.VariableDefinition;
import com.digiwin.athena.knowledgegraph.po.TbbGlobal;
import com.digiwin.athena.knowledgegraph.service.IDBPatchService;
import com.digiwin.athena.knowledgegraph.utils.JsonUtil;
import com.digiwin.athena.knowledgegraph.clients.TBBUtils;
import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author tang jie cheng
 * @date 2023-03-07 9:30
 */
@Lang
@Service
@Slf4j
public class DBPatchService implements IDBPatchService {
    @Autowired
    private TBBUtils tbbUtils;
    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplate;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;

    /**
     * 修订全局咨询mongodb相关数据    转换历史结构
     *
     * @param version version
     * @return 修订全局咨询mongodb相关数据    转换历史结构
     */
    @Override
    public Object getPatchGlobalMessage(String version) throws DWBusinessException {
        List<TbbGlobal> globalList = tbbUtils.getGlobal();
        HashMap<Object, Object> map = new HashMap<>();
        map.put("chooseList", new ArrayList<>());
        ArrayList<Map<String, Object>> dataList = new ArrayList<>();
        for (TbbGlobal tbbGlobal : globalList) {
            HashMap<String, Object> global = new HashMap<>();
            global.put("chartId", tbbGlobal.getChartId());
            global.put("linkageIds", tbbGlobal.getLinkageIds());
            global.put("sequence", 50);
            global.put("title", tbbGlobal.getTitle().get("zh_CN"));
            global.put("lang", ImmutableMap.of("title", tbbGlobal.getTitle()));
            global.put("language", ImmutableMap.of("title", tbbGlobal.getTitle()));
            global.put("appCode", tbbGlobal.getAppCode());
            dataList.add(global);
        }
        map.put("dataList", dataList);
        Query query = new Query();
        query.addCriteria(Criteria.where("code").is("globalMessagePageType").and("version").is(version));
        Update update = new Update();
        update.set("version", version);
        update.set("common", "common");
        update.set("code", "globalMessagePageType");
        update.set("defaultValue", map);
        mongoTemplateSystem.upsert(query, update, VariableDefinition.class);
        return "ok";
    }

    /**
     * 修订租户级原来的数据
     *
     * @return 修订租户级原来的数据
     * @throws Exception Exception
     */
    @Override
    public Object getPatchTenantGlobalMessage() throws Exception {
        //查询机制变量 globalMessagePageType 设置过值的租户
        Query query = new Query();
        query.addCriteria(Criteria.where("variableId").is("globalMessagePageType"));
        List<MechanismTenantVariable> mechanismVariable = this.mongoTemplate.find(query,
                MechanismTenantVariable.class, "mechanismVariable");
        if (mechanismVariable.isEmpty()) {
            return "no data";
        }
        log.info(mechanismVariable.toString());
        for (MechanismTenantVariable mv : mechanismVariable) {
            if (null == mv.getValue()) {
                continue;
            }
            String typeCode = String.valueOf(JsonUtil.getJsonValue(JsonUtil.toJsonString(mv.getValue()), "typeCode"));
            if (ObjectUtils.isEmpty(typeCode) || typeCode.equals("null")) {
                continue;
            }
            //先备份
            mongoTemplate.save(mv, "mechanismVariableBackUp");
            List<Object> valueList =
                    JsonUtil.toList(JsonUtil.getJsonValue(JsonUtil.toJsonString(mv.getValue()), "value").toString(),
                            Object.class);
            HashMap<String, Object> map = new HashMap<>();
            ArrayList<Object> list = new ArrayList<>();
            for (Object jsonValue : valueList) {
                Object show = JsonUtil.getJsonValue(JsonUtil.toJsonString(jsonValue), "show");
                Object isShow = JsonUtil.getJsonValue(JsonUtil.toJsonString(show), "value");
                if (!isShow.equals(true)) {
                    continue;
                }
                Object code = JsonUtil.getJsonValue(JsonUtil.toJsonString(show), "code");
                if (!code.equals(typeCode)) {
                    continue;
                }
                Object chartId = JsonUtil.getJsonValue(JsonUtil.toJsonString(jsonValue), "chartId");
                if (chartId.equals("604551b1-979f-4aa7-86c2-33b817787597")) {
                    list.add("e6232c3b-b792-4753-8abb-0af6b1096218");
                } else if (chartId.equals("c8e948d0-d22c-4aed-8dca-016ac671453c")) {
                    list.add("20ca62c8-6730-44f6-8a90-8b5234b3be44");
                } else {
                    list.add(chartId);
                }
            }
            map.put("chooseList", list);
            Query query1 = new Query();
            Criteria criteria =
                    Criteria.where("tenantId").is(mv.getTenantId()).and("variableId").is(mv.getVariableId());
            query1.addCriteria(criteria);
            Update update = new Update();
            update.set("value", map);
            mongoTemplate.upsert(query1, update, MechanismTenantVariable.class);
        }
        return "ok";
    }
}
