package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kg.report.hz.model.sence.ReportSceneDTO;
import com.digiwin.athena.knowledgegraph.dto.report.dataSubscription.*;
import com.digiwin.athena.knowledgegraph.service.IDataSubscriptionService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.utils.DataSubscriptionUtils;
import io.seata.common.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;

@Lang
@Service
@Slf4j
@MyExceptionHandler
public class DataSubscriptionService implements IDataSubscriptionService {
    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;

    @Autowired
    SceneService sceneService;

    @Autowired
    KgInnerService kgInnerService;

    @Autowired
    DataSubscriptionUtils dataSubscriptionUtils;

    private static final String SCHEDULE_URL = "/restful/standard/AgileDataEngine/schedule";

    @Value("${scdispatcherUrl}/restful/standard/AgileDataEngine/schedule")
    private String scdispatcherUrl;

    @Autowired
    private IamService iamService;


    // 数据订阅新增和修改
    @Override
    public Object postAddDataSubscriptionConfig(DataSubscriptionRule config) throws Exception {
        String tenantId = config.getTenantId();
        DataSubscriptionScheduleParam scheduleParam = config.getScheduleParam();
        if (scheduleParam == null) {
            return DataSubscriptionUtils.FAIL_MSG;
        }
        String question = scheduleParam.getQuestion();
        String userId = scheduleParam.getUserId();
        String sceneCode = scheduleParam.getSceneCode();
        List<String> metricIdList = CollectionUtils.isEmpty(scheduleParam.getMetricIdList())? new ArrayList<>() : scheduleParam.getMetricIdList();
        metricIdList.addAll(org.apache.commons.collections.CollectionUtils.isEmpty(scheduleParam.getDatasetIdList()) ? new ArrayList<>() : scheduleParam.getDatasetIdList());
        if (StringUtils.isBlank(question) || StringUtils.isBlank(userId)
                || (StringUtils.isBlank(sceneCode) && CollectionUtils.isEmpty(metricIdList))) {
            return DataSubscriptionUtils.FAIL_MSG;
        }

        String tenantVersion = kgInnerService.currentTenantVersion();
        ReportSceneDTO reportScene = sceneService.querySceneMaps(
                CollectionUtils.isEmpty(metricIdList) ?
                        Collections.singletonList(sceneCode) : metricIdList, tenantVersion);
        if (reportScene == null) {
            return DataSubscriptionUtils.FAIL_MSG;
        }
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        Object tenantName = profile.get("tenantName");
        if (Objects.isNull(tenantName)) {
            return DataSubscriptionUtils.FAIL_MSG;
        }

        HttpMethod method = HttpMethod.POST;
        String appCode = reportScene.getAppCode();
        config.setAppCode(appCode);
        config.setActionId(reportScene.getActionId());

        scheduleParam.setTenantId(tenantId);
        scheduleParam.setTenantName(tenantName.toString());

        // 当solutionStep为空时，从数据库中获取solutionStep填充
        if (ObjectUtils.isEmpty(scheduleParam.getSolutionStep()) && StringUtils.isNotBlank(config.getRuleId())) {
            Query query = Query.query(Criteria.where("ruleId").is(config.getRuleId()));
            DataSubscriptionRule dataSubscriptionRule = this.mongoTemplateUser.findOne(query, DataSubscriptionRule.class);
            if (!ObjectUtils.isEmpty(dataSubscriptionRule)
                    && !ObjectUtils.isEmpty(dataSubscriptionRule.getScheduleParam())) {
                scheduleParam.setSolutionStep(dataSubscriptionRule.getScheduleParam().getSolutionStep());
            }
        }

        String res = DataSubscriptionUtils.FAIL_MSG;
        if (StringUtils.isBlank(config.getRuleId())) {
            config.setRuleId("agileSubscribe_" + UUID.randomUUID().toString().replace("-", ""));

            DataSubscriptionConfig dataSubscriptionConfig = DataSubscriptionConfig.builder()
                    .tenantId(config.getTenantId())
                    .ruleList(Collections.singletonList(config)).build();

            res = dataSubscriptionUtils.postDataSubscription(dataSubscriptionConfig,SCHEDULE_URL,method);
        } else {
            method = HttpMethod.PUT;
            res = dataSubscriptionUtils.postDataSubscription(config,SCHEDULE_URL,method);
        }


        if (Objects.equals(DataSubscriptionUtils.FAIL_MSG,res)) {
            return DataSubscriptionUtils.FAIL_MSG;
        }

        // 先查询是否存在
//        List<DataSubscriptionRule> dataSubscriptionConfigList = this.postQueryDataSubscriptionConfig(tenantId ,userId,question,sceneCode);

        if (Objects.equals(HttpMethod.POST.toString(), method.toString())) {
            this.mongoTemplateUser.save(config);
        }else {
            // 有数据，则更新
            Query query = Query.query(Criteria.where("ruleId").is(config.getRuleId())
                    /*.and("appCode").is(appCode)
                    .and("scheduleParam.userId").is(userId)
                    .and("scheduleParam.question").is(question)*/);
            Update update = new Update();
            update.set("triggers", config.getTriggers());
            update.set("enableStatus",config.getEnableStatus());
            update.set("scheduleParam",config.getScheduleParam());
            this.mongoTemplateUser.updateMulti(query, update, DataSubscriptionRule.class);
        }
        return DataSubscriptionUtils.SUCCESS_MSG;
    }

    // 前端查询订阅
    @Override
    public List<DataSubscriptionRule> postQueryDataSubscriptionConfig(String tenantId, String userId, String question,String sceneCode) {
        /*Query query = Query.query(Criteria.where("tenantId").is(tenantId)
                .and("scheduleParam.userId").is(userId)
                .and("enableStatus").is("Y"));

        // 空的查用户全部，否则查单个问句
        if (StringUtils.isNotEmpty(question)) {
            query.addCriteria(Criteria.where("scheduleParam.question").is(question));
        }
        // 空的查用户全部，否则查单个场景问句
        if (StringUtils.isNotEmpty(sceneCode)) {
            query.addCriteria(Criteria.where("scheduleParam.sceneCode").is(sceneCode));
        }

        return this.mongoTemplateUser.find(query, DataSubscriptionRule.class);*/
        return this.postQueryDataSubscriptionConfig(tenantId,userId,question,sceneCode,Collections.emptyList());
    }

    @Override
    public List<DataSubscriptionRule> postQueryDataSubscriptionConfig(String tenantId, String userId, String question,String sceneCode,List<String> metricIdList) {
        Query query = Query.query(Criteria.where("tenantId").is(tenantId)
                .and("scheduleParam.userId").is(userId)
                .and("enableStatus").is("Y").orOperator(Criteria.where("scheduleParam.asaCode").is(null), Criteria.where("scheduleParam.asaCode").is("")));

        // 空的查用户全部，否则查单个问句
        if (StringUtils.isNotEmpty(question)) {
            query.addCriteria(Criteria.where("scheduleParam.question").is(question));
        }
        // 空的查用户全部，否则查单个场景问句
        if (StringUtils.isNotEmpty(sceneCode)) {
            query.addCriteria(Criteria.where("scheduleParam.sceneCode").is(sceneCode));
        }
        // 兼容指标订阅
        if (!CollectionUtils.isEmpty(metricIdList)) {
            query.addCriteria(Criteria.where("scheduleParam.metricIdList").all(metricIdList).size(metricIdList.size()));
        }

        return this.mongoTemplateUser.find(query, DataSubscriptionRule.class);
    }

    @Override
    public List<DataSubscriptionRule> postQueryDataSubscriptionConfig(String tenantId, String userId, String question,String sceneCode,List<String> metricIdList,String asaCode) {
        Query query = Query.query(Criteria.where("tenantId").is(tenantId)
                .and("scheduleParam.userId").is(userId)
                .and("enableStatus").is("Y").and("scheduleParam.asaCode").is(asaCode));

        // 空的查用户全部，否则查单个问句
        if (StringUtils.isNotEmpty(question)) {
            query.addCriteria(Criteria.where("scheduleParam.question").is(question));
        }
        // 空的查用户全部，否则查单个场景问句
        if (StringUtils.isNotEmpty(sceneCode)) {
            query.addCriteria(Criteria.where("scheduleParam.sceneCode").is(sceneCode));
        }
        // 兼容指标订阅
        if (!CollectionUtils.isEmpty(metricIdList)) {
            query.addCriteria(Criteria.where("scheduleParam.metricIdList").all(metricIdList).size(metricIdList.size()));
        }

        return this.mongoTemplateUser.find(query, DataSubscriptionRule.class);
    }

    @Override
    public List<DataSubscriptionRule> postQueryDataSubscriptionConfig(String tenantId, String userId, String question,String sceneCode,List<String> metricIdList,List<String> datasetIdList,String asaCode) {
        Query query = Query.query(Criteria.where("tenantId").is(tenantId)
                .and("scheduleParam.userId").is(userId)
                .and("enableStatus").is("Y").and("scheduleParam.asaCode").is(asaCode));

        // 空的查用户全部，否则查单个问句
        if (StringUtils.isNotEmpty(question)) {
            query.addCriteria(Criteria.where("scheduleParam.question").is(question));
        }
        // 空的查用户全部，否则查单个场景问句
        if (StringUtils.isNotEmpty(sceneCode)) {
            query.addCriteria(Criteria.where("scheduleParam.sceneCode").is(sceneCode));
        }
        // 兼容指标订阅
        if (!CollectionUtils.isEmpty(metricIdList)) {
            query.addCriteria(Criteria.where("scheduleParam.metricIdList").all(metricIdList).size(metricIdList.size()));
        }

        if (!CollectionUtils.isEmpty(datasetIdList)) {
            query.addCriteria(Criteria.where("scheduleParam.datasetIdList").all(datasetIdList).size(datasetIdList.size()));
        }

        return this.mongoTemplateUser.find(query, DataSubscriptionRule.class);
    }

    // 删除订阅
    @Override
    public Object postRemoveDataSubscriptionConfig(String tenantId,String userId,String sceneCode,String question) {
        /*List<DataSubscriptionRule> dataSubscriptionRules = this.postQueryDataSubscriptionConfig(tenantId, userId, question, sceneCode);
        if (!CollectionUtils.isEmpty(dataSubscriptionRules)) {
            List<String> distinctRuleIds = getRuleId(dataSubscriptionRules);
            DataSubscriptionConfigDTO dataSubscriptionConfig = DataSubscriptionConfigDTO.builder()
                    .tenantId(tenantId)
                    .ruleId(String.join(",", distinctRuleIds)).build();
            String res = dataSubscriptionUtils.postDataSubscription(dataSubscriptionConfig,SCHEDULE_URL,HttpMethod.DELETE);
            if (Objects.equals(DataSubscriptionUtils.SUCCESS_MSG,res)) {
                this.mongoTemplateUser.remove(Query.query(Criteria.where("ruleId").in(distinctRuleIds)), DataSubscriptionRule.class);
                return DataSubscriptionUtils.SUCCESS_MSG;
            }
        }
        return DataSubscriptionUtils.FAIL_MSG;*/
        return this.postRemoveDataSubscriptionConfig(tenantId,userId,sceneCode,Collections.emptyList(),question);
    }

    @Override
    public Object postRemoveDataSubscriptionConfig(String tenantId,String userId,String sceneCode,List<String> metricIdList,String question) {
        List<DataSubscriptionRule> dataSubscriptionRules = this.postQueryDataSubscriptionConfig(tenantId, userId, question, sceneCode,metricIdList);
        if (!CollectionUtils.isEmpty(dataSubscriptionRules)) {
            List<DataSubscriptionRule> unDeletableRules = dataSubscriptionRules.stream()
                    .filter(rule -> Objects.nonNull(rule.getScheduleParam()) && Objects.equals(Boolean.FALSE,rule.getScheduleParam().getUndeletable()))
                    .collect(Collectors.toList());
            List<String> distinctRuleIds = getRuleId(unDeletableRules);
            if (CollectionUtils.isEmpty(distinctRuleIds)) {
                return DataSubscriptionUtils.FAIL_MSG;
            }
            DataSubscriptionConfigDTO dataSubscriptionConfig = DataSubscriptionConfigDTO.builder()
                    .tenantId(tenantId)
                    .ruleId(String.join(",", distinctRuleIds)).build();
            String res = dataSubscriptionUtils.postDataSubscription(dataSubscriptionConfig,SCHEDULE_URL,HttpMethod.DELETE);
            if (Objects.equals(DataSubscriptionUtils.SUCCESS_MSG,res)) {
                this.mongoTemplateUser.remove(Query.query(Criteria.where("ruleId").in(distinctRuleIds)), DataSubscriptionRule.class);
                return DataSubscriptionUtils.SUCCESS_MSG;
            }
        }
        return DataSubscriptionUtils.FAIL_MSG;
    }

    @Override
    public Object postRemoveDataSubscriptionConfig(String tenantId,String userId,String sceneCode,List<String> metricIdList,String question,String asaCode) {
        List<DataSubscriptionRule> dataSubscriptionRules = this.postQueryDataSubscriptionConfig(tenantId, userId, question, sceneCode,metricIdList,asaCode);
        if (!CollectionUtils.isEmpty(dataSubscriptionRules)) {

            List<DataSubscriptionRule> unDeletableRules = dataSubscriptionRules.stream()
                    .filter(rule -> Objects.nonNull(rule.getScheduleParam()) && Objects.equals(Boolean.FALSE,rule.getScheduleParam().getUndeletable()))
                    .collect(Collectors.toList());
            List<String> distinctRuleIds = getRuleId(unDeletableRules);
            if (CollectionUtils.isEmpty(distinctRuleIds)) {
                return DataSubscriptionUtils.FAIL_MSG;
            }
            DataSubscriptionConfigDTO dataSubscriptionConfig = DataSubscriptionConfigDTO.builder()
                    .tenantId(tenantId)
                    .ruleId(String.join(",", distinctRuleIds)).build();
            String res = dataSubscriptionUtils.postDataSubscription(dataSubscriptionConfig,SCHEDULE_URL,HttpMethod.DELETE);
            if (Objects.equals(DataSubscriptionUtils.SUCCESS_MSG,res)) {
                this.mongoTemplateUser.remove(Query.query(Criteria.where("ruleId").in(distinctRuleIds)), DataSubscriptionRule.class);
                return DataSubscriptionUtils.SUCCESS_MSG;
            }
        }
        return DataSubscriptionUtils.FAIL_MSG;
    }

    @Override
    public Object postRemoveDataSubscriptionConfig(String tenantId,String userId,String sceneCode,List<String> metricIdList,List<String> datasetIdList,String question,String asaCode) {
        List<DataSubscriptionRule> dataSubscriptionRules = this.postQueryDataSubscriptionConfig(tenantId, userId, question, sceneCode,metricIdList,datasetIdList,asaCode);
        if (!CollectionUtils.isEmpty(dataSubscriptionRules)) {

            List<DataSubscriptionRule> unDeletableRules = dataSubscriptionRules.stream()
                    .filter(rule -> Objects.nonNull(rule.getScheduleParam()) && Objects.equals(Boolean.FALSE,rule.getScheduleParam().getUndeletable()))
                    .collect(Collectors.toList());
            List<String> distinctRuleIds = getRuleId(unDeletableRules);
            if (CollectionUtils.isEmpty(distinctRuleIds)) {
                return DataSubscriptionUtils.FAIL_MSG;
            }
            DataSubscriptionConfigDTO dataSubscriptionConfig = DataSubscriptionConfigDTO.builder()
                    .tenantId(tenantId)
                    .ruleId(String.join(",", distinctRuleIds)).build();
            String res = dataSubscriptionUtils.postDataSubscription(dataSubscriptionConfig,SCHEDULE_URL,HttpMethod.DELETE);
            if (Objects.equals(DataSubscriptionUtils.SUCCESS_MSG,res)) {
                this.mongoTemplateUser.remove(Query.query(Criteria.where("ruleId").in(distinctRuleIds)), DataSubscriptionRule.class);
                return DataSubscriptionUtils.SUCCESS_MSG;
            }
        }
        return DataSubscriptionUtils.FAIL_MSG;
    }

    @Override
    public Object postRemoveDataSubscriptionConfig(String tenantId,List<String> ruleIds) {
        if (CollectionUtils.isEmpty(ruleIds)) {
            return DataSubscriptionUtils.FAIL_MSG;
        }
        DataSubscriptionConfigDTO dataSubscriptionConfig = DataSubscriptionConfigDTO.builder()
                .tenantId(tenantId)
                .ruleId(String.join(",", ruleIds)).build();
        String res = dataSubscriptionUtils.postDataSubscription(dataSubscriptionConfig,SCHEDULE_URL,HttpMethod.DELETE);
        if (Objects.equals(DataSubscriptionUtils.SUCCESS_MSG,res)) {
            this.mongoTemplateUser.remove(Query.query(Criteria.where("ruleId").in(ruleIds)), DataSubscriptionRule.class);
            return DataSubscriptionUtils.SUCCESS_MSG;
        }
        return DataSubscriptionUtils.FAIL_MSG;
    }

    // 根据ruleId,查询详情
    @Override
    public Object getSingleDataSubscriptionConfig(String ruleId) throws Exception {
        Query query = Query.query(Criteria.where("ruleId").is(ruleId));
        return this.mongoTemplateUser.findOne(query, DataSubscriptionRule.class);
    }

    // 过期和续约的订阅查询
    public List<DataSubscriptionRule> postQueryExpireDataSubscriptionConfig(String tenantId, String userId, String question, String appCode) {
        Query query = new Query(Criteria.where("tenantId").is(tenantId));

        if (StringUtils.isNotEmpty(appCode)) {
            query.addCriteria(Criteria.where("appCode").is(appCode));
        }
        if (StringUtils.isNotEmpty(userId)) {
            query.addCriteria(Criteria.where("scheduleParam.userId").is(userId));
        }
        if (StringUtils.isNotEmpty(question)) {
            query.addCriteria(Criteria.where("scheduleParam.question").is(question));
        }

        return this.mongoTemplateUser.find(query, DataSubscriptionRule.class);
    }

    // 续约批量恢复订阅 应用续约批量更新状态
    public void postAppRenewDataSubscription(List<DataSubscriptionRule> config) {
        if (CollectionUtils.isEmpty(config)) {
            return;
        }

        List<String> distinctRuleIds = getRuleId(config);
        String res = dataSubscriptionUtils.postDataSubscription(config,SCHEDULE_URL,HttpMethod.POST);
        if (Objects.equals(DataSubscriptionUtils.SUCCESS_MSG,res)) {
            this.mongoTemplateUser.updateMulti(Query.query(Criteria.where("ruleId").in(distinctRuleIds)),
                    new Update().set("enableStatus", "Y"), DataSubscriptionRule.class);
        }
    }

    // 批量删除订阅 应用过期批量删除 ,type:update 软删除资料保留但是删除排程，type:delete 过了保留期删除
    public void postRemoveDataSubscription(List<DataSubscriptionRule> config,String type) {
        if (CollectionUtils.isEmpty(config)) {
            return;
        }

        List<String> distinctRuleIds = getRuleId(config);
        if (Objects.equals(type,"delete")) {
            this.mongoTemplateUser.remove( Query.query(Criteria.where("ruleId").in(distinctRuleIds)),
                    DataSubscriptionRule.class);
        } else {
            DataSubscriptionConfigDTO dataSubscriptionConfig = DataSubscriptionConfigDTO.builder()
                    .tenantId(config.get(0).getTenantId())
                    .ruleId(String.join(",", distinctRuleIds)).build();
            String res = dataSubscriptionUtils.postDataSubscription(dataSubscriptionConfig,SCHEDULE_URL,HttpMethod.DELETE);
            if (Objects.equals(DataSubscriptionUtils.SUCCESS_MSG,res)) {
                this.mongoTemplateUser.updateMulti(Query.query(Criteria.where("ruleId").in(distinctRuleIds)),
                        new Update().set("enableStatus", "N"), DataSubscriptionRule.class);
            }
        }

    }

    // 获取订阅数据的ruleId，去重
    private List<String> getRuleId(List<DataSubscriptionRule> config) {
        return  config.stream()
                .map(DataSubscriptionRule::getRuleId)  // 提取ruleId
                .distinct()  // 去重
                .collect(Collectors.toList());  // 转为列表
    }

    @Override
    public Object postSegmentDataSubscription(List<String> ruleIds) {
        Query query = new Query();

        // 是否传ruleId,兼容同步失败的处理
        if (!CollectionUtils.isEmpty(ruleIds)) {
            query.addCriteria(Criteria.where("ruleId").in(ruleIds));
        }

        // 查询所有订阅配置
        List<DataSubscriptionRule> dataSubscriptionRules = this.mongoTemplateUser.find(query, DataSubscriptionRule.class);
        int count = 0;
        Map<String,Object> result = new HashMap<>();
        if (CollectionUtils.isEmpty(dataSubscriptionRules)) {
            result.put("count",count);
            return result;
        }
        List<String> subscriptionConfigDTOList = new ArrayList<>();
        count = dataSubscriptionRules.size();

        for (DataSubscriptionRule config : dataSubscriptionRules) {
            Boolean handleResult = handleDataSubscription(config);
            if (!handleResult) { // 处理失败，记录ruleId
                subscriptionConfigDTOList.add(config.getRuleId());
            }
        }

        result.put("count",count);
        result.put("errorRuleIds",subscriptionConfigDTOList);
        return result;
    }

    private Boolean handleDataSubscription(DataSubscriptionRule config) {
        Map<String, Object> profile = new HashMap<>();
        profile.put("tenantId", config.getTenantId());
        DWServiceContext.getContext().setProfile(profile);
        DataSubscriptionConfigDTO delDataSubscriptionConfig = DataSubscriptionConfigDTO.builder()
                .tenantId(config.getTenantId())
                .ruleId(config.getRuleId()).build();
        String delResult = dataSubscriptionUtils.postDataSubscription(delDataSubscriptionConfig,scdispatcherUrl,HttpMethod.DELETE);

        if (Objects.equals(DataSubscriptionUtils.FAIL_MSG,delResult)) {
            return false;
        }

        /*DataSubscriptionConfig addDataSubscriptionConfig = DataSubscriptionConfig.builder()
                .tenantId(config.getTenantId())
                .ruleList(Collections.singletonList(config)).build();*/

        String addResult = dataSubscriptionUtils.postDataSubscription(config,SCHEDULE_URL,HttpMethod.PUT);
        return Objects.equals(DataSubscriptionUtils.SUCCESS_MSG,addResult);
    }



    public Object postUpdateSubscriptionByConfig(QuerySubscriptionDTO config) {
        if (StringUtils.isEmpty(config.getRuleId()) || ObjectUtils.isEmpty(config.getSolutionStep())) {
            return DataSubscriptionUtils.SUCCESS_MSG;
        }
        Query query = Query.query(Criteria.where("ruleId").is(config.getRuleId()));

        DataSubscriptionRule dataSubscriptionRule = this.mongoTemplateUser.findOne(query, DataSubscriptionRule.class);
        if (Objects.isNull(dataSubscriptionRule)) {
            return DataSubscriptionUtils.SUCCESS_MSG;
        }
        dataSubscriptionRule.getScheduleParam().setSolutionStep(config.getSolutionStep());

        String res = dataSubscriptionUtils.postDataSubscription(config, SCHEDULE_URL, HttpMethod.PUT);
        /*if (Objects.equals(DataSubscriptionUtils.FAIL_MSG,res)) {
            return DataSubscriptionUtils.FAIL_MSG;
        }*/

        Update update = new Update();
        update.set("scheduleParam",dataSubscriptionRule.getScheduleParam());
        this.mongoTemplateUser.updateMulti(query, update, DataSubscriptionRule.class);
        return DataSubscriptionUtils.SUCCESS_MSG;
    }
}
