package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.athena.domain.component.bo.ComponentBO;
import com.digiwin.athena.domain.component.bo.TenantAppComponentListBO;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.component.dao.TenantAppComponentListDAO;
import com.digiwin.athena.knowledgegraph.service.IHelpService;
import com.digiwin.athena.kg.authority.ActionVO;
import com.digiwin.athena.kg.authority.AuthorityConfigVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-05-07 19:32
 **/
@Lang
@Service
public class HelpService implements IHelpService {

    @Autowired
    private TenantAppComponentListDAO tenantAppComponentListDAO;

    private static final List<String> MODULES_ID = Arrays.asList("basicDataEntry","report","startProject");

    @Override
    public Object echo(Object data) throws Exception {
        return data;
    }

    @Override
    public Object tenantBasicDataByAppCodeAndId(AuthorityConfigVO config) throws Exception {
        List<ActionVO> newActions = new ArrayList<>();
        List<ActionVO> actions = config.getActions();
        Map<String, Object> filterDataMap = new HashMap<>();

        // 查询租户的组件数据
        TenantAppComponentListBO tenantAppComponentListBo = tenantAppComponentListDAO
                .findTenantAppComponentList(config.getAppId(), config.getTenantId());

        // 获取租户组件的code集合
        List<String> componentCodeList = tenantAppComponentListBo == null ?
                Collections.emptyList() :
                tenantAppComponentListBo.getComponents()
                        .stream()
                        .map(ComponentBO::getCode)
                        .collect(Collectors.toList());

        // 筛选actions，回传需要被排除的行为
        if (!CollectionUtils.isEmpty(componentCodeList) && !CollectionUtils.isEmpty(actions)) {
            newActions = config.getActions()
                    .stream()
                    .filter(action -> !componentCodeList.contains(action.getId()) && MODULES_ID.contains(action.getModuleId()))
                    .collect(Collectors.toList());
        }

        filterDataMap.put("actions", newActions);
        filterDataMap.put("modules", Collections.emptyList());
        return filterDataMap;
    }
}
