package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.constant.Constants;
import com.digiwin.athena.knowledgegraph.domain.application.TenantApplication;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.kg.authority.AuthorizedUserResult;
import com.digiwin.athena.kg.authority.SimpleUser;
import com.digiwin.athena.kg.authority.app.AppDetailInfo;
import com.google.gson.internal.LinkedTreeMap;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

@Lang
@Service
@Slf4j
public class IamService {

    @Autowired
    @Qualifier("iamRestTemplate")
    RestTemplate restTemplate;

    @Value("${iamUrl}")
    private String iamUrl;
    @Value("${aimUrl}")
    private String aimUrl;

    @Value("${iamTestUrl}")
    private String iamTestUrl;

    @Value("${iamApToken}")
    private String iamApToken;

    @Value("${integrationPasswordHash}")
    private String integrationPasswordHash;

    @Value("${integrationInternalPasswordHash}")
    private String integrationInternalPasswordHash;

    private final String TENANT_APPLICATION = "/api/iam/v2/user/tenant/application";
    private final String SEND_MESSAGE = "/api/aim/v2/batch/user/message";
    private final String TENANT_ALL_APPLICATION = "/api/iam/v2/tenant/application";
    private final String LOGIN = "/api/iam/v2/identity/login/internal";
    private final String APP_INFO = "/api/iam/v2/app";
    private final String USER = "/api/iam/v2/user/simple";
    private final String POLICY_ACTION = "/api/iam/v2/policy/action";
    private final String USER_PERMISSION2 = "/api/iam/v2/permission/user";
    private final String USER_ROLE = "/api/iam/v2/user/role";
    private final String APP_ITEMS = "/api/iam/v2/app/action/ids";

    public String getAthenaLicenceKey(String tenantId) throws Exception{
        return this.getLicenceKey("Athena", tenantId);
    }

    public String getAthenaLicenceKey(){
        return this.getLicenceKey("Athena");
    }


    /**
     *
     * @return 0 个人， 1 企业， 2 个人开发商， 3 企业开发商
     * @throws Exception
     */
    public String getTenantType(String tenantId, Object loginResponse) throws Exception{
        JSONObject loginJsonObject = JSON.parseObject(JSON.toJSONString(loginResponse));
        String enterpriseTenantType = null;
        if(StringUtils.equals(tenantId, loginJsonObject.getString("tenantId"))){
            enterpriseTenantType = loginJsonObject.getString("enterpriseTenantType");
        }
        return enterpriseTenantType;
    }

    public String getTenantToken(String tenantId, Object loginResponse) throws Exception{
        JSONObject loginJsonObject = JSON.parseObject(JSON.toJSONString(loginResponse));
        String token = null;
        if(StringUtils.equals(tenantId, loginJsonObject.getString("tenantId"))){
            token = loginJsonObject.getString("token");
        }
        return token;
    }

    public String getTenantToken(String tenantId) throws Exception{
        Object login = login(tenantId);
        JSONObject loginJsonObject = JSON.parseObject(JSON.toJSONString(login));
        String token = null;
        if(StringUtils.equals(tenantId, loginJsonObject.getString("tenantId"))){
            token = loginJsonObject.getString("token");
        }
        return token;
    }

    private String getLicenceKey(String application, String tenantId) throws Exception{
        Object login = login(tenantId);
        JSONObject loginJsonObject = JSON.parseObject(JSON.toJSONString(login));
        String token = null;
        if(StringUtils.equals(tenantId, loginJsonObject.getString("tenantId"))){
            token = loginJsonObject.getString("token");
        }
        List<TenantApplication> tenantApplications = this.listApplications(token);
        Optional<TenantApplication> any = tenantApplications.stream().filter(e -> StringUtils.equals(e.getId(), application)).findAny();
        if(any.isPresent()){
            return any.get().getSecretKey();
        }
        log.info("getLicenceKey not found application:{} of tenantId:{}", application, tenantId);
        return null;
    }

    private String getLicenceKey(String application){
        List<TenantApplication> tenantApplications = this.listApplications();
        Optional<TenantApplication> any = tenantApplications.stream().filter(e -> StringUtils.equals(e.getId(), application)).findAny();
        if(any.isPresent()){
            return any.get().getSecretKey();
        }
        return null;
    }

    private List<TenantApplication> listApplications(){
//        AthenaUser user = AthenaUserLocal.getUser();
//        if(user == null || StringUtils.isEmpty(user.getToken())){
//            throw new ServiceException(-1, "缺少token");
//        }
        String token = DWServiceContext.getContext().getToken();
        return listApplications(token);
//        HttpHeaders headers = new HttpHeaders();
//        headers.add("digi-middleware-auth-user", token);
//        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
//        ResponseEntity<Object> resEntity = restTemplate.exchange(iamUrl + TENANT_APPLICATION, HttpMethod.GET, requestEntity, Object.class);
//        Object body = resEntity.getBody();
//        List<TenantApplication> tenantApplications = JSONObject.parseArray(JSON.toJSONString(body), TenantApplication.class);
//        return tenantApplications;
    }

    private List<TenantApplication> listApplications(String token){
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(iamUrl + TENANT_APPLICATION, HttpMethod.GET, requestEntity, Object.class);
        Object body = resEntity.getBody();
        List<TenantApplication> tenantApplications = JSONObject.parseArray(JSON.toJSONString(body), TenantApplication.class);
        return tenantApplications;
    }

    public Object login(String tenantId) throws Exception{
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");

        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("tenantId", tenantId);
        requestMap.put("userId", "integration");
        requestMap.put("passwordHash", integrationInternalPasswordHash);
        requestMap.put("identityType", "token");
        HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(iamUrl + LOGIN, HttpMethod.POST, requestEntity, Object.class);
        Object body = resEntity.getBody();
        return body;
    }

    //private String getSHA256(String str) throws Exception {
    //    String encodeStr = "";
    //
    //    try {
    //        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
    //        messageDigest.update(str.getBytes("UTF-8"));
    //        byte[] bytes = messageDigest.digest();
    //        messageDigest.update(bytes);
    //        encodeStr = Base64.encodeBase64String(messageDigest.digest());
    //        return encodeStr;
    //    } catch (Exception var4) {
    //        throw new DWBusinessException(var4.getMessage());
    //    }
    //}

    public AppDetailInfo appDetailInfo(String appCode, String token){
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.set("digi-middleware-auth-app", iamApToken);

        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("id", appCode);

        HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(iamUrl + APP_INFO, HttpMethod.POST, requestEntity, Object.class);
        Object body = resEntity.getBody();
        AppDetailInfo tenantApplications = JSONObject.parseObject(JSON.toJSONString(body), AppDetailInfo.class);
        return tenantApplications;
    }

    public List<SimpleUser> getUser(String token){
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.set("digi-middleware-auth-app", iamApToken);
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(iamUrl + USER, HttpMethod.GET, requestEntity, Object.class);
        Object body = resEntity.getBody();
        List<SimpleUser> simpleUsers = JSONObject.parseArray(JSON.toJSONString(body), SimpleUser.class);
        return simpleUsers;
    }

    public List<AuthorizedUserResult> getAuthorizedUser(String token, String appCode){
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.set("digi-middleware-auth-app", iamApToken);
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(iamUrl + "/api/iam/v2/query/" + appCode+ "/authorized/user", HttpMethod.POST, requestEntity, Object.class);
        Object body = resEntity.getBody();
        List<AuthorizedUserResult> authorizedUserResultList = JSONObject.parseArray(JSON.toJSONString(body), AuthorizedUserResult.class);
        return authorizedUserResultList;
    }

    public Object policyAction(String type, Long targetSid, Long sysSid, boolean effect, Long actionSid, String token){
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.set("digi-middleware-auth-app", iamApToken);

        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("type", type);
        requestMap.put("targetSid", targetSid);
        requestMap.put("sysSid", sysSid);
        requestMap.put("effect", effect);
        requestMap.put("actionSid", actionSid);

        HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(iamUrl + POLICY_ACTION, HttpMethod.POST, requestEntity, Object.class);
        Object body = resEntity.getBody();

        return body;
    }

    public Object getUserPermission(String appCode, String userId, String token){
        if(appCode == null || StringUtils.isEmpty(userId) || StringUtils.isEmpty(token)){
            throw new RuntimeException(I18nUtils.getValue("knowledgegraph.tokenOrUserMiss"));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", iamApToken);

        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("userId", userId);
        requestMap.put("sysId", appCode);

        HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(iamUrl + USER_PERMISSION2, HttpMethod.POST, requestEntity, Object.class);
        Object body = resEntity.getBody();
        return body;
    }

    public Object listAllTenantApplications(String token){
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", iamApToken);
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(iamUrl + TENANT_ALL_APPLICATION, HttpMethod.GET, requestEntity, Object.class);
        Object body = resEntity.getBody();
        return body;
    }


    public Object userRole(String userId, String token){
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", iamApToken);

        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("id", userId);

        HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(iamUrl + USER_ROLE, HttpMethod.POST, requestEntity, Object.class);
        Object body = resEntity.getBody();
        return body;
    }

    public List<String> appItems(List<String> appIds){
        String token = DWServiceContext.getContext().getToken();
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", iamApToken);

        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("appIds", appIds);

        HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);
        ResponseEntity<Map> resEntity = restTemplate.exchange(iamUrl + APP_ITEMS, HttpMethod.POST, requestEntity, Map.class);
        Map body = resEntity.getBody();
        log.info("appItems response:{}", body);

        return (List<String>)body.get("data");
    }


    public boolean isSuperAdmin(String userId, String token){
        log.info("isSuperAdmin userId:{}", userId);
        Object userRoleRes = this.userRole(userId, token);
        log.info("userRoleResult result:{}", userRoleRes);
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(userRoleRes));
        if(jsonObject != null){
            JSONArray roles = jsonObject.getJSONArray("roles");
            if(roles != null && roles.size() > 0){
                for(int i = 0; i<roles.size(); i++){
                    JSONObject rolesJSONObject = roles.getJSONObject(i);
                    String id = rolesJSONObject.getString("id");
                    if(StringUtils.equals(id, "superadmin")){
                        return true;
                    }
                }
            }
        }

        return false;
    }


    /**
     * 启动企业运营
     * http://172.16.2.141:22694/html/web/controller/share/share.html#62d4f7b46fd0c83dff9c823d
     *
     * @return
     */
    public Object startEnterpriseOperation(String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", iamApToken);
        Map<String, Object> requestMap = new HashMap<>();
        HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(iamUrl + "/api/app/initialize", HttpMethod.POST, requestEntity, Object.class);
        Object body = resEntity.getBody();
        log.info("startEnterpriseOperation response:{}", body);
        return body;
    }

    public String getIntegrationToken(String tenantId, String appToken) {

        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", appToken);
        headers.add("digi-middleware-auth-app", iamApToken);

        Map<String, String> requestBody = new HashMap<>();
        requestBody.put("tenantId", tenantId);
        requestBody.put("userId", "integration");
        requestBody.put("passwordHash", integrationInternalPasswordHash);
        requestBody.put("identityType", "token");
        String url = iamUrl + "/api/iam/v2/identity/login/internal";
        HttpEntity<Map> requestEntity = new HttpEntity<>(requestBody, headers);
        try {
            ResponseEntity<Object> resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, Object.class);
            JSONObject body = JSON.parseObject(JSON.toJSONString(resEntity.getBody()));
            return body.getString("token");
        } catch (Exception e) {
            log.info("getUserToken by integration have exception：{}", e.getMessage());
        }
        return null;
    }


    /**
     * 固定获取test区的继集成账号token
     * @param tenantId  租户id
     * @return
     */
    public String getTestIntegrationToken(String tenantId) {

        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-app", iamApToken);

        Map<String, String> requestBody = new HashMap<>();
        requestBody.put("tenantId", tenantId);
        requestBody.put("userId", "integration");
        requestBody.put("passwordHash", integrationInternalPasswordHash);
        requestBody.put("identityType", "token");
        String url = iamTestUrl + "/api/iam/v2/identity/login/internal";
        HttpEntity<Map> requestEntity = new HttpEntity<>(requestBody, headers);
        try {
            ResponseEntity<Object> resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, Object.class);
            JSONObject body = JSON.parseObject(JSON.toJSONString(resEntity.getBody()));
            return body.getString("token");
        } catch (Exception e) {
            log.info("getUserToken by integration have exception：{}", e.getMessage());
        }
        return null;
    }


    public void dispatcherMessage(String token, List<String> userIdList, String message, String tenantId) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", token);
        ArrayList<Object> list = new ArrayList<>();

        Map<String, Object> requestMap = new HashMap<>();
        LinkedTreeMap<Object, Object> messageMap = new LinkedTreeMap<>();
        messageMap.put("type", "activity");
        messageMap.put("category", "notice");
        messageMap.put("hasReadDetail", Boolean.FALSE);
        LinkedTreeMap<Object, Object> treeMap = new LinkedTreeMap<>();
        treeMap.put("msg", message);
        messageMap.put("content", treeMap);
        requestMap.put("message", messageMap);
        requestMap.put("tenantId", tenantId);
        requestMap.put("userIdList", userIdList);
        list.add(requestMap);
        HttpEntity<ArrayList<Object>> arrayListHttpEntity = new HttpEntity<>(list, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(
            aimUrl + SEND_MESSAGE,
            HttpMethod.POST, arrayListHttpEntity, Object.class);
        Object body = resEntity.getBody();
        log.info("dispatcherMessage response:{}", body);

    }

    public Map<String,Object> batchQueryUserAppPermission(List<String> appCodes,String userId) throws DWBusinessException {
        DWServiceContext context = DWServiceContext.getContext();
        String token = AthenaUtils.getHeaderToken();
        Map<String,Object> result = new ConcurrentHashMap<>(appCodes.size());
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        CompletableFuture
            .allOf(
                appCodes.stream().map(code ->
                    CompletableFuture.runAsync(() -> {
                        DWServiceContext.setContext(context);
                        try {
                            RequestContextHolder.setRequestAttributes(requestAttributes);
                            Object o = this.getUserPermission(code, userId, token);;
                            if (!ObjectUtils.isEmpty(o)) {
                                result.put(code,o);
                            }
                        } catch (Exception e) {
                            log.error("getUserPermission error:", e);
                        }
                    }, Constants.APP_EXECUTE_POOL))
            .toArray(CompletableFuture[]::new))
        .join();

        return result;
    }

    // 通过iam获取租户名称
    public String getTenantName(String tenantId) throws Exception{
        Object login = login(tenantId);
        JSONObject loginJsonObject = JSON.parseObject(JSON.toJSONString(login));
        String tenantName = null;
        if(StringUtils.equals(tenantId, loginJsonObject.getString("tenantId"))){
            tenantName = loginJsonObject.getString("tenantName");
        }
        return tenantName;
    }
}
