package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.component.bo.ComponentBO;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.knowledgegraph.clients.ESPUtils;
import com.digiwin.athena.knowledgegraph.component.ComponentApplyContext;
import com.digiwin.athena.knowledgegraph.component.ComponentManager;
import com.digiwin.athena.knowledgegraph.constant.Constants;
import com.digiwin.athena.knowledgegraph.dao.ActivityDAO;
import com.digiwin.athena.knowledgegraph.domain.ComponentStructuredList;
import com.digiwin.athena.knowledgegraph.domain.VariableDefinition;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.domain.definition.FieldDescription;
import com.digiwin.athena.knowledgegraph.domain.mechanism.Mechanism;
import com.digiwin.athena.knowledgegraph.domain.mechanism.Principle;
import com.digiwin.athena.knowledgegraph.domain.mechanism.PrincipleDetail;
import com.digiwin.athena.knowledgegraph.domain.valueobject.ActivityDataEntryVO;
import com.digiwin.athena.knowledgegraph.enums.MechanismParameterTypeEnum;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.filter.LoginInfo;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismBuilderService;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.knowledgegraph.po.MechanismFunction;
import com.digiwin.athena.knowledgegraph.po.MechanismReq;
import com.digiwin.athena.knowledgegraph.po.MechanismUserDesignerInfo;
import com.digiwin.athena.knowledgegraph.po.PhPMechanismApiCommonConfig;
import com.digiwin.athena.repository.neo4j.Activity2Repository;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleConfigService;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IMechanismDesignService;
import com.digiwin.athena.knowledgegraph.service.IMechanismService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.service.inner.KgHelpService;
import com.digiwin.athena.knowledgegraph.service.model.MonitorRuleConfigDTO;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.ResultBean;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.JsonUtil;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import com.digiwin.athena.domain.MechanismApplyRecord;
import com.digiwin.athena.mechanism.bo.DriveAbilityBo;
import com.digiwin.athena.knowledgegraph.vo.mechanism.MechanismApiInfoReqVO;
import com.digiwin.athena.mechanism.bo.MechanismApiInfoBO;
import com.digiwin.athena.mechanism.bo.MechanismLogic;
import com.digiwin.athena.mechanism.pre.MechanismCapacity;
import com.digiwin.athena.mechanism.pre.MechanismMsgTemplate;
import com.digiwin.athena.mechanism.pre.MechanismPartDoc;
import com.digiwin.athena.mechanism.pre.MechanismTheory;
import com.digiwin.athena.mechanism.pre.parts.ActionWarnMessagePart;
import com.digiwin.athena.mechanism.vo.LinkInfo;
import com.digiwin.athena.mechanism.widgets.activity.IMActivityWidget;
import com.google.common.collect.ImmutableMap;
import com.mongodb.client.result.UpdateResult;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-03-08 14:48
 **/
@Lang
@Slf4j
@Service
public class MechanismDesignService implements IMechanismDesignService {

    public static final String FROM_USER = "user";
    public static final String UD_THEORY_PREFIX = "ud_p_";
    public static final String UD_THEORY_DETAIL_PREFIX = "ud_pd_";
    public static final String UD_CAPACITY_PREFIX = "ud_c_";
    public static final String SYSTEM = "SYSTEM";

    @Autowired
    private ActionService actionService;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;

    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;

    @Autowired
    DataMapService dataMapService;

    @Autowired
    KgHelpService kgHelpService;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    TenantService tenantService;

    @Autowired
    MechanismBuilderService mechanismBuilderService;

    @Autowired
    IMechanismService mechanismService;
    @Autowired
    ComponentManager componentManager;
    @Autowired
    TaskService taskService;

    @Autowired
    IMechanismService iMechanismService;

    @Autowired
    ESPUtils espUtils;

    @Autowired
    MonitorRuleConfigService monitorRuleConfigService;

    @Autowired
    Activity2Repository activityRepository;

    @Autowired
    DataPickService dataPickService;

    @Autowired
    private ActivityDAO activityDAO;

    @Override
    public Object postMechanismDetail(MechanismReq req) throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        Object object = mechanismService.postQueryMechanismByCode(req.getCode(), null);
        if (object == null) { //当找不到系统级的配置时，直接返回null
            return null;
        }
        Mechanism mechanism = (Mechanism) object;

        this.mergeMechanismDesignInfo(mechanism, Constants.MechanismDesignState.UNPUBLISHED);
        String tenantId = AthenaUtils.getTenantId();
        List<MechanismCapacity> mechanismCapacity = this.findMechanismCapacity(mechanism.getCode(), tenantId);
        List<MechanismCapacity> sysMechanismCapacity = this.findSysMechanismCapacity(mechanism.getCode(), tenantId,"SYSTEM");
        mechanismCapacity = mergeMechanismCapacityInfo(mechanismCapacity, sysMechanismCapacity);
        mechanism.setCapacities(mechanismCapacity);
        LanguageUtil.processLocaleLanguage(mechanism, AthenaUtils.getCurrentLocale());

        return mechanism;
    }

    /**
     * 查机制原理-某能力的机制参数  目前都是先手动创建能力 然后补关联关系 因为要求在操作能力的时候  就得有能力的机制可以选择  真是悖论
     * @param req
     * @return
     * @throws DWBusinessException
     */
    @Override
    public Object postMechanismVariableByPrinciple(MechanismReq req) throws Exception {
        ArrayList<String> keyList = new ArrayList<>();
        String tenantId = AthenaUtils.getTenantId();
        //  mechanismCapacity  一起查componentStructuredList
        Criteria criteria = Criteria.where("mechanismCode").is(req.getCode()).and("appCode").is(req.getAppCode());
        List<ComponentStructuredList> componentStructuredListBOS = dataPickService.find(criteria, ComponentStructuredList.class, "componentStructuredList");
        List<ComponentTypeEnum> mechanismArrayList = new ArrayList<>();
        mechanismArrayList.add(ComponentTypeEnum.MechanismVariable);
        mechanismArrayList.add(ComponentTypeEnum.MechanismParam);
        List<ComponentBO> componentBOS = componentManager.filterComponentByType(componentStructuredListBOS,
            mechanismArrayList,req.getTheoryCode());
        keyList.addAll(componentBOS.stream().map(ComponentBO::getCode).collect(Collectors.toList()));

        Query query1 = new Query();
        query1.addCriteria(Criteria.where("mechanismCode").is(req.getCode()).and("mechanismTheoryCode").is(req.getTheoryCode()));
        List<MechanismCapacity> mechanismCapacities = mongoTemplateUser.find(query1, MechanismCapacity.class);
        filterMechanismVariable(keyList, mechanismCapacities);

        Criteria variableCriteria = new Criteria();
        if (CollectionUtils.isNotEmpty(req.getFilterType())) {
            variableCriteria.and("code").in(keyList).and("dataType").in(req.getFilterType()).and(
                    "application").is(req.getAppCode());
        } else {
            variableCriteria.and("code").in(keyList).and("application").is(req.getAppCode());
        }
        // 增加控件类型过滤
        if (CollectionUtils.isNotEmpty(req.getDisplayType())) {
            variableCriteria.and("displayType").in(req.getDisplayType());
        }
        if (keyList.isEmpty()) {
            return null;
        }
        List<VariableDefinition> variableDefinitions = dataPickService.find(variableCriteria, VariableDefinition.class, "variableDefinition");
        for (VariableDefinition variableDefinition : variableDefinitions) {
            Map variable = (Map)mechanismService.getVariable(variableDefinition.getCode(), tenantId);
            variableDefinition.setValue(variable.get(variableDefinition.getCode()));
        }
        LanguageUtil.processLocaleLanguage(variableDefinitions, AthenaUtils.getCurrentLocale());
        return variableDefinitions;
    }

    private void filterMechanismVariable(ArrayList<String> keyList, List<MechanismCapacity> mechanismCapacities) {
        if (CollectionUtils.isNotEmpty(mechanismCapacities)) {
            for (MechanismCapacity mechanismCapacity : mechanismCapacities) {
                if (mechanismCapacity != null && CollectionUtils.isNotEmpty(mechanismCapacity.getMechanismLink())) {
                    for (LinkInfo linkInfo : mechanismCapacity.getMechanismLink()) {
                        if (ComponentTypeEnum.MechanismVariable.toString().equals(linkInfo.getType())) {
                            keyList.add(linkInfo.getCode());
                        }
                    }
                }
            }
        }
    }

    @Override
    public Object postMechanismCapacity(MechanismReq req) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query(Criteria.where("tenantId").is(tenantId).and("code").is(req.getCode()));
        MechanismCapacity one = this.mongoTemplateUser.findOne(query, MechanismCapacity.class);
        if (null == one) {
            String version = tenantService.getTenantVersion(tenantId);
            Query sysQuery = Query.query(Criteria.where("tenantId").is("SYSTEM").and("code").is(req.getCode()).and("version").is(version));
            one = mongoTemplateSystem.findOne(sysQuery, MechanismCapacity.class);
        }
        return one;
    }

    @Override
    public Object postSaveMechanismTheory(MechanismReq req) throws DWBusinessException {
        MechanismTheory theory = req.getTheory();
        if (theory == null) {
            throw new DWBusinessException("mechanism theory is null");
        }
        if (StringUtils.isEmpty(req.getCode()) && StringUtils.isEmpty(req.getTheory().getMechanismCode())) {
            throw new DWBusinessException("mechanism code is null");
        }
        String tenantId = AthenaUtils.getTenantId();

        theory.setTenantId(tenantId);
        if (theory.getStatus() == null) {
            theory.setStatus(Constants.MechanismDesignState.UNPUBLISHED); //未发布
        }

        if (StringUtils.isEmpty(theory.getMechanismCode())) {
            theory.setMechanismCode(req.getCode());
        }

        String code = theory.getCode();
        if (StringUtils.isEmpty(code)) {
            code = UD_THEORY_PREFIX + UUID.randomUUID().toString().replace("-", "");
            theory.setCode(code);
            theory.setFrom("user");
        }



        List<com.digiwin.athena.mechanism.pre.PrincipleDetail> details = theory.getDetails();
        if (CollectionUtils.isNotEmpty(details)) {
            //系统级的原理不能在机制设计时修改,所以第一个数据为原理的实际内容
           /* details.forEach(e -> {
                if (StringUtils.isNotEmpty(e.getCode())) {
                    e.setCode("ud_pd_" + UUID.randomUUID().toString().replace("-", ""));
                }
            });*/
            com.digiwin.athena.mechanism.pre.PrincipleDetail principleDetail = details.get(0);
            if(StringUtils.isEmpty(principleDetail.getCode())) {
                principleDetail.setCode(UD_THEORY_DETAIL_PREFIX + UUID.randomUUID().toString().replace("-", ""));
            }
            theory.setDetails(Arrays.asList(principleDetail));
        }


        Query query = Query.query(Criteria.where("tenantId").is(tenantId).and("code").is(code));
        this.mongoTemplateUser.remove(query, MechanismTheory.class);
        this.mongoTemplateUser.save(theory);

        return theory;
    }

    @Override
    public Object postSaveMechanismCapacity(MechanismReq req) throws DWBusinessException {
        MechanismCapacity capacity = kgHelpService.convert(req.getCapacity(),MechanismCapacity.class);
        if (capacity == null) {
            throw new DWBusinessException("mechanism capacity is null");
        }
        if (StringUtils.isEmpty(capacity.getMechanismTheoryCode())) {
            throw new DWBusinessException("mechanism theory code is null");
        }
        if (StringUtils.isEmpty(capacity.getMechanismCode()) && StringUtils.isEmpty(req.getCode())) {
            throw new DWBusinessException("mechanism code is null");
        }
        if (StringUtils.isEmpty(capacity.getMechanismCode())) {
            capacity.setMechanismCode(req.getCode());
        }
        String tenantId = AthenaUtils.getTenantId();
        String code = capacity.getCode();

        if (StringUtils.isEmpty(code)) {
            code = UD_CAPACITY_PREFIX + UUID.randomUUID().toString().replace("-", "");
            capacity.setCode(code);
        }
        capacity.setTenantId(tenantId);

        if (capacity.getStatus() == null) {
            capacity.setStatus(Constants.MechanismDesignState.UNPUBLISHED);
        }

        if(capacity.getCreateTime() == null){
            capacity.setCreateTime(new Date());
        }

        if(StringUtils.isEmpty(capacity.getFrom())){
            capacity.setFrom(FROM_USER);
        }

        // 设置IM模板消息的内容
        setActivityWidgetMessage(capacity);

        Query query = Query.query(Criteria.where("tenantId").is(tenantId).and("code").is(code));
        this.mongoTemplateUser.remove(query, MechanismCapacity.class);
        this.mongoTemplateUser.save(capacity);

        return capacity;
    }

    public void setActivityWidgetMessage(MechanismCapacity capacity) {
        if (null != capacity.getAction() && "im".equalsIgnoreCase(capacity.getAction().getType())) {
            ActionWarnMessagePart actionWarnMessagePart = (ActionWarnMessagePart) capacity.getAction();
            List<IMActivityWidget> imActivityWidgets = actionWarnMessagePart.getImWidget();
            String currentLocale = AthenaUtils.getCurrentLocale();
            for (IMActivityWidget imActivityWidget : imActivityWidgets) {
                if ("im".equalsIgnoreCase(imActivityWidget.getType()) && "template".equalsIgnoreCase(imActivityWidget.getMsgType())) {
                    Query query = new Query();
                    query.addCriteria(Criteria.where("code").is(imActivityWidget.getMsgCode()));
                    MechanismMsgTemplate template = mongoTemplateSystem.findOne(query, MechanismMsgTemplate.class);
                    String currentContent = template.getLang().get("content").get(currentLocale);
                    imActivityWidget.setMessage(StringUtils.isNotEmpty(currentContent) ? currentContent : template.getContent());
                }
            }
        }
    }

    @Override
    public Object postDeleteMechanismTheory(MechanismReq req) throws DWBusinessException {
        //逻辑删除，便于后续机制生效时处理
        String tenantId = AthenaUtils.getTenantId();

        Query query = Query.query(Criteria.where("tenantId").is(tenantId).and("code").is(req.getCode()));

        Update update = new Update();
        update.set("status", Constants.MechanismDesignState.DELETE);
        UpdateResult updateResult = this.mongoTemplateUser.updateFirst(query, update, MechanismTheory.class);
        return updateResult.getModifiedCount();
    }

    @Override
    public Object postDeleteMechanismCapacity(MechanismReq req) throws DWBusinessException {
        //逻辑删除，便于后续机制生效时处理
        String tenantId = AthenaUtils.getTenantId();

        Query query = Query.query(Criteria.where("tenantId").is(tenantId).and("code").is(req.getCode()));

        Update update = new Update();
        update.set("status", Constants.MechanismDesignState.DELETE);

        UpdateResult updateResult = this.mongoTemplateUser.updateFirst(query, update, MechanismCapacity.class);

        return updateResult.getModifiedCount();
    }

    @Override
    public Object postApplyMechanismCapacity(MechanismReq req) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String version = tenantService.getTenantVersion(tenantId);
        MechanismCapacity capacity = kgHelpService.convert(req.getCapacity(),MechanismCapacity.class);
        if (null == capacity) {
            return null;
        }

        // 设置IM模板消息的内容
        setActivityWidgetMessage(capacity);

        if (StringUtils.isEmpty(capacity.getCode())) {
            String code = UD_CAPACITY_PREFIX + UUID.randomUUID().toString().replace("-", "");
            capacity.setCode(code);
        }
        req.setCapacity(capacity);

        if(StringUtils.isNotEmpty(capacity.getType())){ //当能力只有名称和描述的时候，不需要进行build操作
            String pluginId = capacity.getCode()+"_"+tenantId;
            MechanismParseContext context = new MechanismParseContext();
            context.setTenantId(tenantId);
            context.setTenantVersion(version);
            context.setCapacity(capacity);
            context.setPluginId(pluginId);

            MechanismLogic logic = mechanismBuilderService.build(context);

            kgHelpService.executeCyhper("match(m:MechanismComponent{pluginId:'"+pluginId+"'}) detach delete m",new HashMap<>());
            String cyhper = context.getCypherSb().toString();
        //    System.out.println(cyhper);
            kgHelpService.executeCyhper(cyhper,new HashMap<>());

            Query query = Query.query(Criteria.where("tenantId").is(tenantId).and("code").is(capacity.getCode()));
            mongoTemplateUser.remove(query, MechanismLogic.class);
            mongoTemplateUser.save(logic);
        }

        //最后再保存，避免上述build失败后能力数据不对
        Object o = this.applyMechanismInfo(req);

        return o;
    }


    private Object applyMechanismInfo(MechanismReq req) throws DWBusinessException {
        MechanismCapacity capacity = kgHelpService.convert(req.getCapacity(),MechanismCapacity.class);
        capacity.setStatus(Constants.MechanismDesignState.PUBLISHED);
        req.setCapacity(capacity);
        Object savedCapacity = this.postSaveMechanismCapacity(req);

        //此时如果是在新增的原理下的能力，则MechanismTheory表中必定已经存在了，会先调用能力保存的接口
        String mechanismTheoryCode = capacity.getMechanismTheoryCode();
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query(Criteria.where("tenantId").is(tenantId).and("code").is(mechanismTheoryCode));
        Update update = new Update();
        update.set("status", Constants.MechanismDesignState.PUBLISHED);
        mongoTemplateUser.updateMulti(query, update, MechanismTheory.class);

        return savedCapacity;
    }

    @Override
    public Object postUnApplyMechanismCapacity(MechanismReq req) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        MechanismCapacity capacity = kgHelpService.convert(req.getCapacity(),MechanismCapacity.class);
        if (null == capacity) {
            return null;
        }
        Query query = Query.query(Criteria.where("tenantId").is(tenantId).and("code").is(capacity.getCode()));

        Update update = new Update();
        update.set("status", Constants.MechanismDesignState.UNPUBLISHED);
        UpdateResult updateResult1 = this.mongoTemplateUser.updateMulti(query, update, MechanismCapacity.class);

        Query query2 = Query.query(Criteria.where("tenantId").is(tenantId).and("mechanismTheoryCode").is(capacity.getMechanismTheoryCode())
                .and("status").is(Constants.MechanismDesignState.PUBLISHED));
        List<MechanismCapacity> publishedMechanismCapacities = this.mongoTemplateUser.find(query2, MechanismCapacity.class);


        if(CollectionUtils.isEmpty(publishedMechanismCapacities)
                || (publishedMechanismCapacities.size() == 1 && publishedMechanismCapacities.get(0).getCode().equals(capacity.getCode()))){
            //如果能力全部都取消发布了，则把对应原理状态改为未发布
            Query query3 = Query.query(Criteria.where("tenantId").is(tenantId).and("code").is(capacity.getMechanismTheoryCode()));
            Update update2 = new Update();
            update2.set("status", Constants.MechanismDesignState.UNPUBLISHED);
            UpdateResult updateResult = this.mongoTemplateUser.updateMulti(query3, update2, MechanismTheory.class);
            log.info("UnApplyMechanismTheory code:{}, count", capacity.getMechanismTheoryCode(), updateResult.getModifiedCount());
        }


        //取消发布的时候不删除用户级由能力生成的MechanismLogic
        //DeleteResult result = mongoTemplateUser.remove(query, MechanismLogic.class);
        return updateResult1.getModifiedCount();
    }

    @Override
    public Object postResetTenantMechanismCapacity(MechanismReq req) throws DWBusinessException {
        return null;
    }


    private boolean checkTheoryMatchStatus(List<MechanismCapacity> mechanismCapacityList, String theoryCode, Integer status){
        if(CollectionUtils.isEmpty(mechanismCapacityList)){
            //如果没有能力，如果status是未发版，则返回true，status是发版，则返回false
            return Constants.MechanismDesignState.UNPUBLISHED == status;
        }

        List<MechanismCapacity> collect = mechanismCapacityList.stream().filter(e -> StringUtils.equals(theoryCode, e.getMechanismTheoryCode())).collect(Collectors.toList());

        if(CollectionUtils.isEmpty(collect)){
            //如果没有原理对应的能力，如果status是未发版，则返回true，status是发版，则返回false
            return Constants.MechanismDesignState.UNPUBLISHED == status;
        }

        List<MechanismCapacity> publishedCapacity = collect.stream().filter(e -> Constants.MechanismDesignState.PUBLISHED == e.getStatus()).collect(Collectors.toList());

        if(Constants.MechanismDesignState.PUBLISHED == status){
            //如果要匹配的是发布的，则原理下已发版的能力不能为空
            return CollectionUtils.isNotEmpty(publishedCapacity);
        }else{
            //如果要匹配的是未发布的，则原理下已发版的能力必须全为空
            return CollectionUtils.isEmpty(publishedCapacity);
        }

    }

    public void mergeMechanismDesignInfo(Mechanism mechanism, Integer status) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        List<MechanismTheory> mechanismTheoryList = this.findMechanismTheory(mechanism.getCode(), tenantId);
        List<MechanismCapacity> mechanismCapacityList = this.findMechanismCapacity(mechanism.getCode(), tenantId);
        List<MechanismCapacity> sysMechanismCapacity = this.findSysMechanismCapacity(mechanism.getCode(),tenantId, "SYSTEM");
        List<MechanismCapacity> mergeMechanismCapacityList = mergeMechanismCapacityInfo(mechanismCapacityList, sysMechanismCapacity);
        Map<String, MechanismTheory> mechanismTheoryMap = mechanismTheoryList.stream().filter(e->Constants.MechanismDesignState.DELETE != e.getStatus())
                .filter(e -> this.checkTheoryMatchStatus(mergeMechanismCapacityList, e.getCode(), status))
                .collect(Collectors.toMap(MechanismTheory::getCode, Function.identity(), (key1, key2) -> key2));

        List<Principle> principles = mechanism.getPrinciples();
        for (Principle principle : principles) {
            //由于现在系统设置的原理再用户机制设计时不能修改，所以mechanismTheoryMap中的都是机制设计的原理
            MechanismTheory mechanismTheory = mechanismTheoryMap.remove(principle.getCode());

            List<MechanismCapacity> mechanismCapacities = filterMechanismCapacity(mergeMechanismCapacityList, principle.getCode(), status);
            List<PrincipleDetail> principleDetails = this.generatePrincipleDetail(mechanismCapacities);
            List<PrincipleDetail> details = principle.getDetails();
            if(CollectionUtils.isNotEmpty(details) && CollectionUtils.isNotEmpty(principleDetails)){
                details.addAll(principleDetails);
            }

            if(CollectionUtils.isEmpty(details)){
                principle.setDetails(principleDetails);
            }
        }

        List<Principle> userDesignPrinciples = new ArrayList<>();
        if (!mechanismTheoryMap.isEmpty()) {  //剩余的肯定是机制设计页面新增的原理
            mechanismTheoryMap.values().forEach(mechanismTheory -> {
                Principle principle = JSON.parseObject(JSON.toJSONString(mechanismTheory), Principle.class);
                principle.setFrom(FROM_USER);
                principle.setStatus(status);
                //找到当前原理下的对应状态的能力，构造principleDetail的对象
                List<MechanismCapacity> mechanismCapacities = filterMechanismCapacity(mergeMechanismCapacityList, principle.getCode(), status);
                List<PrincipleDetail> principleDetails = this.generatePrincipleDetail(mechanismCapacities);
                List<PrincipleDetail> details = principle.getDetails();
                if(CollectionUtils.isNotEmpty(details) && CollectionUtils.isNotEmpty(principleDetails)){
                    details.addAll(principleDetails);
                }

                if(CollectionUtils.isEmpty(details)){
                    principle.setDetails(principleDetails);
                }
                userDesignPrinciples.add(principle);
            });

        }

//        List<Principle> sortedUserDesignPrinciples = userDesignPrinciples.stream()
//                .sorted(Comparator.comparing(Principle::getSequence)).collect(Collectors.toList());
        principles.addAll(userDesignPrinciples);
        //按sequence排序，主要排序机制设计时的新增的原理，系统的可能没有显示指定sequence
        List<Principle> sortedPrinciples = principles.stream().sorted((Principle c1, Principle c2) -> {
            Integer sequence = c1.getSequence();
            Integer sequence2 = c2.getSequence();

            if(sequence == null){
                sequence = -1;
            }

            if(sequence2 == null){
                sequence2 = -1;
            }

            return sequence - sequence2;

        }).collect(Collectors.toList());

        mechanism.setPrinciples(sortedPrinciples);

        // 原来交付设计器能设计机制时，只有发布的参数才展示
        if(Constants.MechanismDesignState.PUBLISHED == status){
            List<MechanismCapacity> publishedCapacityList = mergeMechanismCapacityList.stream().filter(e -> status == e.getStatus()).collect(Collectors.toList());
            List<FieldDescription> fieldDescriptions = this.generateParamDescription(publishedCapacityList);
            List<FieldDescription> paramDescription = mechanism.getParamDescription();
            if(paramDescription == null){
                mechanism.setParamDescription(fieldDescriptions);
            }else{
                if(CollectionUtils.isNotEmpty(fieldDescriptions)){
                    paramDescription.addAll(fieldDescriptions);
                }
            }
        }

    }

    /**
     * 查询列表时如果租户机制能力已存在保留租户级，应用级过滤掉
     * @param mechanismCapacity 租户级机制能力
     * @param sysMechanismCapacity 系统级机制能力
     * @return
     */
    public List<MechanismCapacity> mergeMechanismCapacityInfo(List<MechanismCapacity> mechanismCapacity,List<MechanismCapacity> sysMechanismCapacity) {
        if (CollectionUtils.isEmpty(sysMechanismCapacity)) {
            return mechanismCapacity;
        }

        if (CollectionUtils.isEmpty(mechanismCapacity)) {
            return sysMechanismCapacity;
        }

        mechanismCapacity.addAll(sysMechanismCapacity);
        return mechanismCapacity.stream()
                .collect(Collectors.collectingAndThen(Collectors.toCollection(() ->
                        new TreeSet<>(Comparator.comparing(o ->
                                o.getCode() + ";" +o.getMechanismTheoryCode() + ";" + o.getMechanismCode()))), ArrayList::new));
    }


    private List<FieldDescription> generateParamDescription(List<MechanismCapacity> mechanismCapacities) throws DWBusinessException {
        if(CollectionUtils.isEmpty(mechanismCapacities)){
            return null;
        }
        List<FieldDescription> result = new ArrayList<>();
        for (MechanismCapacity capacity : mechanismCapacities) {
            List<LinkInfo> links = capacity.getLinks();
            if (CollectionUtils.isNotEmpty(links)) {
                for (LinkInfo each : links) {
                    generateFieldDescription(each).map(result::add);
                }
            }
        }

        return result;
    }

    private Optional<FieldDescription> generateFieldDescription(LinkInfo linkInfo) throws DWBusinessException {
        /**
         * 基础资料：BaseDataEntry
         * 报表： Report
         * 全局资讯：GlobalInformation
         * 全局看板呈现(交付设计器通用参数设置): CommonSet
         */
        if("BaseDataEntry".equals(linkInfo.getType())){
            FieldDescription fieldDescription = constractDefaultFieldDescription(linkInfo);
            String tenantId = AthenaUtils.getTenantId();
            String version = tenantService.getTenantVersion(tenantId);
            Activity activityNeo4j = dataPickService.chooseOneWithSameCode(activityDAO.getActivityByCodeAndVersion(linkInfo.getCode(), version, tenantId));
            fieldDescription.setKey(linkInfo.getCode());
            fieldDescription.setValue("&routerLink=/base-data-entry&code="+ linkInfo.getCode() +"&category=" + linkInfo.getCategory());
            fieldDescription.setFrom("athena");

            fieldDescription.setDescription("跳转到athena基础资料录入进行相关基础资料录入");
            fieldDescription.setName(activityNeo4j.getName());
            Map<String, Map<String, String>> lang = new HashMap<>();
            Map<String, String> nameLang = activityNeo4j.getLang() == null ? null : activityNeo4j.getLang().get("name");
            Map<String, String> descriptionLang = new HashMap<>();
            descriptionLang.put("zh_TW", "跳轉到athena基礎資料錄入進行相關基礎資料錄入");
            descriptionLang.put("zh_CN", "跳转到athena基础资料录入进行相关基础资料录入");
            lang.put("name", nameLang);
            lang.put("description", descriptionLang);
            fieldDescription.setLang(lang);
         //   fieldDescription.setLanguage(lang);
            return Optional.of(fieldDescription);
        }
        if("Report".equals(linkInfo.getType())){
            //routerLink=/report&code=inquiryVoucher&category=ABI-STATEMENT&appCode=PWD
            Activity activityConfig = this.dataPickService.findOneByCondition(Criteria.where("code").is(linkInfo.getCode()), Activity.class, "activityConfigs");
            FieldDescription fieldDescription = constractDefaultFieldDescription(linkInfo);
            fieldDescription.setKey(linkInfo.getCode());
            fieldDescription.setValue("&routerLink=/report&code="+ linkInfo.getCode() +"&category=" + linkInfo.getCategory() + "&appCode=" + linkInfo.getAppCode());
            fieldDescription.setFrom("athena");

            fieldDescription.setDescription("跳转到athena报表页面");
            fieldDescription.setName(activityConfig.getName());
            Map<String, Map<String, String>> lang = new HashMap<>();
            Map<String, String> nameLang = activityConfig.getLang() == null ? null : activityConfig.getLang().get("name");
            Map<String, String> descriptionLang = new HashMap<>();
            descriptionLang.put("zh_TW", "跳轉到athena報表頁面");
            descriptionLang.put("zh_CN", "跳转到athena报表页面");
            lang.put("name", nameLang);
            lang.put("description", descriptionLang);
            fieldDescription.setLang(lang);
         //   fieldDescription.setLanguage(lang);
            return Optional.of(fieldDescription);
        }
        if("GlobalInformation".equals(linkInfo.getType())){
            FieldDescription fieldDescription = constractDefaultFieldDescription(linkInfo);
            fieldDescription.setKey(linkInfo.getType()); //因为全局资讯和通用参数设置只有一个页面，所以key直接用type值
            fieldDescription.setValue("&routerLink=/global-information");
            fieldDescription.setFrom("athena");
            fieldDescription.setDescription("跳转到athena全局资讯页面");
            fieldDescription.setName("全局资讯");
            Map<String, Map<String, String>> lang = new HashMap<>();
            Map<String, String> nameLang = new HashMap<>();
            nameLang.put("zh_TW", "全局資訊");
            nameLang.put("zh_CN", "全局资讯");
            Map<String, String> descriptionLang = new HashMap<>();
            descriptionLang.put("zh_TW", "跳轉到athena全局資訊頁面");
            descriptionLang.put("zh_CN", "跳转到athena全局资讯页面");
            lang.put("name", nameLang);
            lang.put("description", descriptionLang);
            fieldDescription.setLang(lang);
         //   fieldDescription.setLanguage(lang);
            return Optional.of(fieldDescription);
        }
        if("CommonSet".equals(linkInfo.getType())){
            FieldDescription fieldDescription = constractDefaultFieldDescription(linkInfo);
            fieldDescription.setKey(linkInfo.getType());
            fieldDescription.setValue("&routerLink=com-set");
            fieldDescription.setFrom("tdd");
            fieldDescription.setDescription("跳转到全局资讯通用参数");
            fieldDescription.setName("全局看板呈现配置");
            Map<String, Map<String, String>> lang = new HashMap<>();
            Map<String, String> nameLang = new HashMap<>();
            nameLang.put("zh_TW", "全局看板呈現配置");
            nameLang.put("zh_CN", "全局看板呈现配置");
            Map<String, String> descriptionLang = new HashMap<>();
            descriptionLang.put("zh_TW", "跳轉到全局資訊通用參數");
            descriptionLang.put("zh_CN", "跳转到全局资讯通用参数");
            lang.put("name", nameLang);
            lang.put("description", descriptionLang);
            fieldDescription.setLang(lang);
         //   fieldDescription.setLanguage(lang);
            return Optional.of(fieldDescription);
        }
        if("Project".equals(linkInfo.getType())) {
            Map<String, String> nameLang = new HashMap<>();
            nameLang.put("zh_TW", "發起專案");
            nameLang.put("zh_CN", "发起项目");
            if (StringUtils.isNotEmpty(linkInfo.getCode())) {
                Object project = dataMapService.getProject(linkInfo.getCode());
                if (project != null) {
                    JSONObject projectObj = JSON.parseObject(JSON.toJSONString(project));
                    if (projectObj.containsKey("taskName")) {
                        JSONObject taskNameLang = projectObj.getJSONObject("taskName");
                        nameLang.put("zh_TW", "發起-" + taskNameLang.getString("zh_TW"));
                        nameLang.put("zh_CN", "发起-" + taskNameLang.getString("zh_CN"));
                    }
                }

            }
            FieldDescription fieldDescription = constractDefaultFieldDescription(linkInfo);
            fieldDescription.setKey(linkInfo.getCode());
            fieldDescription.setValue("&routerLink=/add-task&code=" + linkInfo.getCode());
            fieldDescription.setFrom("athena");
            fieldDescription.setDescription("跳转到athena发起项目");
            fieldDescription.setName(nameLang.get(AthenaUtils.getCurrentLocale()));
            Map<String, Map<String, String>> lang = new HashMap<>();
            Map<String, String> descriptionLang = new HashMap<>();
            descriptionLang.put("zh_TW", "跳轉到athena發起專案");
            descriptionLang.put("zh_CN", "跳转到athena发起项目");
            lang.put("name", nameLang);
            lang.put("description", descriptionLang);
            fieldDescription.setLang(lang);
         //   fieldDescription.setLanguage(lang);
            return Optional.of(fieldDescription);
        }
        return Optional.empty();
    }

    private static FieldDescription constractDefaultFieldDescription(LinkInfo linkInfo) {
        FieldDescription fieldDescription = new FieldDescription();
        fieldDescription.setIsExecute(true);
        fieldDescription.setDataType("object");
        fieldDescription.setReadOnly(false);
        fieldDescription.setVersion("1.0");
        fieldDescription.setRequired(true);
        fieldDescription.setDisplayType("LINK");
        fieldDescription.setCategory("link");
        fieldDescription.setIsSimulation(false);
        if(StringUtils.isNotEmpty(linkInfo.getTarget())){
            fieldDescription.setTarget(linkInfo.getTarget());
        }
        return fieldDescription;
    }


    private List<PrincipleDetail> generatePrincipleDetail(List<MechanismCapacity> mechanismCapacities){
        if(null == mechanismCapacities || mechanismCapacities.isEmpty()){
            return null;
        }
        List<PrincipleDetail> details = new ArrayList<>();
        List<MechanismCapacity> collect = mechanismCapacities.stream().sorted(this::sortCapacities).collect(Collectors.toList());
        collect.forEach(e->{
            PrincipleDetail principleDetail = new PrincipleDetail();
            principleDetail.setCode(e.getCode());
            principleDetail.setTitle(handleLanguage(e.getName(), e.getLang(), "name"));
            principleDetail.setDescription(handleLanguage(e.getDescription(), e.getLang(), "description"));
            if(CollectionUtils.isEmpty(e.getLinks())){
                principleDetail.setRelatedParamKeys(Arrays.asList(e.getCode()));
            }else{ //如果有关联链接，则把关联链接的code也放入对应的relatedParamKeys中
                List<String> collect1 = e.getLinks().stream().map(linkInfo->{
                    if("GlobalInformation".equals(linkInfo.getType()) || "CommonSet".equals(linkInfo.getType())){
                        return linkInfo.getType(); //当全局资讯或者通用设置的时候，code值是为空的，用type作为关联的key值
                    }else{
                        return linkInfo.getCode();
                    }
                }).distinct().collect(Collectors.toList());
                List<String> paramKeys = new ArrayList<>();
                paramKeys.add(e.getCode());
                paramKeys.addAll(collect1);
                principleDetail.setRelatedParamKeys(paramKeys);
            }
            principleDetail.setFrom(FROM_USER);
            details.add(principleDetail);
        });

        return details;
    }

    private String handleLanguage(String origin, Map<String, Map<String, String>> lang, String key) {
        if (null != lang && lang.containsKey(key)) {
            Map<String, String> map = lang.get(key);
            String locale = AthenaUtils.getCurrentLocale();
            if (map != null && map.containsKey(locale)) {
                return map.get(locale);
            }
        }
        return origin;
    }

    private int sortCapacities(MechanismCapacity c1, MechanismCapacity c2) {
        return Long.compare(getSortedTime(c1), getSortedTime(c2));
    }

    private long getSortedTime(MechanismCapacity capacity) {
        if (capacity.getCreateDate() != null) {
            return capacity.getCreateDate().getTime();
        } else {
            return capacity.getCreateTime() == null ? 0L : capacity.getCreateTime().getTime();
        }
    }

    public void mergeMechanismDesignInfoByStatus(Mechanism mechanism, Integer status) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();

        List<MechanismTheory> mechanismTheoryList = this.findMechanismTheory(mechanism.getCode(), tenantId);
        List<MechanismCapacity> mechanismCapacityList = this.findMechanismCapacity(mechanism.getCode(), tenantId);

        Map<String, MechanismTheory> mechanismTheoryMap = mechanismTheoryList.stream().filter(e -> status == e.getStatus())
                .collect(Collectors.toMap(MechanismTheory::getCode, Function.identity(), (key1, key2) -> key2));


        List<Principle> principles = mechanism.getPrinciples();
        for (Principle principle : principles) {
            MechanismTheory mechanismTheory = mechanismTheoryMap.remove(principle.getCode());
            if (mechanismTheory != null) {
//                principle.setTitle(mechanismTheory.getTitle());
                principle.setFrom(mechanismTheory.getFrom());
            }

            List<PrincipleDetail> details = principle.getDetails();
            if (CollectionUtils.isNotEmpty(details)) {
                for (int i = 0; i < details.size(); i++) {
                    PrincipleDetail principleDetail = details.get(i);

                    if (mechanismTheory != null) {
                        com.digiwin.athena.mechanism.pre.PrincipleDetail mechanismTheoryDetail = this.findMechanismTheoryDetail(mechanismTheory.getDetails(), principleDetail.getCode());
                        if (mechanismTheoryDetail != null) {
                            principleDetail.setContent(mechanismTheoryDetail.getContent());
                        }
                    }

                    if (i == details.size() - 1) {
                        List<String> relatedParamKeys = principleDetail.getRelatedParamKeys();

                        if (CollectionUtils.isEmpty(relatedParamKeys)) {
                            List<MechanismCapacity> mechanismCapacities = this.filterMechanismCapacity(mechanismCapacityList, principle.getCode(), status);
                            if (null == mechanismCapacities || mechanismCapacities.isEmpty()) {
                                continue;
                            }
                            List<String> mechanismCapacityCodeList = mechanismCapacities.stream().map(MechanismCapacity::getCode).collect(Collectors.toList());
                            principleDetail.setRelatedParamKeys(mechanismCapacityCodeList);
                            //把能力的name和description整合到principleDetail的description中
                            String str = this.mergeMechanismCapacityDescription(principleDetail.getDescription(), mechanismCapacities);
                            principleDetail.setDescription(str);

                        } else {
                            List<String> newRelatedParamKeyList = new ArrayList<>();
                            List<MechanismCapacity> matchedMechanismCapacityList = new ArrayList<>();

                            List<MechanismCapacity> mechanismCapacities = filterMechanismCapacity(mechanismCapacityList, principle.getCode());
                            Map<String, MechanismCapacity> collect = mechanismCapacities.stream()
                                    .collect(Collectors.toMap(MechanismCapacity::getCode, Function.identity(), (key1, key2) -> key2));

                            for (String relatedParamKey : relatedParamKeys) {
                                MechanismCapacity capacity = collect.remove(relatedParamKey);
                                if (capacity == null) { //不是设计的能力
                                    newRelatedParamKeyList.add(relatedParamKey);
                                } else {
                                    if (Constants.MechanismDesignState.PUBLISHED == status && Constants.MechanismDesignState.PUBLISHED == capacity.getStatus()) {
                                        newRelatedParamKeyList.add(relatedParamKey);
                                        matchedMechanismCapacityList.add(capacity);
                                    } else if (Constants.MechanismDesignState.UNPUBLISHED == status
                                            && (Constants.MechanismDesignState.PUBLISHED == capacity.getStatus() || Constants.MechanismDesignState.UNPUBLISHED == capacity.getStatus())) {
                                        newRelatedParamKeyList.add(relatedParamKey);
                                    }
                                }
                            }

                            if (!collect.isEmpty()) {
                                collect.values().forEach(capacity -> {
                                    if (Constants.MechanismDesignState.PUBLISHED == status && Constants.MechanismDesignState.PUBLISHED == capacity.getStatus()) {
                                        newRelatedParamKeyList.add(capacity.getCode());
                                        matchedMechanismCapacityList.add(capacity);
                                    } else if (Constants.MechanismDesignState.UNPUBLISHED == status
                                            && (Constants.MechanismDesignState.PUBLISHED == capacity.getStatus() || Constants.MechanismDesignState.UNPUBLISHED == capacity.getStatus())) {
                                        newRelatedParamKeyList.add(capacity.getCode());
                                    }
                                });
                            }
                            principleDetail.setRelatedParamKeys(newRelatedParamKeyList);

                            String str = this.mergeMechanismCapacityDescription(principleDetail.getDescription(), matchedMechanismCapacityList);
                            principleDetail.setDescription(str);
                        }
                    }

                }

            }


        }

        if (!mechanismTheoryMap.isEmpty()) {  //表示在机制设计页面新增过原理
            mechanismTheoryMap.values().forEach(e -> {
                Principle principle = JSON.parseObject(JSON.toJSONString(e), Principle.class);
                if (CollectionUtils.isNotEmpty(principle.getDetails())) {
                    PrincipleDetail principleDetail = principle.getDetails().get(0); //details中第一条的是机制设计原理内容
                    List<String> newRelatedParamKeyList = new ArrayList<>();
                    List<MechanismCapacity> matchedMechanismCapacityList = new ArrayList<>();

                    List<MechanismCapacity> mechanismCapacities = filterMechanismCapacity(mechanismCapacityList, principle.getCode());
                    if (CollectionUtils.isNotEmpty(mechanismCapacities)) {
                        mechanismCapacities.forEach(capacity -> {
                            if (Constants.MechanismDesignState.PUBLISHED == status && Constants.MechanismDesignState.PUBLISHED == capacity.getStatus()) {
                                newRelatedParamKeyList.add(capacity.getCode());
                                matchedMechanismCapacityList.add(capacity);
                            } else if (Constants.MechanismDesignState.UNPUBLISHED == status
                                    && (Constants.MechanismDesignState.PUBLISHED == capacity.getStatus() || Constants.MechanismDesignState.UNPUBLISHED == capacity.getStatus())) {
                                newRelatedParamKeyList.add(capacity.getCode());
                            }
                        });
                    }

                    principleDetail.setRelatedParamKeys(newRelatedParamKeyList);

                    String str = this.mergeMechanismCapacityDescription(principleDetail.getDescription(), matchedMechanismCapacityList);
                    principleDetail.setDescription(str);
                }

                principles.add(principle);
            });
        }
    }

    private String mergeMechanismCapacityDescription(String sourceDescription, List<MechanismCapacity> mechanismCapacities) {
        if (CollectionUtils.isEmpty(mechanismCapacities)) {
            return sourceDescription;
        }
        StringBuilder sb = new StringBuilder();
        //todo 排序
        mechanismCapacities.forEach(e -> {
            sb.append(e.getName() + ":" + e.getDescription() + "\r\n");
        });

        if (StringUtils.isEmpty(sourceDescription)) {
            return sb.toString();
        } else {
            if (sourceDescription.endsWith("\r\n")) {
                return sourceDescription + sb.toString();
            } else {
                return sourceDescription + "\r\n" + sb.toString();
            }
        }
    }

    private com.digiwin.athena.mechanism.pre.PrincipleDetail findMechanismTheoryDetail(List<com.digiwin.athena.mechanism.pre.PrincipleDetail> details1, String code) {
        if (CollectionUtils.isEmpty(details1)) {
            return null;
        }

        Optional<com.digiwin.athena.mechanism.pre.PrincipleDetail> any = details1.stream().filter(e -> StringUtils.equals(e.getCode(), code)).findAny();
        if (any.isPresent()) {
            return any.get();
        }
        return null;
    }

    private MechanismCapacity filterMechanismCapacity(List<MechanismCapacity> mechanismCapacityList, String theoryCode, String capacityCode) {
        if (CollectionUtils.isEmpty(mechanismCapacityList)) {
            return null;
        } //ud_p_bc7af5405adc4ea29f90119a9a161ac7  //ud_c_486c73fb8d8e43c3bf970c8cd89dbbaa
        Optional<MechanismCapacity> collect = mechanismCapacityList.stream().filter(e -> StringUtils.equals(theoryCode, e.getMechanismTheoryCode())
                && StringUtils.equals(capacityCode, e.getCode())).findAny();
        if (collect.isPresent()) {
            return collect.get();
        }
        return null;
    }

    private List<MechanismCapacity> filterMechanismCapacity(List<MechanismCapacity> mechanismCapacityList, String theoryCode) {
        if (CollectionUtils.isEmpty(mechanismCapacityList)) {
            return null;
        }
        List<MechanismCapacity> collect = mechanismCapacityList.stream().filter(e -> StringUtils.equals(theoryCode, e.getMechanismTheoryCode())).collect(Collectors.toList());

        return collect;
    }

    /**
     * 根据机制原理code和状态过滤机制能力
     * @param mechanismCapacityList 租户级机制能力
     * @param theoryCode 机制原理code
     * @param status 机制状态
     * @return
     */
    private List<MechanismCapacity> filterMechanismCapacity(List<MechanismCapacity> mechanismCapacityList, String theoryCode, Integer status) {
        if (CollectionUtils.isEmpty(mechanismCapacityList)) {
            return null;
        }
        List<MechanismCapacity> collect = mechanismCapacityList.stream().filter(e -> StringUtils.equals(theoryCode, e.getMechanismTheoryCode())
                && status == e.getStatus()).collect(Collectors.toList());

        return collect;
    }

    private MechanismTheory filterMechanismTheory(List<MechanismTheory> mechanismTheoryList, String theoryCode, Integer status) {
        if (CollectionUtils.isEmpty(mechanismTheoryList)) {
            return null;
        }
        Optional<MechanismTheory> any = mechanismTheoryList.stream().filter(e -> StringUtils.equals(theoryCode, e.getCode()) && status == e.getStatus()).findAny();
        if (any.isPresent()) {
            return any.get();
        }
        return null;
    }

    private List<MechanismTheory> findMechanismTheory(String mechanismCode, String tenantId) {
        Query query = new Query();
        query.addCriteria(Criteria.where("mechanismCode").is(mechanismCode).and("tenantId").is(tenantId));
        List<MechanismTheory> mechanismTheories = this.mongoTemplateUser.find(query, MechanismTheory.class);
        return mechanismTheories;
    }

    private List<MechanismCapacity> findMechanismCapacity(String mechanismCode, String tenantId) {
        Query query = new Query();
        query.addCriteria(Criteria.where("mechanismCode").is(mechanismCode).and("tenantId").is(tenantId));
        List<MechanismCapacity> mechanismCapacities = this.mongoTemplateUser.find(query, MechanismCapacity.class);
        return mechanismCapacities;
    }

    // 查询应用级别的机制能力数据
    private List<MechanismCapacity> findSysMechanismCapacity(String mechanismCode, String tenantId,String tenantSysId) {
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Query query = new Query();
        query.addCriteria(Criteria.where("mechanismCode").is(mechanismCode).and("tenantId").is(tenantSysId).and("version").is(tenantVersion));
        List<MechanismCapacity> mechanismCapacities = this.mongoTemplateSystem.find(query, MechanismCapacity.class);
        return mechanismCapacities;
    }


    @Override
    public Object postProject(MechanismReq req) throws DWBusinessException {
        return null;
    }

    @Override
    public Object postDataMeta(MechanismReq req) throws DWBusinessException {
        return null;
    }

    @Override
    public Object getBasicDataList(String pattern, String appCode) throws Exception {
        Object activitiesObject = taskService.getActivitiesByPattern(pattern);
        if(activitiesObject == null){
            return null;
        }
        List<ActivityDataEntryVO> activitiesByPattern =JSON.parseArray(JSON.toJSONString(activitiesObject), ActivityDataEntryVO.class);
        ArrayList<ActivityDataEntryVO> list = new ArrayList<>();
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        for (ActivityDataEntryVO vo : activitiesByPattern) {
            if (vo.getAppCode().equals(appCode)) {
                Activity betterActivity = kgInnerService.findBetterActivity(tenantId, vo.getCode(), tenantVersion);
                if (betterActivity == null || ObjectUtils.isEmpty(betterActivity.getDataSources())) {
                    log.warn("BasicData not search activityConfigs,code:{}", vo.getCode());
                    continue;
                }
                Map<String, Object> dataSources = betterActivity.getDataSources();
                Object actionId = JsonUtil.getJsonValue(JSON.toJSONString(dataSources), "actionId");
                vo.setActionId(actionId);
                vo.setDataSources(dataSources);
                list.add(vo);
            }
        }
        //操作类型  未来会从定义取 现在只能写死
        for (ActivityDataEntryVO vo : list) {
            List<Object> operations = new ArrayList<>();
            addOperations("打开时", "打開時", "open", operations);
            addOperations("修改时", "修改時", "update", operations);
            addOperations("新增时", "新增時", "add", operations);
            addOperations("删除时", "刪除時", "delete", operations);
            vo.setOperations(operations);
        }
        return list;
    }

    @Override
    public Object postPartInfo(MechanismReq req) throws DWBusinessException {

        Query query =new Query();
        if(null!=req.getAppCode()){
            Criteria criteria = new Criteria();
            criteria.orOperator(Criteria.where("applications").in(req.getAppCode()),Criteria.where("applications").is(null));
            query.addCriteria(criteria);
        }
        if(null!=req.getAbility()){
            query.addCriteria(Criteria.where("abilities").in(req.getAbility()));
        }
        if(null!=req.getFactor()){
            query.addCriteria(Criteria.where("factors").in(req.getFactor()));
        }

        List<MechanismPartDoc> docs = mongoTemplateSystem.find(query,MechanismPartDoc.class);

        return docs;
    }

    private void addOperations(String labelCN, String labelTW, String op, List<Object> operations) {
        HashMap<Object, Object> map1 = new HashMap<>();
        map1.put("value", op);
        map1.put("label", labelCN);
        map1.put("lang", ImmutableMap.of("label",ImmutableMap.of("zh_CN", labelCN, "zh_TW", labelTW)));
        operations.add(map1);
    }


    /**
     * 更新用户设计的机制能力
     * @param info
     * @throws DWBusinessException
     */
    public void updateUserDesignMechanismInfo(MechanismUserDesignerInfo info) throws DWBusinessException{
        //1.把在机制辅导时可能做的改动同步到机制用户设计的对象上
        List<MechanismTheory> theoryList = info.getTheory();
        if(!CollectionUtils.isEmpty(theoryList)){
            MechanismTheory mechanismTheory = theoryList.get(0);
            Query query = new Query();
            query.addCriteria(Criteria.where("tenantId").is(AthenaUtils.getTenantId()).and("code").is(mechanismTheory.getCode()));

            MechanismTheory one = this.mongoTemplateUser.findOne(query, MechanismTheory.class);
            if(one != null){
                one.setTitle(mechanismTheory.getTitle());
                one.setDetails(mechanismTheory.getDetails());
                this.mongoTemplateUser.save(one);
            }
        }


        Query query = new Query();
        query.addCriteria(Criteria.where("tenantId").is(AthenaUtils.getTenantId()).and("mechanismCode").is(info.getMechanismCode()));

        List<MechanismCapacity> mechanismCapacities = this.mongoTemplateUser.find(query, MechanismCapacity.class);
        //已经生效过的能力
        Map<String, MechanismCapacity> hasApply = mechanismCapacities.stream().filter(e -> BooleanUtils.isTrue(e.getHasApply()))
                .collect(Collectors.toMap(MechanismCapacity::getCode, Function.identity(), (a, b) -> a));

        Map<String, MechanismCapacity> published = mechanismCapacities.stream().filter(e -> Constants.MechanismDesignState.PUBLISHED == e.getStatus())
                .collect(Collectors.toMap(MechanismCapacity::getCode, Function.identity(), (a, b) -> a));
        // 从开发平台已经被删除掉的能力
        Map<String, MechanismCapacity> hasDeletedFromDevPlatform = mechanismCapacities.stream().filter(MechanismCapacity::isDeletedByDevPlatform)
                .collect(Collectors.toMap(MechanismCapacity::getCode, Function.identity(), (a, b) -> a));
        // 从想生效的能力中剔除掉已经被开发平台删除的能力
        info.getCapacity().removeIf(capacity -> hasDeletedFromDevPlatform.containsKey(capacity.getCode()));
        List<ComponentBO> applyComponentBOS = new ArrayList<>();
        List<ComponentBO> unApplyComponentBOS = new ArrayList<>();
        List<String> allRegisterParams = new ArrayList<>();
        if(!CollectionUtils.isEmpty(info.getCapacity())){
            info.getCapacity().forEach(e->{
                hasApply.remove(e.getCode());
                published.remove(e.getCode());

                MechanismCapacity capacity = this.filterMechanismCapacity(mechanismCapacities, e.getMechanismTheoryCode(), e.getCode());
                capacity.setName(e.getName());
                capacity.setDescription(e.getDescription());
                capacity.setLang(e.getLang());
                capacity.setHasApply(true);

                this.mongoTemplateUser.save(capacity);

                if(CollectionUtils.isNotEmpty(capacity.getRegisterParams())){
                    allRegisterParams.addAll(capacity.getRegisterParams());
                }
                applyComponentBOS.add(this.transToComponentBO(capacity));
            });

        }

        List<String> needToDeleteAfterUnapplyMechanismLogicCodes = new ArrayList<>();
        if(!hasApply.isEmpty()){
            hasApply.values().forEach(e->{
                published.remove(e.getCode());

                MechanismCapacity capacity = this.filterMechanismCapacity(mechanismCapacities, e.getMechanismTheoryCode(), e.getCode());
                capacity.setHasApply(false);
                if (capacity.isDeletedByDevPlatform()) {
                    capacity.setStatus(Constants.MechanismDesignState.DELETE);
                    mongoTemplateUser.remove(capacity);
                    needToDeleteAfterUnapplyMechanismLogicCodes.add(capacity.getCode());
                } else {
                    capacity.setStatus(Constants.MechanismDesignState.UNPUBLISHED);
                    this.mongoTemplateUser.save(capacity);
                }
                unApplyComponentBOS.add(this.transToComponentBO(capacity));
            });
        }

        if(!published.isEmpty()){  //此处主要是已经发布的能力，但能力还没生效，直接又在辅导页面删除了，这部分能力也要改为未发布
            published.values().forEach(e->{
                MechanismCapacity capacity = this.filterMechanismCapacity(mechanismCapacities, e.getMechanismTheoryCode(), e.getCode());
                if (capacity.isDeletedByDevPlatform()) {
                    capacity.setStatus(Constants.MechanismDesignState.DELETE);
                    mongoTemplateUser.remove(capacity);
                    needToDeleteAfterUnapplyMechanismLogicCodes.add(capacity.getCode());
                } else {
                    capacity.setStatus(Constants.MechanismDesignState.UNPUBLISHED);
                    this.mongoTemplateUser.save(capacity);
                }
            });
        }


        Map allMechaniseVariables = new HashMap();
        if(CollectionUtils.isNotEmpty(allRegisterParams)){
            allRegisterParams.forEach(key->{
                try {
                    Object variable = this.mechanismService.getVariable(key, AthenaUtils.getTenantId());
                    if(!ObjectUtils.isEmpty(variable)){
                        Map<String, Object> variableMap = (Map<String, Object>) variable;
                        allMechaniseVariables.putAll(variableMap);
                    }
                } catch (Exception e) {
                    log.error(e.getMessage(), e);
                }
            });
        }
        //进行能力组件的生效
        log.info("startApplyUDComponentBO:{}", JSON.toJSONString(applyComponentBOS));
        applyComponentBOS.forEach(componentBO->{
            ComponentApplyContext componentApplyContext = new ComponentApplyContext();
            componentApplyContext.setMechanismCode(info.getMechanismCode());
            componentApplyContext.setMechanismVariables(allMechaniseVariables);
            try {
                this.componentManager.applyComponent(componentBO, componentApplyContext);
            } catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        });
        //进行能力组件的失效
        log.info("startUnApplyUDComponentBO:{}", JSON.toJSONString(unApplyComponentBOS));
        unApplyComponentBOS.forEach(componentBO->{
            ComponentApplyContext componentApplyContext = new ComponentApplyContext();
            componentApplyContext.setMechanismCode(info.getMechanismCode());
            try {
                this.componentManager.unApplyComponent(componentBO, componentApplyContext);
            } catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        });
        if (!needToDeleteAfterUnapplyMechanismLogicCodes.isEmpty()) {
            mongoTemplateUser.remove(Query.query(Criteria.where("code").in(needToDeleteAfterUnapplyMechanismLogicCodes).and("tenantId").is(AthenaUtils.getTenantId())), MechanismLogic.class);
        }


    }

    private ComponentBO transToComponentBO(MechanismCapacity capacity){
        ComponentBO componentBO = new ComponentBO();
        componentBO.setCode(capacity.getCode());
        if(StringUtils.isNotEmpty(capacity.getType())) {
            componentBO.setType(ComponentTypeEnum.valueOf(capacity.getType()));
        }
        componentBO.setMechanismCapacity(capacity);
        return  componentBO;
    }

    /**
     　* @description: 获取消息模板
     　* @param
     　* @return
     　* @throws
     　* @author linc
     　* @date 2023/9/21 13:36
     */
    @Override
    public Object postTemplateDataList(String appCode) {
        String locale = "zh_CN";
        Query query = new Query();
        query.addCriteria(Criteria.where("appCode").is(appCode));

        List<MechanismMsgTemplate> templateDataList = mongoTemplateSystem.find(query,MechanismMsgTemplate.class);
        String currentLocale = AthenaUtils.getCurrentLocale();
        if (!locale.equalsIgnoreCase(currentLocale)) {
            for (MechanismMsgTemplate template : templateDataList) {
                String currentName = template.getLang().get("name").get(currentLocale);
                template.setName(StringUtils.isNotEmpty(currentName) ? currentName : template.getName());
                String currentContent = template.getLang().get("content").get(currentLocale);
                template.setContent(StringUtils.isNotEmpty(currentContent) ? currentContent : template.getContent());
            }
        }
        return templateDataList;
    }

    /**
     　* @description: 获取应用是否可以选择模板
     　* @param
     　* @return
     　* @throws
     　* @author linc
     　* @date 2023/9/21 13:36
     */
    @Override
    public Object postTemplateSelectResult(String appCode) {
        Query query = new Query();
        query.addCriteria(Criteria.where("appCode").is(appCode));

        boolean result = mongoTemplateSystem.exists(query, MechanismMsgTemplate.class);
        return result;
    }

    @Override
    public Object getMechanismCapacityAdaptation(String code, String metaFieldType) {
        Query query = new Query();
        query.addCriteria(Criteria.where("code").is(code));

        List<MechanismApiInfoBO> apiList = mongoTemplateUser.find(query, MechanismApiInfoBO.class);
        // 开窗类型过滤掉没有方案的数据
        if("openWindow".equals(metaFieldType)){
            return apiList.stream().filter(v -> v.getHasScheme()).collect(Collectors.toList());
        }
        return apiList;
    }

    @Override
    public Object postQueryApiInfo(MechanismApiInfoReqVO req) throws Exception {
        log.info("MechanismDesignService.postQueryApiInfo beginning...req={}", req);
        //外部第三方接口需要通过esp调用
         if (req.getIsNeedEsp() != null && req.getIsNeedEsp()) {
             // 把应用 code 放到上下文中，在调用 esp 的地方，透传过去
             setApplication(req);
             return espUtils.execute(AthenaUtils.getHeaderToken(), AthenaUtils.getTenantId(), req.getApi(), req.getRequestJson());
        }
        // 调用本地内部方法
        return dataMapService.postQueryApiResult(req.getApi(), JSON.parseObject(JSON.toJSONString(req)));
    }

    private void setApplication(MechanismApiInfoReqVO req) throws DWBusinessException {
        try {
            String mechanismCode = req.getMechanismCode();
            Object object = mechanismService.postQueryMechanismByCode(mechanismCode, null);
            // 把应用 code 放到上下文中，在调用 esp 的地方，透传过去
            LoginInfo loginInfo = KgFilter.getLoginInfo();
            if (Objects.nonNull(object) && Objects.nonNull(loginInfo)) {
                Mechanism mechanism = (Mechanism) object;
                if (StringUtils.isNotEmpty(mechanism.getApplication())) {
                    loginInfo.setApplication(mechanism.getApplication());
                }
            }
        } catch (DWBusinessException e) {
            log.error("setApplication,error:" + JSON.toJSONString(req), e);
        }
    }

    @Override
    public  List<GetActionLocaleResponseDTO> getControlAbilityOutcomesApi(String appCode) {
        List<GetActionLocaleResponseDTO> result=new ArrayList<>();
        Query query = Query.query(Criteria.where("code").is(appCode));
        PhPMechanismApiCommonConfig phPMechanismApiCommonConfig=mongoTemplateSystem.findOne(query,PhPMechanismApiCommonConfig.class);
         if(!Objects.isNull(phPMechanismApiCommonConfig)&& !org.springframework.util.
                 CollectionUtils.isEmpty(phPMechanismApiCommonConfig.getActionIds())){
             phPMechanismApiCommonConfig.getActionIds().forEach(res->{
                 GetActionLocaleResponseDTO getActionLocaleResponseDTO= null;
                 try {
                     String actionId=null;
                     if(phPMechanismApiCommonConfig.isEnablePrefix()){
                         actionId=phPMechanismApiCommonConfig.action_id_prefix+"."+res;
                     }else{
                         actionId=res;
                     }
                     getActionLocaleResponseDTO = (GetActionLocaleResponseDTO) actionService.getMetadata(actionId);
                     replaceActionNameByLocale(AthenaUtils.getCurrentLocale(), getActionLocaleResponseDTO);
                     result.add(getActionLocaleResponseDTO);
                 } catch (Exception e) {
                     log.error("获取action getMetadata error:"+res,e);
                 }
             });
         }
        return result;
    }

    private void replaceActionNameByLocale(String currentLocale, GetActionLocaleResponseDTO getActionLocaleResponseDTO) {
        if ("zh_TW".equals(currentLocale) && StringUtils.isNotEmpty(getActionLocaleResponseDTO.getActionName_tw())) {
            getActionLocaleResponseDTO.setActionName(getActionLocaleResponseDTO.getActionName_tw());
        }
    }

    @Override
    public Object postMechanismParameterDic(MechanismReq req) {
        List<Map> list = MechanismParameterTypeEnum.toList();
        try {
            //增加获取机制原理下的机制参数
            Object o = this.postMechanismVariableByPrinciple(req);
            List<Map> resulstList=list.stream().filter(res->res.get("value").equals(MechanismParameterTypeEnum.MECHANISM_PARAMETER.getValue())).collect(Collectors.toList());
            for (Map map : resulstList) {
                map.put("params",o);
            }
            LanguageUtil.processLocaleLanguage(list, AthenaUtils.getCurrentLocale());
        } catch (Exception e) {
            log.error("getMechanismParameterDic error", e);
        }
        return list;
    }

    @Override
    public Object postSetPhpApiCommonParam(PhPMechanismApiCommonConfig req) {
        Query query = Query.query(Criteria.where("code").is(req.getCode()));
        this.mongoTemplateSystem.remove(query, PhPMechanismApiCommonConfig.class);
        this.mongoTemplateSystem.save(req);
        return req;
    }

    @Override
    public void postApplyMechanisms(String application, List<String> mechanismCodes) throws Exception {
        postApplyMechanisms(application, "1.0", mechanismCodes);
    }

    @Override
    public void postApplyMechanisms(String application, String version, List<String> mechanismCodes) throws Exception {
        Query query = new Query();
        query.addCriteria(Criteria.where("mechanismCode").in(mechanismCodes).and("tenantId").is(SYSTEM).and("version").is(version).and("application").is(application));
        List<MechanismCapacity> sysMechanismCapacities = mongoTemplateSystem.find(query, MechanismCapacity.class);
        handleSysMechanism(application, version, sysMechanismCapacities);
        handleTenantMechanism(application, mechanismCodes);
    }

    @Override
    public void postApplyMechanisms(String application, String version, List<String> mechanismCodes, List<String> tenantIds) throws Exception {
        Query query = new Query();
        query.addCriteria(Criteria.where("mechanismCode").in(mechanismCodes).and("tenantId").in(tenantIds).and("sourceLevel").is(200).and("version").is(version).and("application").is(application));
        List<MechanismCapacity> sysMechanismCapacities = mongoTemplateSystem.find(query, MechanismCapacity.class);
        handleSysMechanismForIndividualCase(application, version, sysMechanismCapacities, tenantIds);
        handleTenantMechanism(application, mechanismCodes);
    }

    /**
     * 先删除应用相关的所有系统级一次编译成果，然后根据新的插入系统级一次编译成果
     * @param application 应用code
     * @param version 版本号
     * @param capacities 机制能力 - 根据机制code查询出来的能力
     * @throws DWBusinessException
     */
    private void handleSysMechanism(String application, String version, List<MechanismCapacity> capacities) throws DWBusinessException {
        List<MechanismLogic> logics = new ArrayList<>();
        for (MechanismCapacity capacity : capacities) {
            // TODO 暂时注释，需要考虑存储多种语系的模版，二次编译阶段再根据当前语系进行选择
//            setActivityWidgetMessage(capacity);
            // TODO 设置 from SYSTEM，来自 SYSTEM 的后续不需要生成 neo4j 语句。
            if(StringUtils.isNotEmpty(capacity.getType())){ //当能力只有名称和描述的时候，不需要进行build操作
                String pluginId = capacity.getCode() + "_" + SYSTEM;
                MechanismParseContext context = new MechanismParseContext();
                context.setTenantId(SYSTEM);
                context.setTenantVersion(version);
                context.setCapacity(capacity);
                context.setPluginId(pluginId);
                MechanismLogic logic = mechanismBuilderService.build(context);
                logics.add(logic);
            }
            capacity.setStatus(Constants.MechanismDesignState.PUBLISHED);
        }
        mongoTemplateSystem.remove(Query.query(Criteria.where("tenantId").is(SYSTEM).and("application").is(application).and("version").is(version)), MechanismLogic.class);
        mongoTemplateSystem.insertAll(logics);
        mongoTemplateSystem.remove(Query.query(Criteria.where("tenantId").is(SYSTEM).and("application").is(application).and("version").is(version)), MechanismCapacity.class);
        mongoTemplateSystem.insertAll(capacities);
    }

    /**
     * 先删除应用相关的所有系统级一次编译成果，然后根据新的插入系统级一次编译成果
     */
    private void handleSysMechanismForIndividualCase(String application, String version, List<MechanismCapacity> capacities, List<String> tenantIds) throws DWBusinessException {
        List<MechanismLogic> logics = new ArrayList<>();
        for (MechanismCapacity capacity : capacities) {
            if(StringUtils.isNotEmpty(capacity.getType())){ //当能力只有名称和描述的时候，不需要进行build操作
                String pluginId = capacity.getCode() + "_" + capacity.getTenantId();
                MechanismParseContext context = new MechanismParseContext();
                context.setTenantId(capacity.getTenantId());
                context.setTenantVersion(version);
                context.setCapacity(capacity);
                context.setPluginId(pluginId);
                MechanismLogic logic = mechanismBuilderService.build(context);
                logics.add(logic);
            }
            capacity.setStatus(Constants.MechanismDesignState.PUBLISHED);
        }
        mongoTemplateSystem.remove(Query.query(Criteria.where("tenantId").in(tenantIds).and("application").is(application).and("version").is(version)), MechanismLogic.class);
        mongoTemplateSystem.insertAll(logics);
        mongoTemplateSystem.remove(Query.query(Criteria.where("tenantId").in(tenantIds).and("application").is(application).and("version").is(version)), MechanismCapacity.class);
        mongoTemplateSystem.insertAll(capacities);
    }

    private void handleTenantMechanism(String application, List<String> mechanismCodes) throws Exception {
        handleWithoutMechanism(application, mechanismCodes);
    }

    private void handleWithoutMechanism(String application, List<String> mechanismCodes) throws Exception {
        // TODO ccx 确认是否存在系统机制不存在了，但是租户的机制还在，因此不需要取消的情况，从代码来看应该不存在，因为系统级机制不存在，就没发查看到租户级机制了。
        List<MechanismCapacity> mechanismCapacities = mongoTemplateUser.find(
                Query.query(Criteria.where("application").is(application).and("mechanismCode").nin(mechanismCodes)), MechanismCapacity.class);
        Collection<MechanismCapacity> needUnapplyCapacities = mechanismCapacities.stream().collect(Collectors.toMap(MechanismCapacity::getCode, Function.identity(), (a, b) -> a)).values();
        for (MechanismCapacity capacity : needUnapplyCapacities) {
            unapplyCapacity(capacity);
        }
        List<String> needRemoved = needUnapplyCapacities.stream().map(MechanismCapacity::getCode).collect(Collectors.toList());
        mongoTemplateUser.remove(Query.query(Criteria.where("application").is(application).and("code").in(needRemoved)), MechanismCapacity.class);
        mongoTemplateUser.remove(Query.query(Criteria.where("application").is(application).and("code").in(needRemoved)), MechanismLogic.class);
    }

    // TODO 考虑跟 AbilityComponentApplyService #unapply 合并
    private void unapplyCapacity(MechanismCapacity capacity) throws Exception {
        if (null == capacity.getHasApply() || !capacity.getHasApply()) {
            return;
        }
        MechanismLogic logic = mongoTemplateUser.findOne(Query.query(Criteria.where("code").is(capacity.getCode()).and("tenantId").is(capacity.getTenantId())), MechanismLogic.class);;
        if(null==logic || logic.getLogic()==null) {
            return;
        }
        Map<String,Object> param = new HashMap<>();
        param.put("type", logic.getType());
        param.put("pluginId", logic.getCode());
        param.put("mechanismCode", capacity.getMechanismCode());
        param.put("ability",logic.getLogic());
        dataMapService.unBindMechanismComponentWithTenantId(param, capacity.getTenantId());
        mongoTemplateUser.remove(Query.query(Criteria.where("tenantId").is(logic.getTenantId()).and("mechanismAbilityCode").is(logic.getCode())),MechanismApplyRecord.class);
        if(ComponentTypeEnum.MechanismDrive.name().equals(logic.getType())) {
            DriveAbilityBo bo = kgHelpService.convert(logic.getLogic(), DriveAbilityBo.class);
            String monitorRuleId = bo.getMonitorRuleId();
            String actionId = bo.getActionId();
            Map<String, Object> param2 = new HashMap<>();
            param2.put("tenantId",logic.getTenantId());
            param2.put("monitorRuleId",monitorRuleId);
            param2.put("actionId",actionId);
            String createMonitorRelation="match(t:TenantEntity{tenantId:$tenantId})-[r:USE]->(m:MonitorRule{code:$monitorRuleId}) delete r";
            String createActionRelation="match(t:TenantEntity{tenantId:$tenantId})-[r:ACTION]->(m:StartServiceComposerAction{actionId:$actionId}) delete r";
            kgHelpService.executeCyhper(createMonitorRelation,param2);
            kgHelpService.executeCyhper(createActionRelation,param2);
            String product = kgHelpService.getTenantProduct(monitorRuleId);
            MonitorRuleConfigDTO config = new MonitorRuleConfigDTO();
            config.setConfigId(logic.getCode());
            config.setTenantId(logic.getTenantId());
            config.setMonitorRuleId(monitorRuleId);
            config.setProductName(product);
            config.setStatus(0);
            monitorRuleConfigService.delete(logic.getTenantId(),monitorRuleId);
        }
    }

    public Object postMechanismFunction(MechanismFunction req) {
        try {
            // 手动保存为非预置
            req.setIsPreset(Boolean.FALSE);
            req.setCode(req.getTaskCode() + UUID.randomUUID().toString().replace("-", ""));

            this.mongoTemplateSystem.save(req);
        } catch (Exception e) {
            log.error("MechanismDesignService.postMechanismFunction失败，e={}", e);
            return ResultBean.fail(1, e.getMessage());
        }
        return req;
    }

    public Object getMechanismFunction(String projectCode, String taskCode, String fieldCode, String dataType) {
        Query queryPresetFun = Query.query(Criteria.
                where("isPreset").is(Boolean.TRUE)
                .orOperator(Criteria.where("inputType").is("all"), Criteria.where("inputType").is(dataType.toLowerCase()))
        );
        List<MechanismFunction> mechanismPresetFuns = this.mongoTemplateSystem.find(queryPresetFun, MechanismFunction.class);

        Query query = Query.query(Criteria.
                where("projectCode").is(projectCode)
                .and("taskCode").is(taskCode)
                .and("fieldCode").is(fieldCode)
                .and("isPreset").is(Boolean.FALSE)
        );
        List<MechanismFunction> mechanismFunctions = this.mongoTemplateSystem.find(query, MechanismFunction.class);
        if (!CollectionUtils.isEmpty(mechanismFunctions)) {
            mechanismPresetFuns.addAll(mechanismFunctions);
        }
        return mechanismPresetFuns;
    }
}
