package com.digiwin.athena.knowledgegraph.set.partParsers;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kg.monitorRule.StandardPollingRule;
import com.digiwin.athena.knowledgegraph.clients.CacService;
import com.digiwin.athena.knowledgegraph.domain.MonitorRule;
import com.digiwin.athena.knowledgegraph.domain.VariableDefinition;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kg.monitorRule.DynamicCondition;
import com.digiwin.athena.repository.neo4j.MonitorRuleRepository;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleConfigService;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.kg.monitorRule.MonitorRuleTenantConfig;
import com.digiwin.athena.knowledgegraph.rule.model.MonitorRuleCategoryEnum;
import com.digiwin.athena.kg.monitorRule.tenant.DynamicParamsDO;
import com.digiwin.athena.kg.monitorRule.tenant.RuleDO;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.ActionService;
import com.digiwin.athena.knowledgegraph.service.impl.KgProductService;
import com.digiwin.athena.knowledgegraph.service.inner.KgHelpService;
import com.digiwin.athena.knowledgegraph.service.model.MonitorRuleConfigDTO;
import com.digiwin.athena.knowledgegraph.set.*;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.TranslateUtils;
import com.digiwin.athena.kg.authority.AppPurchaseInfo;
import com.digiwin.athena.set.Acting;
import com.digiwin.athena.set.Sets;
import com.digiwin.athena.set.factor.Factor;
import com.digiwin.athena.set.part.*;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

@Service
@Slf4j
public class SystemPartParser implements IPartParser {

    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplate;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;

    @Autowired
    KgHelpService kgHelpService;

    @Autowired
    MonitorRuleRepository monitorRuleRepository;

    @Autowired
    KgInnerService kgInnerService;

    @Autowired
    CacService cacService;

    @Autowired
    TranslateUtils translateUtils;

    @Autowired
    MonitorRuleConfigService monitorRuleConfigService;

    @Autowired
    PartParserService partParserService;

    @Autowired
    ActionService actionService;

    @Autowired
    KgProductService productService;

    @Override
    public boolean accept(Part part) {
        return StringUtils.equalsIgnoreCase("System", part.getType());
    }

    @Override
    public void parse(SetParseContext context, Part part) throws DWBusinessException {
        buildSetsAndParts(context,part);
    }

    public Object buildSetsAndParts(SetParseContext context, Part part) throws DWBusinessException {
        Sets sets = context.getCurrentSet();
        if (null != sets) {
            String tenantId = AthenaUtils.getTenantId();
            // 版本号用开发平台传给我们的
//            String tenantVersion = kgInnerService.getTenantVersion(tenantId);
            String tenantVersion = sets.getVersion();
            SetsRelatedInfo setsRelatedInfo = new SetsRelatedInfo();
            // 套件code
            String setsCode = sets.getCode();
            // 应用code
            String appCode = sets.getAppCode();
            // 应用名称
            String appName = sets.getAppName();
            // 侦测id
            String ruleId = SetConstants.RULE_PREFIX + setsCode;
            // 侦测名称
            String ruleName = sets.getName() + "_侦测";
            // 更新  根据套件code查询是否存在，存在则删除后再插入数据
            deleteIfPresent(context, appCode,setsCode,ruleId,tenantVersion);
            //如果是删除操作，删除后则结束编译
            if (Objects.equals(sets.getOperate(),"delete")) {
                // 更新租户的侦测数据并且通知sd停用
                updateTenantMonitorRuleStatus(ruleId);
                return null;
            }
            // 新增侦测
            String detectType = sets.getS().getPart().getDetectType();
            String productName = StringUtils.isNotEmpty(sets.getS().getPart().getConnectionObject()) ? sets.getS().getPart().getConnectionObject() : getTenantProduct();
            if (StringUtil.isEmpty(detectType)) {
                saveMonitorRule(sets ,ruleId,ruleName,tenantVersion, productName);
            }else {
                MonitorRule monitorRule = new MonitorRule();
                monitorRule.setId(ruleId);
                monitorRule.setName(ruleName);
                monitorRule.setVersion(tenantVersion);
                // 侦测产品由前端传过来
                monitorRule.setProductName(productName);
                partParserService.parseMonitorRulePart(monitorRule,sets);
            }

            // 上下文返回U的returnFields
            List<ReturnField> returnFields = sets.getS().getPart().getReturnFields();
            if (!CollectionUtils.isEmpty(returnFields)) {
                context.setReturnFieldAll(returnFields);
            }

            // 构建应用参数
            buildVariableDefinition(setsRelatedInfo,sets,ruleId,ruleName,tenantVersion,productName);
            // 构建应用和参数的关系
            buildApplicationRelation(setsRelatedInfo,setsCode,appCode,appName,ruleId,ruleName,tenantVersion);
            //保存套件和零件
            buildSetsAndPart(setsRelatedInfo,sets);
            saveSetsRelatedInfo(setsRelatedInfo);

            // 保存租户数据并同步到SD
            // 查询租户创建侦测和租户的关系
            List<String> tenantIds = createMonitorRelation(appCode,ruleId) ;
            saveMonitorRuleByTeanant(tenantIds,ruleId,productName);

            // 设置原租户id
            Map<String, Object> profile = new HashMap<>();
            profile.put("tenantId", tenantId);
            DWServiceContext.getContext().setProfile(profile);
        }
        return "success";
    }

    private void saveSetsRelatedInfo(SetsRelatedInfo setsRelatedInfo) throws DWBusinessException {
        String setsRelatedInfoStr = translateUtils.translateContent(setsRelatedInfo);
        SetsRelatedInfo relatedInfo = JSON.parseObject(setsRelatedInfoStr, SetsRelatedInfo.class);
        mongoTemplateSystem.save(relatedInfo.getSets());
        mongoTemplateSystem.save(relatedInfo.getSPart(),"parts");
        mongoTemplateSystem.save(relatedInfo.getAPart(),"parts");
        mongoTemplateSystem.save(relatedInfo.getUPart(),"parts");
        mongoTemplateSystem.save(relatedInfo.getPPart(),"parts");
        mongoTemplateSystem.save(relatedInfo.getApplicationRelation());
        mongoTemplateSystem.save(relatedInfo.getVariableDefinition());
    }

    private void deleteIfPresent(SetParseContext context, String appCode, String setsCode, String ruleId, String tenantVersion) {
        if (StringUtils.isNotEmpty(setsCode)) {
            // 查询是否已存在套件
            Query query = Query.query(Criteria.where("code").is(setsCode).and("version").is(tenantVersion));
            Sets oldSets = mongoTemplateSystem.findOne(query,Sets.class);
            if (oldSets != null) {
                // 删除套件和零件
                deleteSetsAndPart(oldSets,query,tenantVersion);
                context.setExists(true);
            }
            // 删除侦测
            deleteMonitorRule(setsCode,tenantVersion);
            // 删除参数与应用关系
            deleteApplicationRelation(appCode,ruleId,tenantVersion);
            // 删除应用参数
            deleteVariableDefinition(ruleId,tenantVersion);
        }
    }

    private void buildSetsAndPart(SetsRelatedInfo setsRelatedInfo, Sets sets) throws DWBusinessException {
        // 生成partId
        String sPartId = "part_s_" + UUID.randomUUID().toString().replace("-", "");
        String aPartId = "part_a_" + UUID.randomUUID().toString().replace("-", "");

        String uPartId = "part_u_" + UUID.randomUUID().toString().replace("-", "");
        String pPartId = "part_p_" + UUID.randomUUID().toString().replace("-", "");
        String infoStr = translateUtils.translateContent(sets);
        sets = JSON.parseObject(infoStr, Sets.class);
        // 创建一个临时变量
        Sets tempSets = JSON.parseObject(JSON.toJSONString(sets), Sets.class);
        // 保存零件
        if (null != tempSets.getS() && null != tempSets.getS().getPart()) {
            SystemPart sPart = tempSets.getS().getPart();
            sPart.setPartId(sPartId);
            sPart.setVersion(sets.getVersion());
            sPart.setAthena_namespace(sets.getAppCode());
            sPart.setPluginId(sets.getCode());
            setsRelatedInfo.setSPart(sPart);
            SystemPart systemPart = new SystemPart();
            systemPart.setPartId(sPartId);
            tempSets.getS().setPart(systemPart);
        }

        if (null != tempSets.getA() && null != tempSets.getA().getPart()) {
            TaskCardPart aPart = tempSets.getA().getPart();
            aPart.setPartId(aPartId);
            aPart.setVersion(sets.getVersion());
            aPart.setAthena_namespace(sets.getAppCode());
            aPart.setPluginId(sets.getCode());
            setsRelatedInfo.setAPart(aPart);
            TaskCardPart taskCardPart = new TaskCardPart();
            taskCardPart.setPartId(aPartId);
            tempSets.getA().setPart(taskCardPart);
        }

        if (null != tempSets.getU() && null != tempSets.getU().getPart()) {
            DataUnderstandingPart uPart = tempSets.getU().getPart();
            uPart.setPartId(uPartId);
            uPart.setVersion(sets.getVersion());
            uPart.setAthena_namespace(sets.getAppCode());
            uPart.setPluginId(sets.getCode());
            setsRelatedInfo.setUPart(uPart);
            DataUnderstandingPart dataUnderstandingPart = new DataUnderstandingPart();
            dataUnderstandingPart.setPartId(uPartId);
            tempSets.getU().setPart(dataUnderstandingPart);
        }

        if (null != tempSets.getP() && null != tempSets.getP().getPart()) {
            ThresholdEvaluatePart pPart = tempSets.getP().getPart();
            pPart.setPartId(pPartId);
            pPart.setVersion(sets.getVersion());
            pPart.setAthena_namespace(sets.getAppCode());
            pPart.setPluginId(sets.getCode());
            setsRelatedInfo.setPPart(pPart);
            ThresholdEvaluatePart thresholdEvaluatePart = new ThresholdEvaluatePart();
            thresholdEvaluatePart.setPartId(pPartId);
            tempSets.getP().setPart(thresholdEvaluatePart);
        }

        // 设置part保存套件sets
        tempSets.setPluginId(sets.getCode());
        tempSets.setAthena_namespace(sets.getAppCode());
        setsRelatedInfo.setSets(tempSets);
    }

    private void deleteSetsAndPart(Sets oldSets,Query query,String tenantVersion) {
        // 删除套件
        mongoTemplateSystem.remove(query,Sets.class);
        // 删除零件
        if (oldSets.getS() != null && oldSets.getS().getPart() != null && StringUtils.isNotEmpty(oldSets.getS().getPart().getPartId())){
            Query query1 = Query.query(Criteria.where("partId").is(oldSets.getS().getPart().getPartId()).and("version").is(tenantVersion));
            mongoTemplateSystem.remove(query1,"parts");
        }
        if (oldSets.getA() != null && oldSets.getA().getPart() != null && StringUtils.isNotEmpty(oldSets.getA().getPart().getPartId())){
            Query query1 = Query.query(Criteria.where("partId").is(oldSets.getA().getPart().getPartId()).and("version").is(tenantVersion));
            mongoTemplateSystem.remove(query1,"parts");
        }
        if (oldSets.getU() != null && oldSets.getU().getPart() != null && StringUtils.isNotEmpty(oldSets.getU().getPart().getPartId())){
            Query query1 = Query.query(Criteria.where("partId").is(oldSets.getU().getPart().getPartId()).and("version").is(tenantVersion));
            mongoTemplateSystem.remove(query1,"parts");
        }
        if (oldSets.getP() != null && oldSets.getP().getPart() != null && StringUtils.isNotEmpty(oldSets.getP().getPart().getPartId())){
            Query query1 = Query.query(Criteria.where("partId").is(oldSets.getP().getPart().getPartId()).and("version").is(tenantVersion));
            mongoTemplateSystem.remove(query1,"parts");
        }
    }

    private void saveMonitorRule(Sets sets , String ruleId, String ruleName, String tenantVersion, String productName) {
        // 存neo4j
        if (sets.getS() == null || sets.getS().getPart() == null) {
            return ;
        }

        SystemPart sPart = sets.getS().getPart();

        String jsonString = "CREATE (m:MonitorRule{actionType:'task',code:$code,"
                + "autoRun:true,pluginId:$pluginId,"
                + "name:$name,"
                + "actionCommonId:$actionCommonId,"
                + "standardPollingRule:$standardPollingRule,"
                + "type:'SQL_SCRIPT',category:'SQL_SCRIPT',version:$version,athena_namespace:$athena_namespace})";

        Map<String, Object> props = new HashMap<>();
        props.put("code",ruleId);
        props.put("pluginId",sets.getCode());
        props.put("name",ruleName);
        props.put("actionCommonId",SetConstants.PROJECT_PREFIX + sets.getCode());
        props.put("standardPollingRule",JSON.toJSONString(sPart.getStandard_polling_rule()));
        props.put("version",tenantVersion);
        props.put("athena_namespace",sets.getAppCode());
        kgHelpService.executeCyhper(jsonString,props);

        // 侦测存储到mongo
        MonitorRuleProductConfig monitorRuleProductConfig = new MonitorRuleProductConfig();
        monitorRuleProductConfig.setMonitorRuleId(ruleId);
        monitorRuleProductConfig.setProductName(productName);
        monitorRuleProductConfig.setVersion(tenantVersion);
        monitorRuleProductConfig.setPluginId(sets.getCode());
        monitorRuleProductConfig.setIsPollingIds(Boolean.FALSE);
        monitorRuleProductConfig.setDbName(sPart.getTargetDataBase());
        monitorRuleProductConfig.setDynamicParams(getDynamicParams());
        String script = getScript(sets);
        monitorRuleProductConfig.setScript(script);
        monitorRuleProductConfig.setAthena_namespace(sets.getAppCode());
        mongoTemplateSystem.save(monitorRuleProductConfig);
    }

    private List<String> createMonitorRelation(String appCode,String ruleId) {
        List<String> tenantIds = new ArrayList<>();
        List<AppPurchaseInfo> tenantIdDatas = cacService.getAllEffectiveTenantAndAppInfo(appCode).getList();
        if (!CollectionUtils.isEmpty(tenantIdDatas)) {
            tenantIds = tenantIdDatas.stream().map(AppPurchaseInfo::getTenantId).collect(Collectors.toList());
//            String createMonitorRelation = "MATCH (t:TenantEntity) " +
//                    "WHERE t.tenantId IN $tenantIds " +
//                    "MATCH (m:MonitorRule {code: $monitorRuleId}) " +
//                    "MERGE (t)-[:USE]->(m)";
//            Map<String, Object> params = new HashMap<>();
//            params.put("tenantIds", tenantIds);
//            params.put("monitorRuleId", ruleId);
//            kgHelpService.executeCyhper(createMonitorRelation,params);
        }
        return tenantIds;
    }


    // 侦测保存后默认生效
    private void saveMonitorRuleByTeanant(List<String> tenantIds,String ruleId,String product) {
        if (CollectionUtils.isEmpty(tenantIds)) {
            return;
        }
        for (String id : tenantIds) {
            MonitorRuleConfigDTO config = new MonitorRuleConfigDTO();
            config.setMonitorRuleId(ruleId);
            config.setTenantId(id);
            config.setProductName(product);
            config.setStatus(1);
            try {
                monitorRuleConfigService.post(config);
            } catch (Exception e) {
                log.error("buildSetsAndParts call post method error : {}",e);
            }
        }
    }

    private List<DynamicParamsDO> getDynamicParams() {
        List<DynamicParamsDO> dynamicParams = new ArrayList<>();

        DynamicParamsDO sParam = new DynamicParamsDO();
        sParam.setParam_target("SQL_SCRIPT");
        sParam.setParam_name("startTime_s");
        sParam.setSource_name("last_monitor_time");
        sParam.setParam_type("DATE_TIME");
        RuleDO sRule = new RuleDO();
        sRule.setAdd_day("0");
        sRule.setPeriod("DAY");
        sRule.setTime_type("START");
        sRule.setRange("0");
        sRule.setDay("0");
        sParam.setRule(sRule);

        DynamicParamsDO eParam = new DynamicParamsDO();
        eParam.setParam_target("SQL_SCRIPT");
        eParam.setParam_name("startTime_e");
        eParam.setSource_name("monitor_time");
        eParam.setParam_type("DATE_TIME");
        RuleDO eRule = new RuleDO();
        eRule.setAdd_day("0");
        eRule.setPeriod("DAY");
        eRule.setTime_type("END");
        eRule.setRange("0");
        eRule.setDay("0");
        eParam.setRule(eRule);

        dynamicParams.add(sParam);
        dynamicParams.add(eParam);
        return dynamicParams;
    }

    private String getScript(Sets sets) {
        if (sets.getS() == null && sets.getS().getPart() == null) {
            return "";
        }
        SystemPart sPart = sets.getS().getPart();
        String targetColumn = "";
        String riskWarningDays = "0";
        String riskWarningDaysUnit = "DAY";
        String bufferDays = "0";
        String bufferDaysUnit = "DAY";
//        String timeType = getTimeType(sPart);
        // 提取 factors 数组中的数据
        List<Factor> factorList = sets.getFactors();
        for (Factor factor : factorList) {
            String code = factor.getCode();
            if ("preScheuleDate".equals(code)) {
                targetColumn = factor.getValue();
            } else if ("riskWarningPart".equals(code)) {
                riskWarningDays = factor.getValue();
                riskWarningDaysUnit = factor.getUnit();
            } else if ("bufferPart".equals(code)) {
                bufferDays = factor.getValue();
                bufferDaysUnit = factor.getUnit();
            }
        }

        // 取pageViewDESC栏位,组成字符串
        String columnKeyString = getColumnKeyString(sets);
        String firstData = "";
        if (StringUtils.isNotEmpty(columnKeyString) && columnKeyString.contains(",")) {
            firstData = columnKeyString.split(",")[0];
        } else {
            firstData = columnKeyString;
        }
        // (预计达成日 - 作业缓冲期 - 风险预警周期 > @#{startTime_s} and 将预计达成日 - 作业缓冲期 - 风险预警周期<=  @#{startTime_e} )
        // DATEPART(hour, DATEADD(hour, -5, DATEADD(day, -10, GETDATE())))
        // DATEDIFF(yyyy,DATEADD(hour, -1, DATEADD(day, -1, APPROVE_DATE)),GETDATE())=0
        String sql = "";

        if (StringUtils.isEmpty(bufferDays) || StringUtils.isEmpty(bufferDaysUnit)) {
            sql = String.format("SELECT %s FROM %s WHERE DATEADD(%s, -%s, %s) >= @#{startTime_s} AND DATEADD(%s, -%s, %s) <= @#{startTime_e}",
                    columnKeyString + ","  + targetColumn + "," + firstData + " as sourceIds ",
                    sPart.getTargetTable(),
                    riskWarningDaysUnit.toLowerCase(),
                    riskWarningDays,
                    targetColumn,
                    riskWarningDaysUnit.toLowerCase(),
                    riskWarningDays,
                    targetColumn);
        } else {
            sql = String.format("SELECT %s FROM %s WHERE DATEADD(%s, -%s, DATEADD(%s, -%s, %s)) >= @#{startTime_s} AND DATEADD(%s, -%s, DATEADD(%s, -%s, %s)) <= @#{startTime_e}",
                    columnKeyString + ","  + targetColumn + "," + firstData + " as sourceIds ",
                    sPart.getTargetTable(),
                    riskWarningDaysUnit.toLowerCase(),
                    riskWarningDays,
                    bufferDaysUnit.toLowerCase(),
                    bufferDays,
                    targetColumn,
                    riskWarningDaysUnit.toLowerCase(),
                    riskWarningDays,
                    bufferDaysUnit.toLowerCase(),
                    bufferDays,
                    targetColumn
            );
        }

        /*if (StringUtils.isEmpty(bufferDays) || StringUtils.isEmpty(bufferDaysUnit)) {
            sql = String.format("SELECT %s FROM %s WHERE DATEDIFF(%s,DATEADD(%s, -%s, %s),GETDATE())=0 ",
                    columnKeyString + ","  + targetColumn,
                    sPart.getTargetTable(),
                    Objects.equals(timeType,"week") ? "year" : timeType,
                    riskWarningDaysUnit.toLowerCase(),
                    riskWarningDays,
                    targetColumn);

            if (Objects.equals(timeType,"week")) {
                sql = sql + String.format("AND DATEPART(%s, DATEADD(%s, -%s, %s)) = DATEPART(%s, GETDATE())",
                        timeType,
                        riskWarningDaysUnit.toLowerCase(),
                        riskWarningDays,
                        targetColumn,
                        timeType);
            }
        }else {
            sql = String.format("SELECT %s FROM %s WHERE DATEDIFF(%s,DATEADD(%s, -%s, DATEADD(%s, -%s, %s)),GETDATE())=0 ",
                    columnKeyString + ","  + targetColumn,
                    sPart.getTargetTable(),
                    Objects.equals(timeType,"week") ? "year" : timeType,
                    riskWarningDaysUnit.toLowerCase(),
                    riskWarningDays,
                    bufferDaysUnit.toLowerCase(),
                    bufferDays,
                    targetColumn
                    );
            if (Objects.equals(timeType,"week")) {
                sql = sql + String.format("AND DATEPART(%s, DATEADD(%s, -%s, DATEADD(%s, -%s, %s))) = DATEPART(%s, GETDATE())",
                        timeType,
                        riskWarningDaysUnit.toLowerCase(),
                        riskWarningDays,
                        bufferDaysUnit.toLowerCase(),
                        bufferDays,
                        targetColumn,
                        timeType);
            }
        }*/
        return sql;
    }

    private String getTimeType(SystemPart sPart) {
        String timeType = "day";
        if (sPart.getStandard_polling_rule() == null) {
            return timeType;
        }
        Integer frequency = sPart.getStandard_polling_rule().getFrequency();
        Integer weekly = sPart.getStandard_polling_rule().getWeekly();
        Integer monthly = sPart.getStandard_polling_rule().getMonthly();

        if (weekly != null) {
            timeType = "week";
        } else if (monthly != null) {
            timeType = "month";
        } else {
            switch (frequency) {
                case 1:
                    timeType = "minute";
                    break;
                case 2:
                    timeType = "hour";
                    break;
                default:
                    timeType = "day";
                    break;
            }
        }
        return timeType;
    }

    private String getColumnKeyString(Sets sets) {
        if (sets.getA() == null || sets.getA().getPart() == null) {
            return "";
        }
        Set<String> keys = Optional.ofNullable(sets.getA())
                .map(Acting::getPart)
                .map(TaskCardPart::getPageViewDESC)
                .orElse(Collections.emptyList())
                .stream()
                .flatMap(pg -> Optional.ofNullable(pg.getColumn()).orElse(Collections.emptyList()).stream())
                .flatMap(column -> column.keySet().stream())
                .collect(Collectors.toCollection(LinkedHashSet::new));
        return String.join(",", keys);
    }

    private void deleteMonitorRule(String ruleId,String tenantVersion) {
        Map<String,Object> param = new HashMap<>();
        param.put("pluginId",ruleId);
        param.put("version",tenantVersion);
        String deleteCyhper = "match(m:MonitorRule{pluginId:$pluginId,version:$version}) detach delete m";
        kgHelpService.executeCyhper(deleteCyhper,param);

        Query query = Query.query(Criteria.where("pluginId").is(ruleId).and("version").is(tenantVersion));
        mongoTemplateSystem.remove(query, MonitorRuleProductConfig.class);
    }

    // 构建侦测和应用之间的关系
    private void buildApplicationRelation(SetsRelatedInfo setsRelatedInfo, String setsCode,String appCode, String appName, String ruleId, String ruleName, String tenantVersion) {
        ApplicationRelation applicationRelation = new ApplicationRelation();
        applicationRelation.setAppCode(appCode);
        applicationRelation.setAppName(appName);
        applicationRelation.setCode(ruleId);
        applicationRelation.setType("monitorRule");
        applicationRelation.setName(ruleName);
        applicationRelation.setVersion(tenantVersion);
        applicationRelation.setApplication(appCode);
        applicationRelation.setAthena_namespace(appCode);
        applicationRelation.setPluginId(setsCode);
        applicationRelation.setTenantId("SYSTEM");
        setsRelatedInfo.setApplicationRelation(applicationRelation);
    }

    private void deleteApplicationRelation(String appCode,String ruleId,String tenantVersion) {
        Query query = new Query();
        query.addCriteria(Criteria.where("appCode").is(appCode).and("version").is(tenantVersion).and("code").is(ruleId));
        mongoTemplateSystem.remove(query, ApplicationRelation.class);
    }

    private void buildVariableDefinition(SetsRelatedInfo setsRelatedInfo,Sets sets, String ruleId, String ruleName,String tenantVersion,String productName) {
        StandardPollingRule rules = sets.getS().getPart().getStandard_polling_rule();
        String detectType = sets.getS().getPart().getDetectType();
        String timeType = getDefaultValue(rules);
        VariableDefinition variableDefinition = new VariableDefinition();
        variableDefinition.setName(ruleName);
        variableDefinition.setDescription(ruleName);
        variableDefinition.setIsExecute(Boolean.TRUE);
        variableDefinition.setCode(ruleId);
        variableDefinition.setForceOpen(Boolean.FALSE);
        variableDefinition.setIsOperation(Boolean.FALSE);
        variableDefinition.setDefaultValue(timeType);
        variableDefinition.setExtendData(ruleId);
        variableDefinition.setFormat("rule;yyyyMMdd HH:mm;switch");
        variableDefinition.setReadOnly(Boolean.FALSE);
        variableDefinition.setRequired(Boolean.TRUE);
        variableDefinition.setExecutable(1);
        variableDefinition.setSequence(1);
        variableDefinition.setDisplayType("PERIODIC");
        variableDefinition.setCategory("period");
        variableDefinition.setIsSimulation(Boolean.FALSE);
        variableDefinition.setVersion(tenantVersion);
        variableDefinition.setAthena_namespace(sets.getAppCode());
        variableDefinition.setPluginId(sets.getCode());

        if (!StringUtils.equalsIgnoreCase(MonitorRuleCategoryEnum.API.toString(), detectType)) {
            // api类型侦测不控制显影，直接展示
            DynamicCondition visibleCondition = new DynamicCondition();
            visibleCondition.setType("SINGLE");
            visibleCondition.setOp("IN");
            visibleCondition.setLeft("productName");
            visibleCondition.setLeftValueType("SYSTEM");
            visibleCondition.setRightValueType("CONSTANT");
            visibleCondition.setRight(productName);
            variableDefinition.setVisibleCondition(visibleCondition);
        }
        setsRelatedInfo.setVariableDefinition(variableDefinition);
    }

    private String getDefaultValue(StandardPollingRule rules) {
        String timeType = "";
        if (null != rules.getRepeat_type()) {
            if (rules.getRepeat_type() == 1) {
                timeType = "F";
            }
            if (rules.getRepeat_type() == 2) {
                timeType = "H";
            }
            if (rules.getRepeat_type() == 3) {
                timeType = "D";
            }
            timeType = timeType + rules.getFrequency();
        }else if (rules.getWeekly() != null) {
            Map<String,String> week = new HashMap<>();
            week.put("SU","7");
            week.put("MO","1");
            week.put("TU","2");
            week.put("WE","3");
            week.put("TH","4");
            week.put("FR","5");
            week.put("SA","6");
            timeType = "W" + week.get(rules.getByday());
        }else if (rules.getMonthly() != null) {
            timeType = "M" + rules.getBymonthday();
        }
        return timeType + ";" + rules.getStart_time().substring(0,16).replaceAll("-","") + ";" + Boolean.TRUE;
    }

    private void deleteVariableDefinition(String ruleId,String tenantVersion) {
        // 删除应用参数
        Query query = new Query();
        query.addCriteria(Criteria.where("code").is(ruleId).and("version").is(tenantVersion));
        mongoTemplateSystem.remove(query, VariableDefinition.class);
    }

    // 获取租户的稳态产品
    public String getTenantProduct() {
        try {
            List<String> tenantProductList = actionService.getTenantProductList();
            if (!CollectionUtils.isEmpty(tenantProductList)) {
                List<String> productName = (List<String>) productService.getAllSteadyProduct();
                String s = productName.stream().filter(e -> tenantProductList.contains(e)).findFirst().orElse(SetConstants.PRODUCT_NAME);
                return s;
            }
        }catch (Exception e) {
            log.error("Sets getTenantProduct error:{}",e);
        }
        return SetConstants.PRODUCT_NAME;
    }

    // 更新租户的侦测数据并且通知sd停用
    private void updateTenantMonitorRuleStatus(String ruleId) {
        Query query = new Query();
        Criteria criteria = Criteria.where("monitorRuleId").is(ruleId);
        query.addCriteria(criteria);
        List<MonitorRuleTenantConfig> monitorRuleTenantConfigList = mongoTemplate.find(query, MonitorRuleTenantConfig.class);
        try {
            if (!CollectionUtils.isEmpty(monitorRuleTenantConfigList)) {
                for (MonitorRuleTenantConfig monitorRuleTenantConfig : monitorRuleTenantConfigList) {
                    monitorRuleConfigService.putDisable(monitorRuleTenantConfig.getTenantId(),monitorRuleTenantConfig.getMonitorRuleId(),monitorRuleTenantConfig.getEocMap());
                }
            }
        } catch (Exception e) {
            log.error("Sets  updateTenantMonitorRuleStatus error: {}",e);
        }
    }
}
