package com.digiwin.athena.knowledgegraph.set.partParsers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.core.*;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.core.flow.FlowLink;
import com.digiwin.athena.domain.core.flow.FlowNode;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.definition.*;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.set.*;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.TranslateUtils;
import com.digiwin.athena.set.part.PageViewDESC;
import com.digiwin.athena.set.part.Part;
import com.digiwin.athena.set.part.Processor;
import com.digiwin.athena.set.part.TaskCardPart;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

@Service
@Slf4j
public class TaskCardPartParser implements IPartParser {

    @Autowired
    DataMapService dataMapService;

    @Autowired
    TranslateUtils translateUtils;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;

    @Override
    public boolean accept(Part part) {
        return StringUtils.equalsIgnoreCase("taskCard", part.getType());
    }

    @Override
    public void parse(SetParseContext context, Part part) throws DWBusinessException {
        Map<String,Object> dtdRelatedInfoMap = new HashMap<>();
        TaskCardPart taskCardPart = (TaskCardPart) part;

        DTDRelatedInfo dtdRelatedInfo = new DTDRelatedInfo();
        context.setDtdRelatedInfo(dtdRelatedInfo);

        buildDataDescriptionAndDataState(context, taskCardPart);
        // pageView 在task之前创建，task里需要pageView的Code
        buildPageView(context, taskCardPart);

        buildTask(context, taskCardPart);

        buildProject(context, taskCardPart);

        buildAppRelation(context);
        // 调用datamap
        log.info("before translateContent:{}", context.getDtdRelatedInfo());
        //translateContent 接口需要传入对象，先通过 DisableCircularReferenceDetect 去除原对象中的引用，然后在转回来
        String infoStr = translateUtils.translateContent(JSON.parseObject(JSON.toJSONString(context.getDtdRelatedInfo(), SerializerFeature.DisableCircularReferenceDetect), DTDRelatedInfo.class));
        dtdRelatedInfoMap.put("dtdRelatedInfo",JSON.parseObject(infoStr,DTDRelatedInfo.class));
        dataMapService.requestDataMap("/set/saveDtdRelatedInfo","post",dtdRelatedInfoMap);
    }

    private void buildAppRelation(SetParseContext context){
        String pluginId = context.getCurrentSet().getCode();
        Query query = new Query(Criteria.where("pluginId").is(pluginId));
        this.mongoTemplateSystem.remove(query, "applicationRelation");

        List<ApplicationRelation> lists = new ArrayList<>();
        DTDRelatedInfo dtdRelatedInfo = context.getDtdRelatedInfo();
        Project project = dtdRelatedInfo.getProject();
        ApplicationRelation applicationRelation = new ApplicationRelation();
        applicationRelation.setCode(project.getCode());
        applicationRelation.setName(project.getName());
        applicationRelation.setType("task");
        applicationRelation.setAppCode(context.getCurrentSet().getAppCode());
        applicationRelation.setPluginId(pluginId);
        applicationRelation.setVersion("1.0");
        lists.add(applicationRelation);


        List<Task> taskList = dtdRelatedInfo.getTaskList();
        for(Task task : taskList){
            ApplicationRelation applicationRelation1 = new ApplicationRelation();
            applicationRelation1.setCode(task.getCode());
            applicationRelation1.setName(task.getName());
            applicationRelation1.setType("activity");
            applicationRelation1.setAppCode(context.getCurrentSet().getAppCode());
            applicationRelation1.setPluginId(pluginId);
            applicationRelation1.setVersion("1.0");
            lists.add(applicationRelation1);
        }

        this.mongoTemplateSystem.insert(lists, "applicationRelation");
    }


    private void buildDataDescriptionAndDataState(SetParseContext context, TaskCardPart part){
        DataDescription dataDescription = new DataDescription();
        dataDescription.setCode(context.getCurrentSet().getCode());
        dataDescription.setTenantId("SYSTEM");
        dataDescription.setApplication(context.getCurrentSet().getAppCode());
        dataDescription.setVersion("1.0");

        FieldDescription dataStruct = new FieldDescription();
        dataStruct.setDataType("OBJECT");
        dataStruct.setKey(SetConstants.DATAOBJECT); //TODO 这个可能要改，不确定是不是这个
        dataStruct.setFields(this.getFields(part));
        dataDescription.setDataStruct(dataStruct);

        dataDescription.setUniKeys(this.getUnKeys(part));
        dataDescription.setPluginId(context.getCurrentSet().getCode());

        //套件发起的项目中有一个任务，所以会有两个状态
        List<DataState> dataStateList = new ArrayList<>();
        DataState dataState = new DataState();
        dataState.setTenantId("SYSTEM");
        dataState.setApplication(context.getCurrentSet().getAppCode());
        dataState.setVersion("1.0");
        dataState.setCode(context.getCurrentSet().getCode() + "_1");
        dataState.setDataCode(dataDescription.getCode());
        dataState.setName("待执行");
        dataState.setPluginId(context.getCurrentSet().getCode());

        DataState dataState2 = new DataState();
        dataState2.setTenantId("SYSTEM");
        dataState2.setApplication(context.getCurrentSet().getAppCode());
        dataState2.setVersion("1.0");
        dataState2.setCode(context.getCurrentSet().getCode() + "_2");
        dataState2.setDataCode(dataDescription.getCode());
        dataState2.setName("已执行");
        dataState2.setPluginId(context.getCurrentSet().getCode());

        dataStateList.add(dataState);
        dataStateList.add(dataState2);

        context.getDtdRelatedInfo().setDataDescription(dataDescription);
        context.getDtdRelatedInfo().setDataStateList(dataStateList);
        //此处的两个D是自动创建套件任务的起始和结束节点
        context.getDtdRelatedInfo().setFrom(dataState.getCode());
        context.getDtdRelatedInfo().setTo(dataState2.getCode());

        context.getDtdRelatedInfo().setProjectInitDataState(dataState);
        context.getDtdRelatedInfo().setProjectEndDataState(dataState2);
    }


    private List<String> getUnKeys(TaskCardPart part){
        List<String> unKeys = new ArrayList<>();
        List<PageViewDESC> pageViewDESCList = part.getPageViewDESC();
        if(!CollectionUtils.isEmpty(pageViewDESCList)){
            PageViewDESC pageViewDESC = pageViewDESCList.get(0);
            List<Map<String, Object>> columnList = pageViewDESC.getColumn();

            for(Map<String, Object> map : columnList){
                FieldDescription fieldDescription = new FieldDescription();
                fieldDescription.setDataType("STRING");

                Set<String> keySet = map.keySet();
                String key = keySet.iterator().next();

                unKeys.add(key);
            }
        }
        return unKeys;
    }

    private List<FieldDescription> getFields(TaskCardPart part){
        List<FieldDescription> list = new ArrayList<>();
        List<PageViewDESC> pageViewDESCList = part.getPageViewDESC();
        if(!CollectionUtils.isEmpty(pageViewDESCList)){
            PageViewDESC pageViewDESC = pageViewDESCList.get(0);
            List<Map<String, Object>> columnList = pageViewDESC.getColumn();

            for(Map<String, Object> map : columnList){
                FieldDescription fieldDescription = new FieldDescription();
                fieldDescription.setDataType("STRING");

                Set<String> keySet = map.keySet();
                String key = keySet.iterator().next();
                fieldDescription.setKey(key);
                fieldDescription.setName(String.valueOf(map.get(key)));
                list.add(fieldDescription);
            }
        }
        return list;
    }

    private Project buildProject(SetParseContext context, TaskCardPart part){
        Project project = new Project();
        project.setTenantId("SYSTEM");
        project.setApplication(context.getCurrentSet().getAppCode());
        project.setVersion("1.0");
        project.setPluginId(context.getCurrentSet().getCode());
        project.setCode(SetConstants.PROJECT_PREFIX + context.getCurrentSet().getCode());
        project.setName(this.getTaskCardName(part));
        project.setDescription(this.getTaskCardName(part));
        project.setType("BUSINESS");
        project.setExecuteType("user");
        project.setPresetVariables(Arrays.asList());
        project.setMerge(false);
        project.setAssignConfig(this.getAssignConfig());
        project.setAtmcDatas(this.atmcDatas());
        ProjectTarget projectTarget = new ProjectTarget();
        projectTarget.setName(this.getTaskCardName(part));
        projectTarget.setCode(SetConstants.PROJECT_PREFIX + context.getCurrentSet().getCode());
        project.setTarget(projectTarget);
        project.setEnd(context.getDtdRelatedInfo().getProjectEndDataState());
        project.setInit(context.getDtdRelatedInfo().getProjectInitDataState());
        project.setPersonInCharge(this.getUserDefinition(part.getProcessor()));
        project.setPhases(this.getPhases(context.getDtdRelatedInfo().getTaskList()));
        project.setMainLineTasks(this.getMainLineTask(context.getDtdRelatedInfo().getTaskList()));
        project.setSourceName(SetConstants.DATAOBJECT);
        project.setSourceEntityName(SetConstants.DATAOBJECT);
        project.setAssignAble(true);
        context.getDtdRelatedInfo().setProject(project);
        return project;
    }

    private List<String> getMainLineTask(List<Task> tasks){
        List<String> collect = tasks.stream().map(Task::getCode).collect(Collectors.toList());
        return collect;

    }

    private List<Phase> getPhases(List<Task> tasks){
        List<Phase> phases = new ArrayList<>();
        for(Task task : tasks){
            Phase phase = new Phase();
            phase.setCode(task.getCode());
            phase.setName(task.getName());
            phase.setTaskCodes(Arrays.asList(task.getCode()));
            phases.add(phase);
        }
        return phases;
    }

    private void buildTask(SetParseContext context, TaskCardPart part) throws DWBusinessException{
        List<Activity> activities = this.buildActivity(context, part);
        FlowGraph flowGraph = this.buildFlow(context, activities);


        List<PageView> pageViews = context.getDtdRelatedInfo().getPageViewList();
        if(CollectionUtils.isEmpty(pageViews)){
            throw new DWBusinessException("PageView is empty");
        }
        PageView pageView = pageViews.get(0);

        Task task = new Task();
        task.setTenantId("SYSTEM");
        task.setApplication(context.getCurrentSet().getAppCode());
        task.setVersion("1.0");
        task.setPluginId(context.getCurrentSet().getCode());
        task.setCode(context.getCurrentSet().getCode());
        task.setPattern("BUSINESS_ASSISTAN");
        task.setType("business");
        task.setExecuteType("manual");
        task.setFlowCode(flowGraph.getCode());
        task.setPageCode(pageView.getCode());
        task.setMerge(false);
        task.setCategory("ASSISTAN");
        task.setMilestone(true);
        task.setPriority(0);
        task.setName(this.getTaskCardName(part));
        task.setFrom(Arrays.asList(context.getDtdRelatedInfo().getFrom()));
        task.setTo(Arrays.asList(context.getDtdRelatedInfo().getTo()));

        StateMap stateMap = new StateMap();
        stateMap.setInput(context.getDtdRelatedInfo().getFrom());
        Map<String, String> output = new HashMap();
        output.put("end0", context.getDtdRelatedInfo().getTo()); // key的值与FlowGraph中end节点的dataKey值相等
        stateMap.setOutput(output);
        task.setStateMaps(Arrays.asList(stateMap));

        //貌似是固定写死的

        task.setAssignConfig(this.getAssignConfig());

        //添加传给atmc的变量，一般会默认有前3个，后续需要再加

        task.setAtmcDatas(this.atmcDatas());


        context.getDtdRelatedInfo().setTaskList(Arrays.asList(task));
        context.getDtdRelatedInfo().setFlowGraphList(Arrays.asList(flowGraph));
        context.getDtdRelatedInfo().setActivityList(activities);
    }

    private List<AtmcData> atmcDatas(){
        List<AtmcData> atmcDatas = new ArrayList<>();
        AtmcData atmcData = new AtmcData();
        atmcData.setProVarKey("personInCharge");
        atmcData.setAthenaKey("personInCharge");
        atmcDatas.add(atmcData);

        AtmcData atmcData2 = new AtmcData();
        atmcData2.setProVarKey("dueDate");
        atmcData2.setAthenaKey("dueDate");
        atmcDatas.add(atmcData2);

        AtmcData atmcData3 = new AtmcData();
        atmcData3.setProVarKey("sourceIds");
        atmcData3.setAthenaKey("sourceIds");
        atmcDatas.add(atmcData3);

//        AtmcData atmcData4 = new AtmcData();
//        atmcData4.setProVarKey(SetConstants.DATAOBJECT);
//        atmcData4.setAthenaKey(SetConstants.DATAOBJECT);
//        atmcDatas.add(atmcData4);

        AtmcData atmcData5 = new AtmcData();
        atmcData5.setProVarKey("ASSISTAN_WAITTING");
        atmcData5.setAthenaKey("ASSISTAN_WAITTING");
        atmcDatas.add(atmcData5);

        AtmcData atmcData6 = new AtmcData();
        atmcData6.setProVarKey("ASSISTAN_FINISHED");
        atmcData6.setAthenaKey("ASSISTAN_FINISHED");
        atmcDatas.add(atmcData6);

        AtmcData atmcData7 = new AtmcData();
        atmcData7.setProVarKey("ASSISTAN_METADATA");
        atmcData7.setAthenaKey("ASSISTAN_METADATA");
        atmcDatas.add(atmcData7);

        return atmcDatas;
    }

    private AssignConfig getAssignConfig(){
        String assignConfigStr = "{\"action\":{\"sequence\":0,\"actionParams\":[{\"name\":\"liable_person_info\",\"type\":\"PROCESS_VARIABLE\",\"value\":\"question_info\"}],\"actionId\":\"esp_transfer.principal.info.update\",\"title\":\"更新任务\",\"type\":\"ESP\",\"serviceName\":\"transfer.principal.info.update\"},\"assignAble\":true}";
        AssignConfig assignConfig = JSON.parseObject(assignConfigStr, AssignConfig.class);
        return assignConfig;
    }


    private String getTaskCardName(TaskCardPart part){
        String title = null;
        List<PageViewDESC> pageViewDESC = part.getPageViewDESC();
        if(!CollectionUtils.isEmpty(pageViewDESC)){
            title = pageViewDESC.get(0).getTitle();
        }
        return title == null ? "套件任务" : title;
    }

//    private String getUUID(){
//        return UUID.randomUUID().toString().replace("-", "");
//    }


    private FlowGraph buildFlow(SetParseContext context, List<Activity> activitys){
//        String activityCode = activity.getCode();

        FlowGraph flowGraph = new FlowGraph();
        flowGraph.setCode(context.getCurrentSet().getCode());
        flowGraph.setTenantId("SYSTEM");
        flowGraph.setVersion("1.0");
        flowGraph.setPluginId(context.getCurrentSet().getCode());
        flowGraph.setApplication(context.getCurrentSet().getAppCode());
        flowGraph.setLinks(new ArrayList<>());
        flowGraph.setNodes(new ArrayList<>());

        String startNodeId = "start_" + context.getCurrentSet().getCode();
        String endNodeId = "end_" + context.getCurrentSet().getCode();

        FlowNode start = new FlowNode();
        start.setId(startNodeId);
        start.setType("start");
        flowGraph.getNodes().add(start);

        FlowNode endNode = new FlowNode();
        endNode.setId(endNodeId);
        endNode.setDataKey("end0");  // 与Task中stateMaps中有关系
        endNode.setType("end");
        flowGraph.getNodes().add(endNode);

        String from = startNodeId;
        for(Activity activity : activitys){
            FlowNode endNode2 = new FlowNode();
            endNode2.setId(activity.getCode());
            endNode2.setActivityCode(activity.getCode());
            endNode2.setName(activity.getName());
            endNode2.setType("activity");
            flowGraph.getNodes().add(endNode2);


            FlowLink flowLink = new FlowLink();
            flowLink.setFrom(from);
            flowLink.setTo(activity.getCode());
            flowGraph.getLinks().add(flowLink);

            from = activity.getCode();
        }

//        FlowLink flowLink = new FlowLink();
//        flowLink.setFrom(startNodeId);
//        flowLink.setTo(activityCode);
//        flowGraph.getLinks().add(flowLink);

        FlowLink flowLink2 = new FlowLink();
        flowLink2.setFrom(from);
        flowLink2.setTo(endNodeId);
        flowGraph.getLinks().add(flowLink2);

        return flowGraph;
    }

    private List<Activity>  buildActivity(SetParseContext context, TaskCardPart part){
        Activity activity0 = new Activity();
        activity0.setTenantId("SYSTEM");
        activity0.setApplication(context.getCurrentSet().getAppCode());
        activity0.setVersion("1.0");
        activity0.setPluginId(context.getCurrentSet().getCode());
        activity0.setCode(context.getCurrentSet().getCode() + "_1");
        activity0.setType("script");
        activity0.setName("获取数据来源");
        activity0.setMilestone(false);
        Map<String, Object> config = new HashMap<>();
        Map<String, Object> scriptMode = new HashMap<>();
        scriptMode.put("responseScript", this.getResponseScript(context, part));
        config.put("scriptMode", scriptMode);
        config.put("executionMode", "script");
        activity0.setConfig(config);


        Activity activity = new Activity();
        activity.setTenantId("SYSTEM");
        activity.setApplication(context.getCurrentSet().getAppCode());
        activity.setVersion("1.0");
        activity.setPluginId(context.getCurrentSet().getCode());
        activity.setCode(context.getCurrentSet().getCode()  + "_2");
        activity.setType("manual");
        activity.setName("手动");
        activity.setExecutor(this.getUserDefinition(part.getProcessor()));
        activity.setMilestone(true);


        List<Activity> lists = new ArrayList<>();
        //获取数据来源activity在手动activity之前
        lists.add(activity0);
        lists.add(activity);

        return lists;
    }

    private String getSourceIdKey(TaskCardPart part){
        List<PageViewDESC> pageViewDESCList = part.getPageViewDESC();
        if(!CollectionUtils.isEmpty(pageViewDESCList)){
            PageViewDESC pageViewDESC = pageViewDESCList.get(0);
            List<Map<String, Object>> columnList = pageViewDESC.getColumn();

            for(Map<String, Object> map : columnList){
                if (!map.isEmpty()) {
                    Set<String> keySet = map.keySet();
                    return keySet.iterator().next();
                }
            }
        }
        return "";
    }


    private AssistanMetadata getAssistanMetadataFields(TaskCardPart part){
        List<AssistanMetadata> list = new ArrayList<>();
        List<PageViewDESC> pageViewDESCList = part.getPageViewDESC();
        if(!CollectionUtils.isEmpty(pageViewDESCList)){
            PageViewDESC pageViewDESC = pageViewDESCList.get(0);
            List<Map<String, Object>> columnList = pageViewDESC.getColumn();

            for(Map<String, Object> map : columnList){
                AssistanMetadata fieldDescription = new AssistanMetadata();
                fieldDescription.setData_type("string");

                Set<String> keySet = map.keySet();
                String key = keySet.iterator().next();
                fieldDescription.setData_name(key);
                fieldDescription.setDescription(String.valueOf(map.get(key)));
                fieldDescription.setIs_businesskey(true);
                fieldDescription.setRequired(true);
                fieldDescription.setIs_array(false);
                list.add(fieldDescription);
            }
        }

        AssistanMetadata assistanMetadata = new AssistanMetadata();
        assistanMetadata.setData_name("render_array");
        assistanMetadata.setDescription(this.getTaskCardName(part));
        assistanMetadata.setIs_array(true);
        assistanMetadata.setField(list);
        assistanMetadata.setData_type("object");
        assistanMetadata.setIs_businesskey(false);
        assistanMetadata.setRequired(true);

        AssistanMetadata assistanMetadata0 = new AssistanMetadata();
        assistanMetadata0.setData_name("render_obj");
        assistanMetadata0.setDescription(this.getTaskCardName(part));
        assistanMetadata0.setIs_array(false);
        assistanMetadata0.setField(Arrays.asList(assistanMetadata));
        assistanMetadata0.setData_type("object");
        assistanMetadata0.setIs_businesskey(false);
        assistanMetadata0.setRequired(true);

        String infoStr = null;
        try {
            infoStr = translateUtils.translateContent(JSON.parseObject(JSON.toJSONString(assistanMetadata0, SerializerFeature.DisableCircularReferenceDetect), AssistanMetadata.class));
        } catch (DWBusinessException e) {
            log.error(e.getMessage(), e);
        }

        AssistanMetadata assistanMetadata1 = JSON.parseObject(infoStr, AssistanMetadata.class);
        return assistanMetadata1;
    }

    private String getResponseScript(SetParseContext context, TaskCardPart part){
        StringBuilder sb = new StringBuilder();
        sb.append("var ASSISTAN_WAITTING = $(data); \n")
                .append("var ASSISTAN_FINISHED = []; \n")
                .append("var ASSISTAN_METADATA = ").append(JSON.toJSONString(this.getAssistanMetadataFields(part))).append(";\n")
                .append("var sourceIdKey = '").append(this.getSourceIdKey(part)).append("';\n")
                .append("var sourceIdArray = []; \n")
                .append("ASSISTAN_WAITTING.forEach(function (dat) {\n")
                .append("var sourceId = dat[sourceIdKey]; \n")
                .append("sourceIdArray.push(sourceId);\n")
                .append("});\n")
                .append("var sourceIds = sourceIdArray.join(\",\"); \n")
                .append("return {\n")
                .append("'success': true,\n")
                .append("'processVariable': {\n")
                .append("'ASSISTAN_WAITTING': ASSISTAN_WAITTING,").append("\n")
                .append("'ASSISTAN_FINISHED': ASSISTAN_FINISHED,").append("\n")
                .append("'ASSISTAN_METADATA': ASSISTAN_METADATA,").append("\n")
                .append("'sourceIds': sourceIds,").append("\n")
                .append(" },\n")
                .append("'errorMessage': '' \n")
                .append("};");


        return sb.toString();
    }

    private void buildPageView(SetParseContext context, TaskCardPart part){
        List<PageView> pageViewList = new ArrayList<>();
        String scriptTemplate = AthenaUtils.loadStream("/sets/PageView.json");
        List<PageViewDESC> pageViewDESC = part.getPageViewDESC();
        if (!CollectionUtils.isEmpty(pageViewDESC)) {
            for (PageViewDESC pg : pageViewDESC) {
                String replaced = scriptTemplate.replaceAll("#template_prefix#",context.getCurrentSet().getCode())
                        .replaceAll("#appCode#",context.getCurrentSet().getAppCode())
                        .replaceAll("#name#",context.getCurrentSet().getName())
                        .replaceAll("#title#",pg.getTitle() == null ? "" : pg.getTitle());
                pageViewList.add(JSON.parseObject(replaced,PageView.class));
            }
        }
        context.getDtdRelatedInfo().setPageViewList(pageViewList);
    }


    private UserDefinition getUserDefinition(Processor processor){
        UserDefinition userDefinition = new UserDefinition();
        userDefinition.setChoosePolicy("single");
        userDefinition.setProcessType("signOr");
        Identity identity = new Identity();
        identity.setPerformerType(processor.getType());
        identity.setPerformerValue(processor.getValue());
        identity.setPerformerName(processor.getName());
        userDefinition.setIdentities(Arrays.asList(identity));

        return userDefinition;
    }


}
