package com.digiwin.athena.knowledgegraph.svcomposition.bpm;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.svcomposition.graph.MatrixGraph;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

import static com.digiwin.athena.knowledgegraph.svcomposition.graph.GraphHelperTemplate.getFirstNodeIndex;

/**
 * @ClassName BPMConverter
 * @Description TODO
 * @Author zhuangli
 * @Date 2020/7/21 10:51
 * @Version 1.0
 **/
public class BPMConverter {

    private static final Map EMPTY_MAP = new HashMap();
    private static final String LINK_TYPE = "Straight";
    private static final String CATEGORY_ID = "ThemeMap";
    //private static final Map GATEWAY_MAP = new HashMap(){{put("type",NodeType.PARAGATEWAY);}};

    /**
     * @Author zhuangli
     * @Description 增加首尾节点以及UserTask
     * @Date 17:57 2020/8/21
     * @Param
     * @return
     **/
    public static void addStartEndNodes(MatrixGraph<Map> graph) {
        HashMap start = new HashMap(4);
        start.put("name", "start");
        start.put("index", graph.size());
        start.put("type", NodeType.START);
        graph.insertVertex(start);
        HashMap end = new HashMap(4);
        end.put("name", "end");
        end.put("index", graph.size());
        end.put("type", NodeType.END);
        graph.insertVertex(end);
        //增加用户节点
        HashMap user = new HashMap(4);
        user.put("name", "userTask");
        user.put("index", graph.size());
        user.put("type", NodeType.USER);
        graph.insertVertex(user);
        for (int i = 0; i < graph.size() - 3; i++) {
            if (graph.inDegree(i)==0) {
                //添加user作为前置节点
                graph.insertEdge(graph.size() - 1, i);
            }
            if (graph.outDegree(i)==0) {
                //指向结束节点
                graph.insertEdge(i, graph.size() - 2);
            }
        }
        //从起始节点指向user节点
        graph.insertEdge(graph.size() - 3, graph.size() - 1);
    }

    public static void addGateway(MatrixGraph<Map> graph) {
        int graphPreSize = graph.size();
        for (int i = 0; i < graphPreSize; i++) {
            if (graph.outDegree(i) > 1) {
                List<Integer> outNodeIndexes = graph.outNodeIndexes(i);
                HashMap gateway = new HashMap(4);
                gateway.put("name", "outGateway");
                gateway.put("index", graph.size());
                gateway.put("type", NodeType.PARAGATEWAY);
                graph.insertVertex(gateway);
                graph.insertEdge(i, graph.size() - 1);
                for (int j = 0; j < outNodeIndexes.size(); j++) {
                    graph.removeEdge(i, outNodeIndexes.get(j));
                    graph.insertEdge(graph.size() - 1, outNodeIndexes.get(j));
                }
            }
            if (graph.inDegree(i) > 1) {
                List<Integer> inNodeIndexes = graph.inNodeIndexes(i);
                HashMap gateway = new HashMap(4);
                gateway.put("name", "inGateway");
                gateway.put("index", graph.size());
                gateway.put("type", NodeType.PARAGATEWAY);
                graph.insertVertex(gateway);
                graph.insertEdge(graph.size() - 1, i);
                for (int j = 0; j < inNodeIndexes.size(); j++) {
                    graph.removeEdge(inNodeIndexes.get(j), i);
                    graph.insertEdge(inNodeIndexes.get(j), graph.size() - 1);
                }
            }
        }
    }

    /**
     * @Author zhuangli
     * @Description 将graph定义转化为bpm的标准格式
     * @Date 14:03 2020/8/19
     * @Param
     * @return
     **/
    public static Process convertToBPMJson(MatrixGraph<Map> graph, String tenantId) throws DWBusinessException {
        Process process = new Process();
        List<Map> nodeMapList = graph.getVertexList();
        int[][] matrix = graph.getMatrix();
        List<Node> nodeList = new LinkedList<>();
        List<Chain> chainList = new LinkedList<>();
        List<Link> linkList = new LinkedList<>();
        List<ProcessVariable> processVariableList = new LinkedList<>();
        //当前节点的序号
        int currentNodeIndex;
        //当前关卡的索引
        //int gatewayIndex = nodeMapList.size() + 1;
        //Stack<Map> gatewayStack = new Stack();
        //节点队列,每个节点按流程先后顺序遍历一遍,可抽象单独方法
        //Queue<Integer> nodeQueue = new LinkedList();
        //TODO 如何判断两个节点依赖的变量是否是同一个?外部变量是否只产生于开始节点的后继节点?
        int startIndex = getFirstNodeIndex(graph);
        //排除user节点
        List<Integer> outIndexes = graph.outNodeIndexes(graph.outNodeIndexes(startIndex).get(0));
        //将节点对应的index加入到需要依赖外部输入变量的list
        List<Integer> requireInputIndexes = new LinkedList<>();
        for (int i = 0; i < outIndexes.size(); i++) {
            Map node = nodeMapList.get(outIndexes.get(i));
            //如果是网关节点则继续往下找一层
            if (node.get("type") == NodeType.PARAGATEWAY) {
                List<Integer> gatewayOutIndexes = graph.outNodeIndexes((Integer) node.get("index"));
                gatewayOutIndexes.forEach(item->{
                    requireInputIndexes.add(item);
                });
            } else {
                requireInputIndexes.add(outIndexes.get(i));
            }
        }
        for (int i = 0; i < nodeMapList.size(); i++) {
            //将每个节点输出添加到流程变量
            ProcessVariable createdPV = ProcessVariableFactory.createProcessVariableOfCreated(nodeMapList.get(i));
            if (null != createdPV) {
                processVariableList.add(createdPV);
            }
            //将依赖外部输入的节点入参添加到流程变量
            if (requireInputIndexes.contains(nodeMapList.get(i).get("index"))) {
                List<ProcessVariable> requiredOutPVs = ProcessVariableFactory.createProcessVariableOfRequired(nodeMapList.get(i));
                if (null != requiredOutPVs) {
                    processVariableList.addAll(requiredOutPVs);
                }
            }
            List<ProcessVariable> requiredPVs = ProcessVariableFactory.createProcessVariableOfRequired(nodeMapList.get(i));
            //从起始节点开始创建节点
            Node node = NodeFactory.createNode(nodeMapList.get(i), tenantId, requiredPVs, createdPV);
            nodeList.add(node);
        }
        //从start节点按顺序遍历节点
        //nodeQueue.offer(startIndex);
        //int nodeSeq = 1;
        for (int i = 0; i < graph.size(); i++) {
            for (int j = 0; j < graph.size(); j++) {
                if (matrix[i][j] > 0) {
                    Chain chain = new Chain(i, j);
                    chainList.add(chain);
                }
            }
        }
        //while (null != nodeQueue.peek()) {
        //currentNodeIndex = nodeQueue.poll();
            /*//产生前驱节点
            //获取前驱节点
            List<Integer> preNodeSeq = graph.inNodeIndexes(currentNodeSeq);
            if (preNodeSeq.size() > 1) {
                Node gatewayNode = NodeFactory.createNode(GATEWAY_MAP,
                        gatewayIndex++);
                nodeList.add(gatewayNode);
                //gatewayStack.pop();
                Chain chain = new Chain(gatewayIndex, currentNodeSeq + 1);
                chainList.add(chain);
                //并行关卡关联前驱节点
                for (int i = 0; i < preNodeSeq.size(); i++) {
                    chainList.add(new Chain(preNodeSeq.get(i) + 1, gatewayIndex));
                }
            }*/
        //从起始节点开始创建节点
            /*Node node = NodeFactory.createNode(nodeMapList.get(currentNodeIndex), nodeSeq++);
            nodeList.add(node);
            //获取后继节点
            List<Integer> nextNodeIndexes = graph.outNodeIndexes(currentNodeIndex);
            if (nextNodeIndexes.size() > 0) {
                nextNodeIndexes.forEach(item-> {
                    nodeQueue.offer(item);
                    Chain chain = new Chain(currentNodeIndex, item);
                    chainList.add(chain);
                });
            }*/
            /*//后继产生分支
            if (nextNodeSeq.size() > 1) {
                Map gatewayMap = new HashMap() {{
                    put("type", NodeType.PARAGATEWAY);
                    put("outDegree", nextNodeSeq.size());
                }};
                Node gatewayNode = NodeFactory.createNode(GATEWAY_MAP,
                        gatewayIndex++);
                nodeList.add(gatewayNode);
                //gatewayStack.push(GATEWAY_MAP);
                Chain chain = new Chain(currentNodeSeq + 1, gatewayIndex);
                chainList.add(chain);
                //并行关卡关联后继节点
                for (int i = 0; i < nextNodeSeq.size(); i++) {
                    chainList.add(new Chain(gatewayIndex, nextNodeSeq.get(i) + 1));
                }
            }*/
        //}
        //去重
        //nodeList = nodeList.parallelStream().filter(distinctByKey(Node::getId)).collect(Collectors.toList());
        Map<Integer, Node> nodeMap = nodeList.stream().collect(Collectors.toMap(Node::getIndex, item -> item));
        chainList.forEach(item -> {
            Node preNode = nodeMap.get(item.getPreIndex());
            Node nextNode = nodeMap.get(item.getNextIndex());
            Link link = LinkFactory.createLink(preNode, nextNode, linkList.size());
            linkList.add(link);
        });
        process.setId("")
                .setName("")
                .setTenantId("athenaTest")
                .setNodes(nodeList)
                .setLinks(linkList)
                .setProcessVariable(processVariableList)
                .setNameI18n(EMPTY_MAP)
                .setLinkType(LINK_TYPE)
                .setLimit(0)
                .setCompletedEvent(EMPTY_MAP)
                .setTerminatedEvent(EMPTY_MAP)
                .setAbortedEvent(EMPTY_MAP)
                .setAbortedNotice(true)
                .setTerminatedNotice(true)
                .setCompletedNotice(true)
                .setReassignNotice(true)
                .setRollbackNotice(true)
                .setCategoryId(CATEGORY_ID)
                .setCurrentAuthorId("");
        return process;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        Set<Object> seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

}
