package com.digiwin.athena.knowledgegraph.synonym.controller.impl;

import com.digiwin.athena.knowledgegraph.synonym.controller.IAppThresholdConfigService;
import com.digiwin.athena.knowledgegraph.synonym.dao.AppThresholdConfigDao;
import com.digiwin.athena.knowledgegraph.synonym.domain.AppThresholdConfig;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.DeleteVo;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.ResultBean;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Author: wangao
 * @CreateTime: 2024-07-24  14:36
 * @Description: TODO
 * @Version: 1.0
 */
@Service
public class AppThresholdConfigImpl implements IAppThresholdConfigService {
    @Autowired
    private AppThresholdConfigDao appThresholdConfigDao;
    @Override
    public ResultBean<Object> getList(String code,String tenantId) {
        try {
            return ResultBean.success(appThresholdConfigDao.findList(code,tenantId));
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> delete(DeleteVo deleteVo) {
        try {
            appThresholdConfigDao.deleteList(deleteVo.getTid(),deleteVo.getIds());
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
        return ResultBean.success("");
    }

    @Override
    public ResultBean<Object> insertList(List<AppThresholdConfig> list) {
        try {
            appThresholdConfigDao.insertAll(list);
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
        return ResultBean.success("");
    }

    @Override
    public ResultBean<Object> update(AppThresholdConfig appThresholdConfig) {
        try {
            appThresholdConfigDao.save(appThresholdConfig);
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
        return ResultBean.success("");
    }
}
