package com.digiwin.athena.knowledgegraph.synonym.controller.impl;

import com.digiwin.athena.kg.report.hz.model.sence.ReportSceneDTO;
import com.digiwin.athena.knowledgegraph.service.IScreenService;
import com.digiwin.athena.knowledgegraph.synonym.controller.IBigScreenViewConfigService;
import com.digiwin.athena.knowledgegraph.synonym.dao.BigScreenViewConfigDao;
import com.digiwin.athena.knowledgegraph.synonym.domain.BigScreenViewConfig;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.DeleteVo;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.ResultBean;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.ScreenInfo;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author: wangao
 * @CreateTime: 2024-08-14  16:51
 * @Description:
 * @Version: 1.0
 */
@Service
@Slf4j
public class BigScreenViewConfigServiceImpl implements IBigScreenViewConfigService {
    @Autowired
    private BigScreenViewConfigDao bigScreenViewConfigDao;
    @Autowired
    private IScreenService screenService;
    @Override
    public ResultBean<Object> getList(String appCode, String tenantId) {
        try {
            return ResultBean.success(bigScreenViewConfigDao.findList(appCode,tenantId));
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> delete(DeleteVo deleteVo) {
        try {
            bigScreenViewConfigDao.deleteList(deleteVo.getTid(),deleteVo.getIds(),deleteVo.getId());
            return ResultBean.success("");
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> insertList(List<BigScreenViewConfig> list) {
        try {
            bigScreenViewConfigDao.insertAll(list);
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
        return ResultBean.success("");
    }

    @Override
    public ResultBean<Object> update(BigScreenViewConfig bigScreenViewConfig) {
        try {
            bigScreenViewConfigDao.save(bigScreenViewConfig);
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
        return ResultBean.success("");
    }

    @Override
    public ResultBean<Object> findOne(String bigScreenViewConfigCode) {
        try {
            return ResultBean.success(bigScreenViewConfigDao.findOne(bigScreenViewConfigCode

            ));
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> getQuerySceneByAppList(String appCode) throws Exception {
        try {
            List<String> strings = new ArrayList<>();
            strings.add(appCode);
            List<ReportSceneDTO> o = (List<ReportSceneDTO>) screenService.postQuerySceneByApp(strings);
            List<ScreenInfo> syncDataVos = new ArrayList<>();
            if (!CollectionUtils.isEmpty(o)){

                for (ReportSceneDTO reportSceneDTO : o) {
                    ScreenInfo screenInfo = new ScreenInfo();
                    screenInfo.setCode(reportSceneDTO.getCode());
                    screenInfo.setSceneTitle(reportSceneDTO.getSceneTitle());
                    screenInfo.setDescription(reportSceneDTO.getDescription());
                    syncDataVos.add(screenInfo);
                }
            }
            return ResultBean.success(syncDataVos);
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
    }
}
