package com.digiwin.athena.knowledgegraph.synonym.controller.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.synonym.controller.IBusinessVariablesService;
import com.digiwin.athena.knowledgegraph.synonym.dao.BusinessVariablesDao;
import com.digiwin.athena.knowledgegraph.synonym.domain.BusinessVariables;
import com.digiwin.athena.knowledgegraph.synonym.domain.BusinessVariablesValue;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.DeleteVo;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.ResultBean;
import com.digiwin.athena.knowledgegraph.synonym.enums.SourceEnum;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

/**
 * @Author: wangao
 * @CreateTime: 2024-08-28  11:13
 * @Description:
 * @Version: 1.0
 */
@Service
@Slf4j
public class BusinessVariablesServiceImpl implements IBusinessVariablesService {
    @Autowired
    private BusinessVariablesDao businessVariablesDao;
    @Autowired
    private KgInnerService kgInnerService;
    @Override
    public ResultBean<Object> insertList(List<BusinessVariablesValue> businessVariables) {
        try {
            businessVariablesDao.insertBusinessVariables(businessVariables);
            return ResultBean.success("");
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> update(BusinessVariablesValue businessVariables) {
        try {
            businessVariablesDao.updateBusinessVariables(businessVariables);
            return ResultBean.success("");
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> delete(DeleteVo deleteVo) {
        try {
            businessVariablesDao.deleteBusinessVariables(deleteVo);
            return ResultBean.success("");
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> getPage(String appCode,String tid, int pageNum, int pageSize) {
        try {
            return ResultBean.success(businessVariablesDao.queryBusinessVariables(appCode,tid,pageNum,pageSize));
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> getList(String tid,String appCode) {
        try {
            return ResultBean.success(businessVariablesDao.queryBusinessVariablesValue(tid,appCode));
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
    }
    @Override
    public ResultBean<Object> getListNoValue(String tid,String appCode) {
        try {
            return null;
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> syncData(DeleteVo deleteVo) {
        try {
            syncValueData(deleteVo.getTid(),deleteVo.getAppCode());
            return ResultBean.success("");
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> dealHistoryData() {
        List<BusinessVariablesValue> list = businessVariablesDao.queryAll();
        for(BusinessVariablesValue item:list){
            item.setSource(SourceEnum.CUSTOM.getType());
        }

        businessVariablesDao.saveBusinessVariables(list);

        return ResultBean.success("");
    }

    private void syncValueData(String tid,String appCode) {
        if (StringUtils.isEmpty(tid)){
            throw new BusinessException("未获取到当前用户的租户");
        }
        String tenantVersion = kgInnerService.getTenantVersion(tid);
        List<BusinessVariablesValue> businessVariablesValues = businessVariablesDao.queryBusinessVariablesValue(tid,appCode);
        List<BusinessVariables> businessVariables = businessVariablesDao.queryBusinessVariables(appCode,tenantVersion);
        List<BusinessVariablesValue> newList = new ArrayList<>();
        Map<String,BusinessVariablesValue> valueMap = new HashMap<>();
        Map<String,BusinessVariables> map = new HashMap<>();
        if (!CollectionUtils.isEmpty(businessVariablesValues)) {
            for (BusinessVariablesValue businessVariablesValue : businessVariablesValues) {
                valueMap.put(businessVariablesValue.getCode(),businessVariablesValue);
            }
        }
        if (!CollectionUtils.isEmpty(businessVariables)) {
            for (BusinessVariables businessVariable : businessVariables) {
                map.put(businessVariable.getCode(),businessVariable);
            }
        }
        DeleteVo deleteVo = new DeleteVo();
        deleteVo.setTid(tid);
        deleteVo.setAppCode(appCode);
        if (CollectionUtils.isEmpty(businessVariables)){
            //无租户发布数据，删除租户值配置
            businessVariablesDao.deleteBusinessVariables(deleteVo);
        }else {
            List<String> idList = new ArrayList<>();
            for (BusinessVariables businessVariable : businessVariables) {
                BusinessVariablesValue businessVariablesValue = valueMap.get(businessVariable.getCode());
                String variableDataType = businessVariable.getData_type();
                if (businessVariablesValue == null){
                    newList.add(toValue(businessVariable,businessVariablesValue,tid));
                }else if (Boolean.TRUE.equals(compareOld(businessVariablesValue,businessVariable))||!businessVariablesValue.getData_type().equals(variableDataType)){
                    newList.add(toValue(businessVariable,businessVariablesValue,tid));
                    idList.add(businessVariablesValue.getId());
                }
            }
            for (BusinessVariablesValue businessVariablesValue : businessVariablesValues) {
                BusinessVariables variables = map.get(businessVariablesValue.getCode());
                if (variables == null){
                    idList.add(businessVariablesValue.getId());
                }
            }
            if (!CollectionUtils.isEmpty(idList)){
                deleteVo.setIds(idList);
                businessVariablesDao.deleteBusinessVariables(deleteVo);
            }
            businessVariablesDao.insertBusinessVariables(newList);
        }
    }

    private Boolean compareOld(BusinessVariablesValue oldValue,BusinessVariables newValue){
        String oldValueDescription = oldValue.getDescription();
        String newValueDescription = newValue.getDescription();
        String oldValueName = oldValue.getName();
        String newValueName = newValue.getName();
        if(!oldValueName.equals(newValueName)){
            return true;
        }
        if (!StringUtils.isEmpty(oldValueDescription)&&!StringUtils.isEmpty(newValueDescription)){
            if (!oldValueDescription.equals(newValueDescription)){
                return true;
            }
        }else if (StringUtils.isEmpty(oldValueDescription)&&!StringUtils.isEmpty(newValueDescription)){
            return true;
        }
        if (!newValue.getData_type().equals(oldValue.getData_type())){
            return true;
        }
        return !Objects.equals(newValue.getOperationTag(), oldValue.getOperationTag());
    }

    private BusinessVariablesValue toValue(BusinessVariables businessVariables,BusinessVariablesValue oldBusinessVariablesValue,String tenantId) {
        BusinessVariablesValue businessVariablesValue = new BusinessVariablesValue();
        businessVariablesValue.setId(UUID.randomUUID().toString());
        businessVariablesValue.setLang(JSON.parseObject(businessVariables.getLang()));
        businessVariablesValue.setData_name(businessVariables.getData_name());
        businessVariablesValue.setStatus("0");
        businessVariablesValue.setSource(businessVariables.getSource());
        if (oldBusinessVariablesValue != null) {
            businessVariablesValue.setValue(oldBusinessVariablesValue.getValue());
            businessVariablesValue.setUpdateBy(oldBusinessVariablesValue.getUpdateBy());
            businessVariablesValue.setUpdateDate(oldBusinessVariablesValue.getUpdateDate());
            businessVariablesValue.setCompileVersion(businessVariables.getCompileVersion());
            businessVariablesValue.setStatus(oldBusinessVariablesValue.getStatus());
            if(StringUtil.isNotEmpty(oldBusinessVariablesValue.getSource())){
                businessVariablesValue.setSource(oldBusinessVariablesValue.getSource());
            }
        }
        businessVariablesValue.setTenantId(tenantId);
        businessVariablesValue.setDescription(businessVariables.getDescription());
        businessVariablesValue.setData_type(businessVariables.getData_type());
        businessVariablesValue.setAppCode(businessVariables.getAppCode());
        businessVariablesValue.setOperationTag(businessVariables.getOperationTag());
        businessVariablesValue.setName(businessVariables.getName());
        businessVariablesValue.setCode(businessVariables.getCode());

        return businessVariablesValue;
    }
}
