package com.digiwin.athena.knowledgegraph.synonym.controller.impl;

import com.digiwin.athena.knowledgegraph.synonym.controller.IErrorSynonymService;
import com.digiwin.athena.knowledgegraph.synonym.dao.ErrorSynonymDao;
import com.digiwin.athena.knowledgegraph.synonym.domain.ErrorSynonym;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.ResultBean;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.*;

/**
 * @Author: wangao
 * @CreateTime: 2024-03-29  15:52
 * @Description: TODO
 * @Version: 1.0
 */
@Service
public class ErrorSynonymService implements IErrorSynonymService {
    @Autowired
    private ErrorSynonymDao errorSynonymDao;
    @Override
    public ResultBean<?> insertOrUpdate( ErrorSynonym errorSynonym) {
        try {
            errorSynonymDao.insert(errorSynonym);
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
        return ResultBean.success(null);
    }
    @Override
    public ResultBean<?> getOne( String fileName) {
        try {
            return ResultBean.success(errorSynonymDao.getOne(fileName));
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
    }
}
