package com.digiwin.athena.knowledgegraph.synonym.controller.impl;

import com.digiwin.athena.knowledgegraph.synonym.controller.ISyncAppInfoService;
import com.digiwin.athena.knowledgegraph.synonym.dao.SyncAppInfoDao;
import com.digiwin.athena.knowledgegraph.synonym.domain.EntityTypeConfig;
import com.digiwin.athena.knowledgegraph.synonym.domain.LocalAppInfo;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.DeleteVo;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.ResultBean;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Author: wangao
 * @CreateTime: 2024-06-06  16:52
 * @Description: TODO
 * @Version: 1.0
 */
@Service
public class SyncAppInfoServiceImpl implements ISyncAppInfoService {
   @Autowired
   private SyncAppInfoDao syncAppInfoDao;

    @Override
    public ResultBean<?> insertLocalAll(List<LocalAppInfo> localAppInfos) {
        if (localAppInfos == null || localAppInfos.isEmpty()) {
            return ResultBean.success(null);
        }
        syncAppInfoDao.insertLocalList(localAppInfos);
        return ResultBean.success(null);
    }


    @Override
    public ResultBean<Object> deleteLocal(DeleteVo deleteVo) {
        try {
            syncAppInfoDao.deleteLocal(deleteVo.getIds());
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
        return ResultBean.success(null);
    }

    @Override
    public ResultBean<Object> deleteEntityConfig(DeleteVo deleteVo) {
        try {
            syncAppInfoDao.deleteEntityConfig(deleteVo.getId(),deleteVo.getTid());
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
        return ResultBean.success(null);
    }


    @Override
    public ResultBean<Object> getFindLocalList(String tenantId) {
        return ResultBean.success(syncAppInfoDao.getLocalList(tenantId));
    }

    @Override
    public ResultBean<Object> getFindLocal(String id) {
        return ResultBean.success(syncAppInfoDao.find(id));
    }


    @Override
    public ResultBean<Object> getFindAll() {
        return ResultBean.success(syncAppInfoDao.getAll());
    }

    @Override
    public ResultBean<Object> getEntityConfigs(String appName, String appType) {
        return ResultBean.success(syncAppInfoDao.getEntityConfigs(appName,appType));
    }

    @Override
    public ResultBean<Object> updateLocal(LocalAppInfo localAppInfo) {
        syncAppInfoDao.updateLocal(localAppInfo);
        return ResultBean.success(null);
    }
    @Override
    public ResultBean<Object> updateEntityTypeConfig(EntityTypeConfig entityTypeConfig) {
        syncAppInfoDao.updateEntityTypeConfig(entityTypeConfig);
        return ResultBean.success(null);
    }
    @Override
    public ResultBean<?> saveEntityConfigAll(List<EntityTypeConfig> configs) {
        if (configs == null || configs.isEmpty()) {
            return ResultBean.success(null);
        }
        syncAppInfoDao.saveConfigsAll(configs);
        return ResultBean.success(null);
    }

    @Override
    public ResultBean<?> saveLocalAll(List<LocalAppInfo> localAppInfos) {
        if (localAppInfos == null || localAppInfos.isEmpty()) {
            return ResultBean.success(null);
        }
        syncAppInfoDao.saveAll(localAppInfos);
        return ResultBean.success(null);
    }

}
