package com.digiwin.athena.knowledgegraph.synonym.dao;



import com.digiwin.athena.knowledgegraph.synonym.domain.QuerySmartUserConfigRequest;
import com.digiwin.athena.knowledgegraph.synonym.domain.SmartUserConfig;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author: zjz
 * @CreateTime: 2024-08-06  13:08
 * @Description:
 * @Version: 1.0
 */
@Repository
public class SmartUserConfigDao {
    @Autowired
    @Qualifier("knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate systemMongoTemplate;

    public void saveAll(List<SmartUserConfig> configs){
        if (CollectionUtils.isEmpty(configs)){
            return;
        }
        //先删除再新增
        List<String> collect = configs.stream().map(SmartUserConfig::getId).collect(Collectors.toList());
        delete(collect);
        // 填充创建时间
        configs.forEach(config->config.setCreateDate(new Date()));
        mongoTemplate.insertAll(configs);
    }

    public List<SmartUserConfig> findList(QuerySmartUserConfigRequest findVo){
        if (StringUtils.isEmpty(findVo.getTenantId())){
            throw new BusinessException("租户id不能为空");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(Criteria.where("tenantId").is(findVo.getTenantId()));
        if (StringUtils.isNotEmpty(findVo.getKeyWord())){
            criteria.orOperator(Criteria.where("userId").regex(findVo.getKeyWord())
                    , Criteria.where("userName").regex(findVo.getKeyWord()));
        }
        if(StringUtils.isNotEmpty(findVo.getUserId())){
            criteria.and("userId").is(findVo.getUserId());
        }
        if(!CollectionUtils.isEmpty(findVo.getIdList())){
            criteria.and("id").in(findVo.getIdList());
        }
        query.addCriteria(criteria).with(Sort.by(Sort.Direction.DESC, "createDate"));
        return this.mongoTemplate.find(query, SmartUserConfig.class);
    }


    public void delete(List<String> idList){
        if (CollectionUtils.isEmpty(idList)){
            return;
        }
        Query query = new Query(Criteria.where("id").in(idList));
        this.mongoTemplate.remove(query,SmartUserConfig.class);
    }
    public void dataMigration(){
        long count = systemMongoTemplate.count(new Query(), SmartUserConfig.class);
        if (count > 0){
            List<SmartUserConfig> appThresholdConfigs = systemMongoTemplate.find(new Query(), SmartUserConfig.class);
            mongoTemplate.insertAll(appThresholdConfigs);
        }
    }
}
