package com.digiwin.athena.knowledgegraph.synonym.domain;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Map;

/**
 * @Author: wangao
 * @CreateTime: 2024-08-27  15:08
 * @Description:
 * @Version: 1.0
 */
@Data
@Accessors(chain = true)
@Document(collection = "agiledata_business_variables")
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BusinessVariables {
    @Id
    private String id;
    private String appCode;
    private String data_name;
    private String code;
    /**
     * enum EFieldTypes {
     *   String = 'string',
     *   Date = 'date',
     *   Numeric = 'numeric',
     *   Boolean = 'boolean',
     * }
     */
    private String data_type;
    //说明
    private String name;
    private String source;
    //描述
    private String description;
    //0 其他（非包含 不包含） 1 包含 不包含
    private Integer operationTag;

    private String lang;

    private String updateDate;

    private String updateBy;

    private String version;

    private String compileVersion;
}
