package com.digiwin.athena.knowledgegraph.synonym.domain;

import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
@Document(collection = "smartUserConfig")
public class SmartUserConfig {
    @Id
    private String id;

    private String tenantId;

    private String userId;

    private String userName;

    private Object createBy;

    @DateTimeFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date createDate;

    private Object editBy;

    @DateTimeFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date editDate;

    private Integer delFlag;
}
