package com.digiwin.athena.knowledgegraph.task;


import com.digiwin.athena.kmservice.utils.TranslateUtil;
import com.digiwin.athena.kg.activity.ActivityConfig;
import com.digiwin.athena.knowledgegraph.repoSystem.ActivityConfigRepository;
import com.digiwin.athena.knowledgegraph.task.model.ActivityConfigDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service
public class ActivityConfigService  {
    @Autowired
    ActivityConfigRepository activityConfigRepository;


    public ActivityConfigDTO getConfigByCode(String code) throws IllegalAccessException {
        ActivityConfig config = activityConfigRepository.findOneByCode(code);
        if (config == null) {
            return null;
        }

        //按返回格式填充
        ActivityConfigDTO configDTO = new ActivityConfigDTO();
        configDTO.setCode(config.getCode());
        configDTO.setMultipleSelect(config.getMultipleSelect());
        configDTO.setTitle(ProcessLanguage("title",config, config.getTitle()));
        configDTO.setSubTitle(ProcessLanguage("subTitle",config, config.getSubTitle()));
        configDTO.setDescription(ProcessLanguage("description",config, config.getDescription()));
        configDTO.setSubDescription(ProcessLanguage("subDescription",config, config.getSubDescription()));
        configDTO.setGetDataAction(ProcessMapLanguage(config.getGetDataAction()));
        configDTO.setRelationQueries(ProcessListLanguage(config.getRelationQueries()));
        configDTO.setSubmitActions(ProcessListLanguage(config.getSubmitActions()));
        configDTO.setSummaryFields(ProcessListLanguage(config.getSummaryFields()));
        configDTO.setFilters(ProcessListLanguage(config.getFilters()));
        configDTO.setOperations(ProcessListLanguage(config.getOperations()));
        configDTO.setGroupFields(ProcessListLanguage(config.getGroupFields()));
        configDTO.setGetTaskData(ProcessMapLanguage(config.getGetTaskData()));
        configDTO.setCheckItems(ProcessListLanguage(config.getCheckItems()));
        configDTO.setReason(ProcessMapLanguage(config.getReason()));
        configDTO.setGetFormulaAction(ProcessMapLanguage(config.getGetFormulaAction()));
        configDTO.setCountItems(ProcessMapLanguage(config.getCountItems()));

        return configDTO;
    }

    private Object ProcessLanguage(String key, ActivityConfig config, String defaultValue) {
        //处理多语言
        if (config.getLanguage() != null) {
            Map lang = config.getLanguage().get(key);
            if (lang != null) {
                lang.put("zh_CN", defaultValue);
                return lang;
            }
        }

        return defaultValue;
    }

    private Map<String, Object> ProcessMapLanguage(Map<String, Object> data) {
        if (data == null || data.isEmpty()) {
            return data;
        }

        Map<String, Map> langMap = (Map<String, Map>) data.get("language");
        if (langMap != null) {
            for (Map.Entry<String, Map> lang : langMap.entrySet()) {
                String key = lang.getKey();
                Map value = lang.getValue();
                if (key == null || key.isEmpty() || value == null || value.isEmpty()) {
                    continue;
                }
                Object defValue = data.get(key);
                value.put("zh_CN", defValue);
                data.put(key, value);
            }
            data.remove("language");
        }
        for (Map.Entry<String, Object> item : data.entrySet()) {
            Object value = item.getValue();
            if (value instanceof Map) {
                data.put(item.getKey(), ProcessMapLanguage((Map<String, Object>) value));
            } else if (value instanceof List) {
                data.put(item.getKey(), ProcessListLanguage((List)value));
            }
        }

        return data;
    }

    private List ProcessListLanguage(List data) {
        if (data == null || data.isEmpty()) {
            return data;
        }

        List re = new ArrayList(data.size());
        for (Object obj : data) {
            if (obj instanceof Map) {
                re.add(ProcessMapLanguage((Map<String, Object>) obj));
            } else {//不是map暂不处理
                re.add(obj);
            }
        }

        return re;
    }

    public ActivityConfigDTO getConfigByCodeLocale(String activityCode, String pageCode, String locale) {
        ActivityConfig config = activityConfigRepository.findOneByCode(activityCode);
        if (config == null) {
            return null;
        }

        //按返回格式填充
        ActivityConfigDTO configDTO = new ActivityConfigDTO();
        configDTO.setCode(config.getCode());
        configDTO.setDataSources(config.getDataSources());
        configDTO.setDataFilters(SetListLanguage(config.getDataFilters(), locale));
        configDTO.setApproves(config.getApproves());
        configDTO.setDataProcessors(SetListLanguage(config.getDataProcessors(), locale));
        configDTO.setMessages(config.getMessages());
        configDTO.setExpectedDuration(config.getExpectedDuration());
        configDTO.setAttachment(SetMapLanguage(config.getAttachment(),locale));
        configDTO.setActivityParameter(SetMapLanguage(config.getActivityParameter(),locale));
        TranslateUtil.dealLangRecusive(configDTO.getMessages(),locale);
        //仅返回指定的page
        if (config.getPages() != null) {
            Map<String, Object> page = (Map<String, Object>) config.getPages().get(pageCode);
            if (page != null) {
                configDTO.setPages(SetMapLanguage(page, locale));
            }
        }

        return configDTO;
    }

    private Map<String, Object> SetMapLanguage(Map<String, Object> data, String locale) {
        if (data == null || data.isEmpty()) {
            return data;
        }

        Map<String, Map> langMap = (Map<String, Map>) data.get("language");
        if (langMap != null) {
            for (Map.Entry<String, Map> lang : langMap.entrySet()) {
                String key = lang.getKey();
                Map value = lang.getValue();
                if (key == null || key.isEmpty() || value == null || value.isEmpty()) {
                    continue;
                }
                //如果获取不到对应语言别的内容 则保留使用默认语言别内容
                String val = (String) value.get(locale);
                if (val != null && !val.isEmpty()) {
                    data.put(key, val);
                }
            }
            data.remove("language");
        }
        for (Map.Entry<String, Object> item : data.entrySet()) {
            Object value = item.getValue();
            if (value instanceof Map) {
                data.put(item.getKey(), SetMapLanguage((Map<String, Object>) value, locale));
            } else if (value instanceof List) {
                data.put(item.getKey(), SetListLanguage((List)value, locale));
            }
        }

        return data;
    }

    private List SetListLanguage(List data, String locale) {
        if (data == null || data.isEmpty()) {
            return data;
        }

        List re = new ArrayList(data.size());
        for (Object obj : data) {
            if (obj instanceof Map) {
                re.add(SetMapLanguage((Map<String, Object>) obj, locale));
            } else {//不是map不处理
                re.add(obj);
            }
        }

        return re;
    }
}