package com.digiwin.athena.knowledgegraph.utils;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class TenantInitResultUtil {

    public static final String RENEW = "RENEW";
    public static final String ONLY_FLOW = "ONLY_FLOW";
    /**
     *  历史原因 1的时候表示成功  3的时候表示流程模板失败，所以此处直接从 1 << 2 开始
     */
    public static short ERROR_NO_FLOW_TEMPLATE = 1 << 2;
    public static short ERROR_INIT_PARADIGM = 1 << 3;
    public static short ERROR_INIT_MONITORRULE = 1 << 4;
    public static short ERROR_SYNC_DUTY = 1 << 5;
    public static short ERROR_SYNC_LEVEL = 1 << 6;
    public static short ERROR_INIT_DATAMAP = 1 << 7;
    public static short ERROR_START_ENTERPRISE_OPERATION = 1 << 8;
    public static short ERROR_CREATE_NEO4J_ENTITY = 1 << 9;
    public static short ERROR_NO_APP_ENTITY = 1 << 10;




    /**
     * 新增某个标记
     * @param currentFlag
     * @param errorFlag
     * @return
     */
    public static short addErrorFlag(short currentFlag, short errorFlag){
        return  (short)(currentFlag | errorFlag);
    }

    /**
     * 判断是否存在某个标记
     * @param currentFlag
     * @param errorFlag
     * @return
     */
    public static boolean hasErrorFlag(short currentFlag, short errorFlag){
        return  (currentFlag & errorFlag) > 0 ;
    }

    /**
     * 去除某个标记
     * @param currentFlag
     * @param errorFlag
     * @return
     */
    public static short deductErrorFlag(short currentFlag, short errorFlag){
        return  (short) (currentFlag & ~errorFlag) ;
    }


    public static boolean hasNoError(short currentFlag){
        return currentFlag < 2;
    }

    public static boolean needExecute(String initType, short initPartFlag, short flag){
        if(initType == null || initType.equals(RENEW)){ //初始化或者续约时，直接执行
            return true;
        }

        return hasErrorFlag(initPartFlag, flag);
    }

    public static void main(String[] args) {
//        short currentFlag = 0;
//        short i = addErrorFlag(currentFlag, ERROR_NO_FLOW_TEMPLATE);
//        System.out.println(i);
//        i = addErrorFlag(i, ERROR_INIT_PARADIGM);
//        System.out.println(i);
//        boolean b = hasErrorFlag(i, ERROR_INIT_PARADIGM);
//        System.out.println(b);
//        b = hasErrorFlag(i, ERROR_INIT_PARADIGM);
//        System.out.println(b);
//        short i1 = deductErrorFlag(i, ERROR_SYNC_DUTY);
//        System.out.println(i1);
//        b = hasErrorFlag(i1, ERROR_INIT_PARADIGM);
//        System.out.println(b);
//        i1 = deductErrorFlag(i1, ERROR_NO_FLOW_TEMPLATE);
//        System.out.println(i1);
    }
}
