package com.digiwin.athena.knowledgegraph.vo.mechanism;

import lombok.Data;

import java.util.LinkedList;
import java.util.Map;

/**
 * @Description 查询机制API的请求实体
 * @Author liugl
 * @Date 2024/6/26 9:13
 **/
@Data
public class MechanismApiInfoReqVO{
	/**
	 * 机制code
	 */
	private String mechanismCode;
	/**
	 * api，ESP的serviceId或者是内部方法名称
	 */
	private String api;

	/**
	 * 机制能力
	 */
	private String abilityType;
	/**
	 * 限制判断条件
	 */
	private String limitConditionType;

	/**
	 * 限制执行条件
	 */
	private String limitActionType;

	/**
	 * 是否需要通过esp调用方法
	 */
	private Boolean isNeedEsp;
	/**
	 * 请求入参
	 */
	private Object requestJson;

	/**
	 * 表格数据
	 */
	private Object tableData;

	/**
	 * 开窗内部数据信息{字段名，字段内部开窗actionId}
	 */
	private Map<String, String> openWindow;

	/**
	 * 机制能力
	 */
	private Object ability;

	/**
	 * 判断表格数据唯一性的字段名集合
	 */
	private LinkedList<String> keyFieldNameList;
}
