package com.digiwin.athena.knowledgegraph.vo.workbenchSetting;

import com.digiwin.athena.knowledgegraph.enums.BusinessMessageSourceMethod;
import com.digiwin.athena.knowledgegraph.enums.Dimensionality;
import com.digiwin.athena.knowledgegraph.enums.PointInTime;
import com.digiwin.athena.knowledgegraph.enums.SourceType;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 * 交付设计器的待办工作台设置中的条件
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class WSConditionVO {

    /**
     * pageview的createDate，用来排序
     */
    private Long createDate;
    /**
     * 应用编码
     */
    private String appCode;
    /**
     * 应用名称
     */
    private String appName;
    /**
     * 任务编码
     */
    private String taskCode;
    /**
     * 任务名称
     */
    private String taskName;
    /**
     * 此条件对应任务的多语系
     */
    public Map<String, Map<String, String>> taskLang;

    private BusinessMessageSourceMethod businessMessageSourceMethod;
    /**
     * 名称
     */
    private String aliasName;
    /**
     * 代号
     */
    private String aliasCode;

    /**
     * 交付设计器，常规分组条件是否选中
     */
    private Boolean commonEnable;

    /**
     * 交付设计器界面拖拽排序
     */
    private Integer sort;
    /**
     * 类型
     */
    private String dataType;
    /**
     * 来源类型
     */
    private SourceType sourceType;
    /**
     * 项目阶段类型
     */
    private List<PointInTime> pointInTime;
    /**
     * 时间维度
     */
    private List<Dimensionality> dimensionality;
    /**
     * CardGroupGroup中的字段，常规条件列表，默认分组
     */
    private Boolean defaultEffective;

    /**
     * 是否启用
     */
    private Boolean enable;

    /**
     * 分组下，常规条件列表，默认分组，前端取值
     */
    private Boolean defaultGroup;

    /**
     * 多语系
     */
    public Map<String, Map<String, String>> lang;

    /**
     * 生效范围
     */
    private List<ConditionScopeVO> conditionScope;
}
