package com.digiwin.athena.knowledgegraph.workbenchSetting;

import com.digiwin.athena.knowledgegraph.dto.WSConditionDTO;
import com.digiwin.athena.knowledgegraph.enums.WSPageCode;
import com.digiwin.athena.knowledgegraph.enums.WSConfigType;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@AllArgsConstructor
@NoArgsConstructor
@Data
public class WorkbenchSettingSaveRequest implements Serializable {
    /**
     * 主键id
     */
    private String id;
    /**
     * WS配置类型 排序/筛选/分组
     */
    @NotNull
    private WSConfigType configType;
    /**
     * WS页面类型 任务/项目
     */
    @NotNull
    private WSPageCode pageCode;

    /**
     *租户自定义的条件
     */
    private List<WSConditionDTO> condition;
    /**
     * 默认的条件配置
     */
    private List<WSConditionDTO> defaultCondition;
}
