package com.digiwin.athena.repository.neo4j;


import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.knowledgegraph.domain.TenantABIReportDAO;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;

import java.util.List;
import java.util.Map;

public interface Activity2Repository extends Neo4jRepository<Activity, Long> {

  //  @Query("match(t:Task)-[:Contains]->(a:Activity) where t.code=$0 and a.code=$1 and (a.levelId=$2 or a.level is null) return a")
    @Query("match(t:Task)-[:Contains]->(a:Activity) where t.code=$0 and a.code=$1 and (a.tenantId in ['SYSTEM',$2] or a.tenantId is null or $2 in a.inclusionTenant) return a")
    List<Activity> getActivityDefinition(String taskCode, String activityCode, String tenantId);

//    @Query("match (te:TenantEntity)-[:ACTIVITY]->(a:Activity{code:$1,version:$2}) " +
//            "where (te.tenantId = $0 and te.version = $2) or (te.ifCommon=true or te.version = $2) return a")
    @Query("match (a:Activity{code:$1,version:$2}) " +
        "where (a.tenantId in ['SYSTEM',$0] or a.tenantId is null or $0 in a.inclusionTenant) return a")
    List<Activity> getActivityByCode(String tenantId, String activityCode, String tenantVersion);

    @Query("MATCH (activity:Activity) where activity.code = $0 and activity.version = $1 and (activity.tenantId in ['SYSTEM',$2] or activity.tenantId is null or $2 in activity.inclusionTenant)" +
            "return activity")
    List<Activity> getActivityByCodeAndVersion(String activityCode, String tenantVersion, String tenantId);

//    @Query("match (te:TenantEntity)-[:ACTIVITY]->(a:Activity{pattern:$1,version:$2}) " +
//            "where (te.tenantId = $0 and te.version = $2) or (te.ifCommon=true and te.version = $2) return a")
    @Query("match (a:Activity{pattern:$1,version:$2}) " +
        "where a.tenantId in ['SYSTEM',$0] or a.tenantId is null or $0 in a.inclusionTenant  return a")
    List<Activity> getActivitiesByPattern(String tenantId, String pattern, String tenantVersion);


    @Query("match (a:Activity{pattern:$1,version:$2}) where (a.tenantId in ['SYSTEM',$0] or a.tenantId is null or $0 in a.inclusionTenant) and a.code in $3  return a")
    List<Activity> getActivitiesByPattern(String tenantId, String pattern, String tenantVersion,List<String> codes);

    @Query("match (a:Activity{nameSpace:'common'}) where a.tenantId in ['SYSTEM',$0] or a.tenantId is null or $0 in a.inclusionTenant" +
            "return a")
    List<Activity> getCommonBaseData(String tenantId);

//    @Query("match (te:TenantEntity{tenantId:$1})-[:ACTIVITY]->(a:Activity{version:$2}) where a.code in $0 return a")
    @Query("match (a:Activity{version:$2}) where a.code in $0  and (a.tenantId in ['SYSTEM',$1] or a.tenantId is null or $1 in a.inclusionTenant) return a")
    List<Activity> getReportActivitiesByCode(List<String> reportCodes, String tenantId, String tenantVersion);

//    @Query("match (te:TenantEntity{tenantId:$1})-[:ACTIVITY]->(a:Activity{code:$0,version:$2}) return a")
    @Query("match (a:Activity{code:$0,version:$2}) where (a.tenantId in ['SYSTEM',$1] or a.tenantId is null or $1 in a.inclusionTenant) return a")
    List<Activity> getReportActivitiesByCode(String reportCode, String tenantId, String tenantVersion);

//    @Query("match(te:TenantEntity{tenantId:$0})-[:TASK]->(task:Task{version:$2})-[:Contains]->(a:Activity{code:$1}) return a")
    @Query("match(task:Task{version:$2})-[:Contains]->(a:Activity{code:$1}) where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null or $1 in task.inclusionTenant) return a")
    List<Activity> findActivity(String tenantId, String bizCode, String tenantVersion);

    @Query("MATCH (n:Activity) where  ((n.pattern <> 'DATA_ENTRY' and n.pattern <>'STATEMENT') OR n.pattern IS NULL) and  n.code = $0  RETURN n")
    Activity findActivityNoTenantId(String bizCode);

    //@Query("match (te:TenantEntity{tenantId:$0})-[:TASK]->()-[:Contains]->(a:Activity{version:$2}) where a.code in $1 return a")
    @Query("match (a:Activity{version:$2}) where a.code in $1 and (a.tenantId in ['SYSTEM',$0] or a.tenantId is null or $0 in a.inclusionTenant) return a")
    List<Activity> getActivitiesByCode(String tenantId, List<String> bizCodes, String tenantVersion);

//    @Query("match (te:TenantEntity{tenantId:$1})-[:ACTIVITY]->(n{version:$2}) where n.pattern = \"DATA_ENTRY\" and (n.name =~$0 or n.`lang.name.zh_TW` =~$0 or n.`lang.name.en_US` =~ $0 or n.`lang.name.zh_CN` =~ $0) return n")
    @Query("match (n:Activity{version:$2}) where n.pattern = \"DATA_ENTRY\" and (n.name =~$0 or n.`lang.name.zh_TW` =~$0 or n.`lang.name.en_US` =~ $0 or n.`lang.name.zh_CN` =~ $0) and (n.tenantId in ['SYSTEM',$1] or n.tenantId is null or $1 in n.inclusionTenant) return n")
    List<Activity> getDataEntryByName(String condition, String tenantId, String tenantVersion);

//    @Query("match (te:TenantEntity)-[:ACTIVITY]->(n{version:$2}) where (te.ifCommon=true or te.version = $2) and n.pattern = \"DATA_ENTRY\" and (n.name =~$0 or n.`lang.name.zh_TW` =~$0 or n.`lang.name.en_US` =~ $0 or n.`lang.name.zh_CN` =~ $0) return n")
    @Query("match(n:Activity{version:$2}) where  n.pattern = \"DATA_ENTRY\" and (n.name =~$0 or n.`lang.name.zh_TW` =~$0 or n.`lang.name.en_US` =~ $0 or n.`lang.name.zh_CN` =~ $0) and (n.tenantId in ['SYSTEM',$1] or n.tenantId is null or $1 in n.inclusionTenant) return n")
    List<Activity> getCommonDataEntryByName(String condition, String tenantId, String tenantVersion);

    @Query("match (n:Activity)  where n.pattern = \"DATA_ENTRY\" and n.nameSpace = $0 return n")
    List<Activity> getDataEntryByNameSpace(String nameSpace);

//    @Query("match (te:TenantEntity{tenantId:$1})-[:ACTIVITY]->(n) where n.pattern = \"STATEMENT\" and (n.name =~$0 or n.`lang.name.zh_TW` =~$0 or n.`lang.name.en_US` =~ $0 or n.`lang.name.zh_CN` =~ $0) return n")
    @Query("match (n:Activity{version:$2}) where n.pattern = \"STATEMENT\" and (n.name =~$0 or n.`lang.name.zh_TW` =~$0 or n.`lang.name.en_US` =~ $0 or n.`lang.name.zh_CN` =~ $0) and (n.tenantId in ['SYSTEM',$1] or n.tenantId is null or $1 in n.inclusionTenant) return n")
    List<Activity> getStatementsByName(String condition, String tenantId, String tenantVersion);


//    @Query("match (te:TenantEntity)-[:ACTIVITY]->(n{version:$2}) where (te.ifCommon=true or te.version = $2) and n.pattern = \"STATEMENT\" and (n.name =~$0 or n.`lang.name.zh_TW` =~$0 or n.`lang.name.en_US` =~ $0 or n.`lang.name.zh_CN` =~ $0) return n")
    @Query("match (n:Activity{version:$2}) where  n.pattern = \"STATEMENT\" and (n.name =~$0 or n.`lang.name.zh_TW` =~$0 or n.`lang.name.en_US` =~ $0 or n.`lang.name.zh_CN` =~ $0) and (n.tenantId in ['SYSTEM',$1] or n.tenantId is null or $1 in n.inclusionTenant) return n")
    List<Activity> getCommonStatementsByName(String condition, String tenantId, String tenantVersion);

    @Query("match (t:Activity) return distinct t.code as code, t.name as name , t.nameSpace as nameSpace")
    List<Map> getAllActivity();

    Activity findOneByCode(String code);

    @Query("match (t:TenantEntity)-[]->(a:Activity) where a.category = \"ABI-STATEMENT\" return t.tenantId as tenantId, t.tenantName as tenantName, a.code as code,a.nameSpace as namespace,a.athena_namespace as athenaNamespace")
    List<TenantABIReportDAO> getAllABiReport();

    @Query("match(a:Activity) where a.category = 'ABI-STATEMENT' return distinct  a.code as code")
    List<String> getAllABiReportCodes();

}
