package com.digiwin.athena.repository.neo4j;

import com.digiwin.athena.knowledgegraph.domain.IndicatorNode;
import org.springframework.data.neo4j.annotation.Depth;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;

import java.util.List;

public interface IndicatorRepository extends Neo4jRepository<IndicatorNode, Long> {

    @Depth(-1)
    List<IndicatorNode> findAllByIndicatorIdIn(List<String> indicatorIds);

    @Query("match (a:IndicatorNode)\n" +
            "optional match (n:IndicatorNode)-[s:ConsistsOf]->(a) \n" +
            "with s,a\n" +
            "where s is NULL return a")
    List<IndicatorNode> findRootIndicatorNodes();
}
